/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel;

import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.dss.LongDataTensor;
import com.dataiku.dip.pivot.backend.dss.TensorType;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.pivot.frontend.excel.BaseDataSheet2DBuilder;
import com.dataiku.dip.pivot.frontend.excel.CellStyler;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartUtils;
import com.dataiku.dip.pivot.frontend.excel.xssf.SheetUtils;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dip.pivot.frontend.model.DimensionDef;
import com.dataiku.dip.pivot.frontend.model.FontFormatting;
import com.dataiku.dip.pivot.frontend.model.MeasureDef;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.BorderStyle;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Cell;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.CellStyle;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.FillPatternType;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Font;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Workbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.util.CellRangeAddress;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFCellStyle;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFColor;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFFont;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFRow;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFSheet;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;

public class PivotTableDataSheetBuilder
extends BaseDataSheet2DBuilder {
    private static final String PATH_DELIMITER = "-";
    private static final int CHARACTER_UNIT_WIDTH = 256;

    public static void buildMatrixSheet(XSSFWorkbook workbook, ChartDef chartDef, PivotTableTensorResponse response, int animationFrameIdx, @Nullable List<FontFormatting> colorMaps) {
        XSSFSheet sheet = workbook.createSheet("Data");
        CellStyler styler = new CellStyler((Workbook)workbook);
        SheetReference sheetRef = new SheetReference(sheet, styler, 0, 0);
        Integer animationFrameIndex = chartDef.animationDimension.isEmpty() ? null : Integer.valueOf(animationFrameIdx);
        List<DimensionDef> xDimensions = ChartUtils.getXDimensions(chartDef);
        List<DimensionDef> yDimensions = ChartUtils.getYDimensions(chartDef);
        boolean hasRowMeasures = !xDimensions.isEmpty() && (yDimensions.isEmpty() || ChartDef.PivotTableMeasureDisplayMode.ROWS.equals((Object)chartDef.pivotTableOptions.measureDisplayMode)) && chartDef.genericMeasures.size() > 1;
        boolean hasColumnMeasures = !yDimensions.isEmpty() && (xDimensions.isEmpty() || ChartDef.PivotTableMeasureDisplayMode.COLUMNS.equals((Object)chartDef.pivotTableOptions.measureDisplayMode) && chartDef.genericMeasures.size() > 1);
        ArrayList<Map<String, XSSFColor>> backgroundColorMapping = null;
        ArrayList<Map<String, XSSFColor>> fontColorMapping = null;
        if (colorMaps != null && !colorMaps.isEmpty()) {
            backgroundColorMapping = new ArrayList<Map<String, XSSFColor>>();
            fontColorMapping = new ArrayList<Map<String, XSSFColor>>();
            for (int measureIndex = 0; measureIndex < colorMaps.size(); ++measureIndex) {
                FontFormatting.getColorMapping(workbook, measureIndex, colorMaps.get(measureIndex).getBackgroundColorMap(), backgroundColorMapping);
                FontFormatting.getColorMapping(workbook, measureIndex, colorMaps.get(measureIndex).getFontColorMap(), fontColorMapping);
            }
        }
        int numXDimension = xDimensions.size();
        ArrayList<List<String>> rowLabels = new ArrayList<List<String>>();
        ArrayList<List<String>> columnLabels = new ArrayList<List<String>>();
        for (int i = 0; i < response.axisLabels.length; ++i) {
            List labels = response.axisLabels[i].stream().map(axisElt -> ChartUtils.labelify(axisElt.label)).collect(Collectors.toList());
            if (i < numXDimension) {
                columnLabels.add(labels);
                continue;
            }
            rowLabels.add(labels);
        }
        PivotTableDataSheetDimensionBuilder xDimensionBuilder = new PivotTableDataSheetDimensionBuilder(xDimensions, columnLabels);
        PivotTableDataSheetDimensionBuilder yDimensionBuilder = new PivotTableDataSheetDimensionBuilder(yDimensions, rowLabels);
        PivotTableFilterBuilderVisitor filterVisitor = new PivotTableFilterBuilderVisitor(xDimensionBuilder, response.counts, yDimensionBuilder.dimensions.size() - 1, animationFrameIndex);
        yDimensionBuilder.accept(filterVisitor, null);
        xDimensionBuilder.filters = filterVisitor.visibleColumns;
        yDimensionBuilder.filters = filterVisitor.visibleRows;
        SheetUtils.writeCell(sheet, sheetRef.row++, sheetRef.column, chartDef.name).setCellStyle(styler.getTitleStyle());
        if (chartDef.genericMeasures.size() == 1) {
            SheetUtils.writeCell(sheet, sheetRef.row++, sheetRef.column, com.dataiku.dip.pivot.frontend.ChartUtils.getNiceMeasureName(chartDef.genericMeasures.get(0))).setCellStyle(styler.getSubtitleStyle());
        }
        CellStyle headerStyle = styler.getHeaderStyle();
        int initialColumn = sheetRef.column;
        int targetRow = sheetRef.row + xDimensions.size() * 2;
        if (!hasColumnMeasures) {
            --targetRow;
        }
        for (DimensionDef dimension : yDimensions) {
            sheetRef.writeCell(targetRow, sheetRef.column++, com.dataiku.dip.pivot.frontend.ChartUtils.getNiceDimensionName(dimension), headerStyle);
        }
        if (hasRowMeasures) {
            sheetRef.writeCell(targetRow, sheetRef.column++, "Value", headerStyle);
        }
        int maxXDepth = columnLabels.size() - (hasColumnMeasures ? 0 : 1);
        xDimensionBuilder.accept(new PivotTableColumnHeaderBuilderVisitor(sheetRef, maxXDepth), hasColumnMeasures ? chartDef.genericMeasures : null);
        sheetRef.column = initialColumn;
        sheetRef.row = targetRow + 1;
        int maxYDepth = rowLabels.size() - (hasRowMeasures ? 0 : 1);
        yDimensionBuilder.accept(new PivotTableRowBuilderVisitor(sheetRef, maxYDepth, chartDef.genericMeasures, response.aggregations, xDimensionBuilder, animationFrameIndex, chartDef.colorMode, response.counts, backgroundColorMapping, fontColorMapping), hasRowMeasures ? chartDef.genericMeasures : null);
        PivotTableDataSheetBuilder.addBottomBorder(sheet);
        PivotTableDataSheetBuilder.appendFilteringDetails(chartDef, sheet);
        sheetRef.computeColumnsWidth();
    }

    private static void addBottomBorder(XSSFSheet sheet) {
        XSSFRow row = sheet.getRow(sheet.getLastRowNum());
        for (Cell cell : row) {
            XSSFCellStyle style = ((XSSFCellStyle)cell.getCellStyle()).copy();
            style.setBorderBottom(BorderStyle.THIN);
            cell.setCellStyle((CellStyle)style);
        }
    }

    private static class SheetReference {
        public XSSFSheet sheet;
        public CellStyler styler;
        public int row;
        public int column;
        public TIntIntMap columnLengths = new TIntIntHashMap();

        public SheetReference(XSSFSheet sheet, CellStyler styler, int row, int column) {
            this.sheet = sheet;
            this.styler = styler;
            this.row = row;
            this.column = column;
        }

        public void writeCell(int row, int column, String value, CellStyle style) {
            int length;
            int n = length = value == null ? 1 : value.length();
            if (this.columnLengths.containsKey(column)) {
                this.columnLengths.put(column, Math.max(this.columnLengths.get(column), length));
            } else {
                this.columnLengths.put(column, length);
            }
            SheetUtils.writeCell(this.sheet, row, column, value).setCellStyle(style);
        }

        public void writeCell(int row, int column, double value, CellStyle style) {
            if (this.columnLengths.containsKey(column)) {
                this.columnLengths.put(column, Math.max(this.columnLengths.get(column), Double.toString(value).length()));
            } else {
                this.columnLengths.put(column, Double.toString(value).length());
            }
            SheetUtils.writeCell(this.sheet, row, column, value).setCellStyle(style);
        }

        public void writeCell(int row, int column, DateTime value, CellStyle style) {
            if (value != null) {
                String stringValue = value.toString("yyyy-MM-dd");
                if (this.columnLengths.containsKey(column)) {
                    this.columnLengths.put(column, Math.max(this.columnLengths.get(column), stringValue.length()));
                } else {
                    this.columnLengths.put(column, stringValue.length());
                }
            }
            SheetUtils.writeCell(this.sheet, row, column, value).setCellStyle(style);
        }

        public void computeColumnsWidth() {
            this.columnLengths.forEachEntry((columnIdx, length) -> {
                this.sheet.setColumnWidth(columnIdx, length * 256);
                return true;
            });
        }
    }

    private static class PivotTableDataSheetDimensionBuilder {
        public Set<String> filters = null;
        private final List<DimensionDef> dimensions;
        private final List<List<String>> labels;

        public PivotTableDataSheetDimensionBuilder(List<DimensionDef> dimensions, List<List<String>> labels) {
            this.dimensions = dimensions;
            this.labels = labels;
        }

        public void accept(AbstractPivotTableVisitor visitor, @Nullable List<MeasureDef> measures) {
            if (this.dimensions.isEmpty()) {
                this.accept1D(visitor, measures);
            } else {
                this.accept2D(visitor, measures);
            }
        }

        private void accept1D(AbstractPivotTableVisitor visitor, @Nullable List<MeasureDef> measures) {
            visitor.visit(0, -1, null, null, true);
            if (measures != null) {
                int numMeasures = measures.size();
                for (int m = 0; m < numMeasures; ++m) {
                    visitor.visit(m, 0, measures.get(m));
                    visitor.leave(m, 0);
                }
            }
            visitor.leave(0, -1);
        }

        private void accept2D(AbstractPivotTableVisitor visitor, @Nullable List<MeasureDef> measures) {
            int[] offsets = new int[this.labels.size()];
            int depth = 0;
            int maxDepth = this.labels.size() - 1;
            boolean isFirst = true;
            Arrays.fill(offsets, 0);
            while (depth >= 0) {
                boolean isVisible = true;
                int offset = offsets[depth];
                if (this.filters != null) {
                    String pathId = Arrays.stream(offsets).limit((long)depth + 1L).mapToObj(String::valueOf).collect(Collectors.joining(PivotTableDataSheetBuilder.PATH_DELIMITER));
                    isVisible = this.filters.contains(pathId);
                }
                if (isVisible) {
                    String label = this.labels.get(depth).get(offset);
                    boolean bl = isVisible = !label.equals("___dku_total_value___");
                    if (isVisible) {
                        DimensionDef dimension = this.dimensions.get(depth);
                        visitor.visit(offset, depth, dimension, label, isFirst);
                        isFirst = false;
                        if (depth == maxDepth && measures != null) {
                            int m;
                            int numMeasure = measures.size();
                            for (m = 0; m < numMeasure; ++m) {
                                visitor.visit(m, depth + 1, measures.get(m));
                            }
                            visitor.leave(m, depth + 1);
                        }
                    }
                }
                if (isVisible && depth < maxDepth) {
                    offsets[++depth] = 0;
                    isFirst = true;
                    continue;
                }
                if (offset < this.labels.get(depth).size() - 1) {
                    int n = depth;
                    offsets[n] = offsets[n] + 1;
                    continue;
                }
                do {
                    offset = offsets[depth];
                    visitor.leave(offset, depth);
                    if (--depth < 0) continue;
                    int n = depth;
                    offsets[n] = offsets[n] + 1;
                } while (depth >= 0 && offsets[depth] >= this.labels.get(depth).size());
            }
        }
    }

    private static class PivotTableFilterBuilderVisitor
    extends AbstractPivotTableVisitor {
        private final PivotTableDataSheetDimensionBuilder xDimensionBuilder;
        private final LongDataTensor counts;
        private final int[] row;
        private final int[] column;
        private final int maxXDepth;
        private final int maxYDepth;
        private final Integer animationFameIdx;
        private boolean xAxis = false;
        public Set<String> visibleRows = new HashSet<String>();
        public Set<String> visibleColumns = new HashSet<String>();

        public PivotTableFilterBuilderVisitor(PivotTableDataSheetDimensionBuilder xDimensionBuilder, LongDataTensor counts, int maxYDepth, @Nullable Integer animationFrameIndex) {
            this.xDimensionBuilder = xDimensionBuilder;
            this.counts = counts;
            this.maxXDepth = xDimensionBuilder.dimensions.size() - 1;
            this.maxYDepth = maxYDepth;
            this.row = new int[maxYDepth + 1];
            this.column = new int[this.maxXDepth + 1];
            this.animationFameIdx = animationFrameIndex;
        }

        @Override
        public void visit(int offset, int depth, DimensionDef dimension, String label, boolean isFirst) {
            if (this.xAxis) {
                int[] coordinates = null;
                if (this.column.length == 0) {
                    coordinates = this.row;
                } else {
                    this.column[depth] = offset;
                    if (depth == this.maxXDepth) {
                        coordinates = ArrayUtils.addAll((int[])this.column, (int[])this.row);
                        if (this.animationFameIdx != null) {
                            coordinates = ArrayUtils.add((int[])coordinates, (int)this.animationFameIdx);
                        }
                    }
                }
                if (coordinates != null && this.counts.get(coordinates) != 0L) {
                    PivotTableFilterBuilderVisitor.addVisiblePath(this.visibleRows, this.row);
                    PivotTableFilterBuilderVisitor.addVisiblePath(this.visibleColumns, this.column);
                }
            } else if (this.row.length == 0) {
                this.visitXAxis();
            } else {
                this.row[depth] = offset;
                if (depth == this.maxYDepth) {
                    this.visitXAxis();
                }
            }
        }

        private void visitXAxis() {
            this.xAxis = true;
            this.xDimensionBuilder.accept(this, null);
            this.xAxis = false;
        }

        private static void addVisiblePath(Set<String> filter, int[] path) {
            for (int i = 0; i < path.length; ++i) {
                filter.add(PivotTableFilterBuilderVisitor.getPathId(Arrays.copyOfRange(path, 0, i + 1)));
            }
        }

        private static String getPathId(int[] path) {
            return Arrays.stream(path).mapToObj(String::valueOf).collect(Collectors.joining(PivotTableDataSheetBuilder.PATH_DELIMITER));
        }
    }

    private static abstract class AbstractPivotTableVisitor {
        private AbstractPivotTableVisitor() {
        }

        void visit(int offset, int depth, DimensionDef dimension, String label, boolean isFirst) {
        }

        void visit(int offset, int depth, MeasureDef measure) {
        }

        void leave(int offset, int depth) {
        }
    }

    private static class PivotTableColumnHeaderBuilderVisitor
    extends AbstractPivotTableVisitor {
        private final SheetReference sheetRef;
        private final CellStyle style;
        private final int[] columns;
        private int measureDepth;

        public PivotTableColumnHeaderBuilderVisitor(SheetReference sheetRef, int maxDepth) {
            this.sheetRef = sheetRef;
            this.style = sheetRef.styler.getHeaderStyle();
            this.columns = new int[maxDepth + 1];
            this.measureDepth = maxDepth + 1;
            Arrays.fill(this.columns, sheetRef.column);
        }

        @Override
        public void visit(int offset, int depth, DimensionDef dimension, String label, boolean isFirst) {
            if (depth < 0) {
                return;
            }
            int column = this.columns[depth];
            int row = this.sheetRef.row + depth * 2;
            if (isFirst) {
                this.sheetRef.writeCell(row, column, com.dataiku.dip.pivot.frontend.ChartUtils.getNiceDimensionName(dimension), this.style);
            }
            this.sheetRef.writeCell(row + 1, column, label, this.style);
            int n = depth;
            this.columns[n] = this.columns[n] + 1;
        }

        @Override
        public void visit(int offset, int depth, MeasureDef measure) {
            int column = this.columns[depth];
            int row = this.sheetRef.row + depth * 2;
            this.sheetRef.writeCell(row, column, com.dataiku.dip.pivot.frontend.ChartUtils.getNiceMeasureName(measure), this.style);
            int n = depth;
            this.columns[n] = this.columns[n] + 1;
            this.measureDepth = depth;
        }

        @Override
        public void leave(int offset, int depth) {
            if (depth == 0) {
                if (this.sheetRef.column < this.columns[0] - 1) {
                    SheetUtils.addMergedRegion(this.sheetRef.sheet, new CellRangeAddress(this.sheetRef.row, this.sheetRef.row, this.sheetRef.column, this.columns[0] - 1));
                }
                this.sheetRef.column = this.columns[0];
            } else if (depth > 0 && this.columns[depth - 1] != this.columns[depth]) {
                int row = this.sheetRef.row + depth * 2;
                SheetUtils.addMergedRegion(this.sheetRef.sheet, new CellRangeAddress(row - 1, row - 1, this.columns[depth - 1] - 1, this.columns[depth] - 1));
                if (depth != this.measureDepth) {
                    SheetUtils.addMergedRegion(this.sheetRef.sheet, new CellRangeAddress(row, row, this.columns[depth - 1] - 1, this.columns[depth] - 1));
                }
                this.columns[depth - 1] = this.columns[depth];
            }
        }
    }

    private static class PivotTableRowBuilderVisitor
    extends AbstractPivotTableVisitor {
        private final SheetReference sheetRef;
        private final CellStyle style;
        private final ChartDef.ColorMode colorMode;
        private final List<MeasureDef> measures;
        private final List<DataTensor<?>> aggregations;
        private final PivotTableDataSheetDimensionBuilder xDimensionBuilder;
        private final List<Map<String, XSSFColor>> backgroundColorMapping;
        private final List<Map<String, XSSFColor>> fontColorMapping;
        private final int[] rows;
        private final int[] coords;
        private final LongDataTensor counts;

        public PivotTableRowBuilderVisitor(SheetReference sheetRef, int maxDepth, List<MeasureDef> measures, List<DataTensor<?>> aggregations, PivotTableDataSheetDimensionBuilder xDimensionBuilder, Integer animationFrameIndex, ChartDef.ColorMode colorMode, LongDataTensor counts, @Nullable List<Map<String, XSSFColor>> backgroundColorMapping, @Nullable List<Map<String, XSSFColor>> fontColorMapping) {
            this.sheetRef = sheetRef;
            this.style = sheetRef.styler.getValueStyle(false, false);
            this.colorMode = colorMode;
            this.measures = measures;
            this.aggregations = aggregations;
            this.xDimensionBuilder = xDimensionBuilder;
            this.backgroundColorMapping = backgroundColorMapping;
            this.fontColorMapping = fontColorMapping;
            this.counts = counts;
            this.rows = new int[maxDepth + 1];
            Arrays.fill(this.rows, sheetRef.row);
            this.coords = new int[aggregations.get((int)0).numAxes + (animationFrameIndex != null ? 1 : 0)];
            Arrays.fill(this.coords, 0);
            if (animationFrameIndex != null) {
                this.coords[this.coords.length - 1] = animationFrameIndex;
            }
        }

        @Override
        public void visit(int offset, int depth, DimensionDef dimension, String label, boolean isFirst) {
            if (depth < 0) {
                if (this.rows.length == 0) {
                    this.xDimensionBuilder.accept(new PivotTableAggregationBuilderVisitor(this.sheetRef, this.style, this.xDimensionBuilder.dimensions.size(), this.aggregations, 0, this.coords, this.colorMode, this.counts, this.backgroundColorMapping, this.fontColorMapping), this.measures);
                }
            } else {
                this.coords[this.xDimensionBuilder.dimensions.size() + depth] = offset;
                int initialRow = this.sheetRef.row;
                int initialColumn = this.sheetRef.column;
                this.sheetRef.row = this.rows[depth];
                this.sheetRef.column += depth;
                this.sheetRef.writeCell(this.sheetRef.row, this.sheetRef.column, label, this.style);
                ++this.sheetRef.column;
                if (depth == this.rows.length - 1) {
                    this.xDimensionBuilder.accept(new PivotTableAggregationBuilderVisitor(this.sheetRef, this.style, this.xDimensionBuilder.dimensions.size(), this.aggregations, 0, this.coords, this.colorMode, this.counts, this.backgroundColorMapping, this.fontColorMapping), this.measures);
                }
                this.sheetRef.row = initialRow;
                this.sheetRef.column = initialColumn;
                int n = depth;
                this.rows[n] = this.rows[n] + 1;
            }
        }

        @Override
        public void visit(int offset, int depth, MeasureDef measure) {
            int initialRow = this.sheetRef.row;
            int initialColumn = this.sheetRef.column;
            this.sheetRef.row = this.rows[depth];
            this.sheetRef.column += depth;
            this.sheetRef.writeCell(this.sheetRef.row, this.sheetRef.column, com.dataiku.dip.pivot.frontend.ChartUtils.getNiceMeasureName(measure), this.style);
            ++this.sheetRef.column;
            this.xDimensionBuilder.accept(new PivotTableAggregationBuilderVisitor(this.sheetRef, this.style, this.xDimensionBuilder.dimensions.size() - 1, this.aggregations, offset, this.coords, this.colorMode, this.counts, this.backgroundColorMapping, this.fontColorMapping), null);
            this.sheetRef.row = initialRow;
            this.sheetRef.column = initialColumn;
            int n = depth;
            this.rows[n] = this.rows[n] + 1;
        }

        @Override
        public void leave(int offset, int depth) {
            if (depth > 0 && this.rows[depth - 1] != this.rows[depth]) {
                int column = this.sheetRef.column + depth - 1;
                SheetUtils.addMergedRegion(this.sheetRef.sheet, new CellRangeAddress(this.rows[depth - 1] - 1, this.rows[depth] - 1, column, column));
                this.rows[depth - 1] = this.rows[depth];
            }
        }
    }

    private static class PivotTableAggregationBuilderVisitor
    extends AbstractPivotTableVisitor {
        private final SheetReference sheetRef;
        private final CellStyle style;
        private final ChartDef.ColorMode colorMode;
        private final List<DataTensor<?>> aggregations;
        private final int measureOffset;
        private final int[] coords;
        private final List<Map<String, XSSFColor>> backgroundColorMapping;
        private final List<Map<String, XSSFColor>> fontColorMapping;
        private final int maxDepth;
        private final LongDataTensor counts;

        public PivotTableAggregationBuilderVisitor(SheetReference sheetRef, CellStyle style, int maxDepth, List<DataTensor<?>> aggregations, int measureOffset, int[] coords, ChartDef.ColorMode colorMode, LongDataTensor counts, @Nullable List<Map<String, XSSFColor>> backgroundColorMapping, @Nullable List<Map<String, XSSFColor>> fontColorMapping) {
            this.sheetRef = sheetRef;
            this.style = style;
            this.colorMode = colorMode;
            this.aggregations = aggregations;
            this.measureOffset = measureOffset;
            this.coords = coords;
            this.backgroundColorMapping = backgroundColorMapping;
            this.fontColorMapping = fontColorMapping;
            this.maxDepth = maxDepth;
            this.counts = counts;
        }

        @Override
        public void visit(int offset, int depth, DimensionDef dimension, String label, boolean isFirst) {
            if (depth >= 0) {
                this.coords[depth] = offset;
                if (depth == this.maxDepth) {
                    this.write(this.measureOffset);
                }
            }
        }

        @Override
        public void visit(int offset, int depth, MeasureDef measure) {
            this.write(offset);
        }

        private void write(int measureOffset) {
            DataTensor<?> tensor = this.aggregations.get(measureOffset);
            int colorMapIndex = this.colorMode == ChartDef.ColorMode.UNIQUE_SCALE ? 0 : measureOffset;
            XSSFCellStyle cellStyle = this.getCellStyle(tensor.type, colorMapIndex);
            this.setFontColorStyle(cellStyle, colorMapIndex);
            this.setBackgroundColorStyle(cellStyle, colorMapIndex);
            if (tensor.type == TensorType.NUMERICAL) {
                this.sheetRef.writeCell(this.sheetRef.row, this.sheetRef.column, tensor.getAsDouble(this.coords), (CellStyle)cellStyle);
            } else if (tensor.type == TensorType.ALPHANUM) {
                this.sheetRef.writeCell(this.sheetRef.row, this.sheetRef.column, (String)tensor.get(this.coords), (CellStyle)cellStyle);
            } else if (tensor.type == TensorType.DATE) {
                this.sheetRef.styler.setStyleFormat(cellStyle, tensor.type);
                this.sheetRef.writeCell(this.sheetRef.row, this.sheetRef.column, (DateTime)tensor.get(this.coords, true), (CellStyle)cellStyle);
            } else {
                throw new RuntimeException("Only numerical and alphanumeric values can be written on a sheet.");
            }
            ++this.sheetRef.column;
        }

        private XSSFCellStyle getCellStyle(TensorType type, int colorMapIndex) {
            XSSFCellStyle cellStyle = (XSSFCellStyle)this.style;
            if (this.fontColorMapping != null && !this.fontColorMapping.get(colorMapIndex).isEmpty() || this.backgroundColorMapping != null && !this.backgroundColorMapping.get(colorMapIndex).isEmpty() || type == TensorType.DATE) {
                return cellStyle.copy();
            }
            return cellStyle;
        }

        private void setFontColorStyle(XSSFCellStyle cellStyle, int colorMapIndex) {
            XSSFColor color;
            if (this.fontColorMapping != null && !this.fontColorMapping.get(colorMapIndex).isEmpty() && (color = FontFormatting.getColorFromCoordinates(this.aggregations, this.fontColorMapping, this.colorMode, this.coords, colorMapIndex, this.counts)) != null) {
                XSSFFont font = this.sheetRef.styler.getValueFont(color);
                cellStyle.setFont((Font)font);
            }
        }

        private void setBackgroundColorStyle(XSSFCellStyle cellStyle, int colorMapIndex) {
            XSSFColor color;
            if (this.backgroundColorMapping != null && !this.backgroundColorMapping.get(colorMapIndex).isEmpty() && (color = FontFormatting.getColorFromCoordinates(this.aggregations, this.backgroundColorMapping, this.colorMode, this.coords, colorMapIndex, this.counts)) != null) {
                cellStyle.setFillForegroundColor(color);
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
        }
    }
}

