/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel.xssf.charts;

import com.dataiku.dip.pivot.frontend.excel.xssf.ChartUtils;
import com.dataiku.dip.pivot.frontend.excel.xssf.charts.BaseChart;
import com.dataiku.dip.pivot.frontend.excel.xssf.series.Series3D;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChart;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBubbleChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBubbleSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;

public class BubbleChart
extends BaseChart<Series3D> {
    @Override
    public void plot(XDDFChart chart, XDDFChartAxis ... chartAxes) {
        CTPlotArea plotArea = chart.getCTChart().getPlotArea();
        CTBubbleChart ctBubbleChart = plotArea.addNewBubbleChart();
        ctBubbleChart.addNewBubbleScale().setVal((Object)10);
        for (Series3D series : this.getSeries()) {
            CTBubbleSer bubbleSer = ctBubbleChart.addNewSer();
            bubbleSer.addNewIdx().setVal((long)series.getId());
            bubbleSer.addNewOrder().setVal((long)series.getId());
            CTShapeProperties spPr = bubbleSer.addNewSpPr();
            CTSolidColorFillProperties scfp = spPr.addNewSolidFill();
            CTSRgbColor rgbColor = scfp.addNewSrgbClr();
            rgbColor.setVal(series.getColor().asByteArray());
            CTLineProperties ln = spPr.addNewLn();
            CTSolidColorFillProperties solidFill = ln.addNewSolidFill();
            CTSRgbColor fillCol = solidFill.addNewSrgbClr();
            fillCol.setVal(ChartUtils.computeDualColor(series.getColor().asByteArray()));
            ln.addNewRound();
            CTSerTx tx = bubbleSer.addNewTx();
            ChartUtils.buildSerTx(tx, series.getTitle());
            CTAxDataSource xs = bubbleSer.addNewXVal();
            ChartUtils.buildAxDataSource(xs, series.getXValues());
            CTNumDataSource ys = bubbleSer.addNewYVal();
            ChartUtils.buildNumDataSource(ys, series.getYValues());
            CTNumDataSource zs = bubbleSer.addNewBubbleSize();
            ChartUtils.buildNumDataSource(zs, series.getZValues());
        }
        for (XDDFChartAxis axis : chartAxes) {
            ctBubbleChart.addNewAxId().setVal(axis.getId());
        }
    }
}

