/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.AutomationNodeManagedEnvUtils;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.projects.importexport.AbstractCodeEnvRemapper;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projects.importexport.model.ProjectRemappingSettings;
import com.dataiku.dip.security.AuthCtx;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class AutomationNodeCodeEnvRemapper
extends AbstractCodeEnvRemapper {
    @Autowired
    private AutomationNodeCodeEnvsService codeEnvsService;
    private static Logger logger = Logger.getLogger((String)"dip.remap.codeenv.automation");

    public AutomationNodeCodeEnvRemapper(AuthCtx authCtx, ProjectRemappingSettings settings, ExportedProject sourceExportedProject) {
        super(authCtx, settings, sourceExportedProject);
    }

    public void prepareVersionedEnvs(String originProjectKey, String targetProjectKey) throws IOException {
        String bundleId = CommonBundleUtils.getActiveBundleId(targetProjectKey);
        logger.info((Object)("Linking versioned envs to " + targetProjectKey + " with bundleId " + bundleId));
        for (CodeEnvModel.UsedCodeEnvRef codeEnv : this.sourceExportedProject.usedCodeEnvRefs) {
            logger.info((Object)("  > " + String.valueOf((Object)codeEnv.envLang) + "." + codeEnv.envName));
            CodeEnvModel.AutomationEnvRootDef env = this.codeEnvsService.getEnvRootDefOrNull(codeEnv.envLang, codeEnv.envName);
            if (env != null && env.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_VERSIONED) {
                try {
                    CodeEnvModel.EnvVersionRef version = AutomationNodeManagedEnvUtils.getNamedBundleLink(codeEnv.envLang, codeEnv.envName, originProjectKey, bundleId);
                    String versionId = version.envVersion;
                    logger.info((Object)("    Linking to version " + versionId));
                    AutomationNodeManagedEnvUtils.linkBundle(codeEnv.envLang, codeEnv.envName, targetProjectKey, bundleId, version.envVersion);
                }
                catch (Exception e) {
                    logger.warn((Object)"    Unable to link code env", (Throwable)e);
                }
                continue;
            }
            logger.info((Object)("    No need to link code env, exists=" + (env != null) + (String)(env == null ? "" : "deploymentMode=" + String.valueOf((Object)env.deploymentMode))));
        }
    }

    @Override
    protected boolean hasCodeEnv(CodeEnvModel.UsedCodeEnvRef codeEnv) throws IOException {
        return this.codeEnvsService.getEnvRootDefOrNull(codeEnv.envLang, codeEnv.envName) != null;
    }
}

