/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.python;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.exec.AbstractPythonRecipeRunner;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.recipes.code.python.PythonRecipeMeta;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.util.AutoDelete;
import java.io.File;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class PythonRecipeRunner
extends AbstractPythonRecipeRunner
implements RecipeRunnerWithPayload {
    @Autowired
    private JobAuthCtxService authCtxService;
    private String pyScriptData;
    private static Logger logger = Logger.getLogger((String)"dku.flow.python");

    public PythonRecipeRunner(JobActivity activity) {
        super(activity);
    }

    @Override
    public void setPayload(String payload) {
        this.pyScriptData = payload;
    }

    @Override
    public void init() throws Exception {
        this.activity.fillSourceTotalSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Initializing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        File additionalLogsFolder = FlowJobUtils.getJobMadeDir("python-recipe", "logs");
        File mainLogFile = FlowJobUtils.getJobTouchedFile("python-recipe", "python-output.log");
        JobContext.getCurrentActivityObj().getStatus().addStatutOutput("Python output", mainLogFile, "text/plain");
        AutoDelete recipeTmpDir = FlowJobUtils.getTmpFolder("python-recipe", "pyout");
        ContainerExecRuntimeConfig containerConfig = null;
        try {
            this.pyScriptData = this.pyScriptData + "\n\n\nimport dataiku as _private_dataiku_import\n_private_dataiku_import._dataset_writer_atexit_handler()\n_private_dataiku_import._folder_writer_atexit_handler()";
            this.activity.setStatusMessage("Executing Python script");
            logger.info((Object)"Starting execution of user's Python code");
            PythonRecipeMeta.PythonRecipeParams params = this.recipe.getModel().getParamsAs(PythonRecipeMeta.PythonRecipeParams.class);
            String envName = new CodeEnvSelector().selectForPythonRecipe(this.recipe.getProjectKey(), params.envSelection);
            CodeEnvModel.UsedCodeEnvRef codeEnvRef = new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, envName);
            containerConfig = new ContainerExecConfigSelector().select_autoTXN(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey(), params.containerSelection);
            if (containerConfig == null) {
                this.executeScript((File)recipeTmpDir, mainLogFile, this.pyScriptData, envName);
            } else {
                switch (containerConfig.type) {
                    case DOCKER: {
                        this.executeDockerCodeRecipe(codeEnvRef, containerConfig, (File)recipeTmpDir, mainLogFile, recipeTmpDir, RemoteRunsRegistry.ExecutionType.RECIPE_PYTHON, this.pyScriptData, Collections.emptyMap(), null);
                        break;
                    }
                    case KUBERNETES: {
                        this.executeKubernetesCodeRecipe(codeEnvRef, containerConfig, (File)recipeTmpDir, mainLogFile, additionalLogsFolder, recipeTmpDir, RemoteRunsRegistry.ExecutionType.RECIPE_PYTHON, this.pyScriptData, Collections.emptyMap(), null, new KubernetesExecUtils.KubernetesFailureCodeProvider(){

                            @Override
                            public InfoMessage.MessageCode codeForOOMKilled() {
                                return RecipeCodes.ERR_RECIPE_CODE_K8S_OOM;
                            }
                        });
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown execution container: " + String.valueOf((Object)containerConfig.type));
                    }
                }
            }
            logger.info((Object)"Execution of user's Python code complete");
            this.activity.setAllSourcesCompletelyRead();
            this.activity.fillTargetWrittenSizes(this.datasetsDAO);
            this.activity.setStatusMessage("Done");
        }
        finally {
            if (containerConfig == null) {
                recipeTmpDir.close();
            }
        }
    }
}

