/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda;

import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.engine.ComputationResultSession;
import com.dataiku.dip.eda.compute.grouping.SubsetGrouping;
import com.dataiku.dip.recipes.eda.EDARecipeRunner;
import com.dataiku.dip.recipes.eda.SplitByFilterRowFiller;
import com.dataiku.dip.recipes.eda.StatsTestRecipeMeta;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.AbstractTestStat;
import java.util.ArrayList;
import java.util.List;

public class StatsTestRecipeRunner
extends EDARecipeRunner<StatsTestRecipePayloadParams<?>> {
    public StatsTestRecipeRunner(JobActivity activity) {
        super(activity);
    }

    @Override
    protected StatsTestRecipePayloadParams<?> parsePayload(String payload) {
        return StatsTestRecipeMeta.META.parsePayload(payload);
    }

    @Override
    protected void validateRecipe() {
        super.validateRecipe();
        this.recipe.validateExactly1Target();
    }

    @Override
    protected Computation getComputationPlan() {
        SubsetGrouping splitByGrouping = ((StatsTestRecipePayloadParams)this.payloadParams).splitBy == null ? SubsetGrouping.all() : ((StatsTestRecipePayloadParams)this.payloadParams).splitBy.asGrouping();
        ArrayList<Computation> computations = new ArrayList<Computation>();
        for (AbstractTestStat stat : ((StatsTestRecipePayloadParams)this.payloadParams).stats) {
            Computation computation = stat.getComputationPlan((StatsTestRecipePayloadParams)this.payloadParams);
            GroupedComputation splitComputation = new GroupedComputation(computation, splitByGrouping);
            computations.add(splitComputation);
        }
        return new MultiComputation(computations);
    }

    private List<Row> extractRows(ComputationResult result, ColumnFactory cf, RowFactory rf) {
        ArrayList<Row> allRows = new ArrayList<Row>();
        MultiComputation.MultiComputationResult mcr = result.asMulti();
        SplitByFilterRowFiller splitByRowFiller = new SplitByFilterRowFiller(cf);
        for (int i = 0; i < mcr.size(); ++i) {
            ComputationResult splitResult = mcr.get(i);
            AbstractTestStat stat = (AbstractTestStat)((Object)((StatsTestRecipePayloadParams)this.payloadParams).stats.get(i));
            if (splitResult.isFailed()) {
                throw new IllegalArgumentException(String.format("Computation error when splitting: %s", splitResult.asFailed().message));
            }
            for (GroupedComputation.GroupResult groupResult : splitResult.asGrouped()) {
                List<Row> rows = stat.extractRows(groupResult.result, (StatsTestRecipePayloadParams)this.payloadParams, cf, rf);
                for (Row row : rows) {
                    splitByRowFiller.fill(row, groupResult.filter);
                    if (!((StatsTestRecipePayloadParams)this.payloadParams).addComputationTimestamp) continue;
                    row.put(cf.column("computation_timestamp"), this.computationTimestamp);
                }
                allRows.addAll(rows);
            }
        }
        return allRows;
    }

    @Override
    protected void writeOutputs(ComputationResultSession session) throws Exception {
        ComputationResult result = session.getComputationResult();
        StreamRowFactory rf = new StreamRowFactory();
        StreamColumnFactory cf = new StreamColumnFactory();
        ProcessorOutput writer = this.buildMainOutputDatasetWriter((ColumnFactory)cf);
        for (Row row : this.extractRows(result, (ColumnFactory)cf, (RowFactory)rf)) {
            writer.emitRow(row);
        }
        writer.lastRowEmitted();
    }
}

