/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda.stats;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.univariate.PairwiseLeveneTest;
import com.dataiku.dip.eda.compute.stats.LeveneCenter;
import com.dataiku.dip.eda.compute.stats.PValueAdjustmentMethod;
import com.dataiku.dip.recipes.eda.EDASchemaColumns;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.AbstractPairwiseTestStat;
import com.dataiku.dip.recipes.eda.stats.AbstractTestStat;
import com.dataiku.dip.utils.JSON;
import java.util.List;
import javax.annotation.Nullable;

public class PairwiseLeveneTestStat
extends AbstractPairwiseTestStat {
    private static final String PAIRWISE_LEVENE_TEST = "LEVENE_TEST_PAIRWISE";
    public LeveneCenter center = LeveneCenter.MEDIAN;
    @Nullable
    public Double proportionToTrim;

    public PairwiseLeveneTestStat(String testColumn, String groupByColumn, @Nullable List<String> groupValues, int maxPopulations, @Nullable String referenceGroup, PValueAdjustmentMethod adjustmentMethod, LeveneCenter center, @Nullable Double proportionToTrim) {
        super(testColumn, groupByColumn, groupValues, maxPopulations, referenceGroup, adjustmentMethod);
        this.center = center;
        this.proportionToTrim = proportionToTrim;
    }

    public PairwiseLeveneTestStat() {
    }

    @Override
    protected void fillTestParams(Row row, ColumnFactory cf) {
        super.fillTestParams(row, cf);
        row.put(cf.column("test"), PAIRWISE_LEVENE_TEST);
        AbstractTestStat.LeveneCenterSettings leveneCenterSettings = new AbstractTestStat.LeveneCenterSettings(this.center, this.proportionToTrim);
        row.put(cf.column("center_settings"), JSON.json((Object)leveneCenterSettings));
    }

    @Override
    protected Computation getTestComputation(StatsTestRecipePayloadParams<?> payloadParams) {
        return new PairwiseLeveneTest(this.testColumn, this.getPopulationGrouping(), this.referenceGroup != null, this.adjustmentMethod, this.center, this.proportionToTrim);
    }

    @Override
    protected void fillTestResult(AvailableResult result, double significanceLevel, ColumnFactory cf, Row row, int i, int j, int rowIndex) {
        PairwiseLeveneTest.PairwiseLeveneTestResult tr = result.as(PairwiseLeveneTest.PairwiseLeveneTestResult.class);
        this.fillLeveneCenters(tr.centers, row, cf, i, j);
        if (rowIndex >= tr.adjustedPvalues.length) {
            throw new IllegalArgumentException(String.format("Requested test index %d superior to number of available test results %d", rowIndex, tr.adjustedPvalues.length));
        }
        double pValue = tr.pvalues[rowIndex];
        double adjustedPValue = tr.adjustedPvalues[rowIndex];
        String conclusion = PairwiseLeveneTestStat.conclusion(adjustedPValue, significanceLevel);
        row.put(cf.column("f_statistic"), tr.statistics[rowIndex]);
        row.put(cf.column("p_value"), pValue);
        row.put(cf.column("adjusted_p_value"), adjustedPValue);
        row.put(cf.column("conclusion"), conclusion);
    }

    private void fillLeveneCenters(double[] centers, Row row, ColumnFactory cf, int i, int j) {
        for (int k : List.of(Integer.valueOf(i), Integer.valueOf(j))) {
            if (k <= centers.length) continue;
            throw new IllegalArgumentException(String.format("Requested center index %d superior to number of available centers %d", k, centers.length));
        }
        row.put(cf.column(EDASchemaColumns.leveneCenterValue(1)), centers[i]);
        row.put(cf.column(EDASchemaColumns.leveneCenterValue(2)), centers[j]);
    }
}

