/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda.univariate;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.univariate.Quantiles;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.recipes.eda.UnivariateRecipePayloadParams;
import com.dataiku.dip.recipes.eda.univariate.UnivariateAnalysis;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class UnivariateAnalysisQuantileTable
extends UnivariateAnalysis {
    public static final String TYPE = "QUANTILE_TABLE";
    private static final String STAT_TYPE = "QUANTILE";
    private static final List<Double> defaultFreqs = Arrays.asList(0.01, 0.05, 0.25, 0.5, 0.75, 0.95, 0.99);
    @Nullable
    public List<Double> customFreqs = null;

    public UnivariateAnalysisQuantileTable(Variable column) {
        this.column = column;
    }

    private UnivariateAnalysisQuantileTable() {
    }

    @Override
    public Computation getComputationPlan(UnivariateRecipePayloadParams payloadParams) {
        Quantiles params = new Quantiles(this.column.name);
        params.freqs = this.customFreqs == null ? defaultFreqs : this.customFreqs;
        params.confidence = payloadParams.withConfidenceIntervals ? Double.valueOf(payloadParams.confidenceLevel) : null;
        return params;
    }

    @Override
    public List<Row> extractRows(ComputationResult result, UnivariateRecipePayloadParams payloadParams, ColumnFactory cf, RowFactory rf) {
        List<Quantiles.QuantileDesc> quantiles;
        ArrayList<Row> rows = new ArrayList<Row>();
        List<String> warnings = result.collectWarnings();
        Collection<String> errors = result.collectErrors();
        if (result.isAvailable()) {
            quantiles = ((Quantiles.QuantilesResult)result).quantiles;
        } else {
            List<Double> freqs = this.customFreqs == null ? defaultFreqs : this.customFreqs;
            quantiles = freqs.stream().map(freq -> new Quantiles.QuantileDesc(-1.0, (double)freq, null, null)).collect(Collectors.toList());
        }
        for (Quantiles.QuantileDesc quantile : quantiles) {
            Row row = this.rowBase(quantile, warnings, errors, cf, rf);
            row.put(cf.column("statistic_type"), STAT_TYPE);
            if (result.isAvailable()) {
                row.put(cf.column("value"), quantile.quantile);
            }
            rows.add(row);
            if (payloadParams.withConfidenceIntervals) {
                row = this.rowBase(quantile, warnings, errors, cf, rf);
                row.put(cf.column("statistic_type"), String.format("%s_CI_LOWER", STAT_TYPE));
                if (quantile.lower != null) {
                    row.put(cf.column("value"), quantile.lower.doubleValue());
                }
                rows.add(row);
            }
            if (!payloadParams.withConfidenceIntervals) continue;
            row = this.rowBase(quantile, warnings, errors, cf, rf);
            row.put(cf.column("statistic_type"), String.format("%s_CI_UPPER", STAT_TYPE));
            if (quantile.upper != null) {
                row.put(cf.column("value"), quantile.upper.doubleValue());
            }
            rows.add(row);
        }
        return rows;
    }

    private Row rowBase(Quantiles.QuantileDesc quantile, Collection<String> warnings, Collection<String> errors, ColumnFactory cf, RowFactory rf) {
        Row row = rf.row();
        row.put(cf.column("variable"), this.column.name);
        row.put(cf.column("origin"), TYPE);
        row.put(cf.column("key"), quantile.freq);
        if (!warnings.isEmpty()) {
            row.put(cf.column("warnings"), JSON.json(warnings));
        }
        if (!errors.isEmpty()) {
            row.put(cf.column("errors"), JSON.json(errors));
        }
        return row;
    }

    @Override
    public void validate(UnivariateRecipePayloadParams payloadParams) {
        if (this.customFreqs != null) {
            for (Double freq : this.customFreqs) {
                if (freq != null && !(freq < 0.0) && !(freq > 1.0)) continue;
                throw ErrorContext.iae((String)"Quantiles should belong to [0, 1]");
            }
        }
    }
}

