/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming.ksql;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.recipes.streaming.ksql.KsqlRESTClient;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class KsqlSchemaHandler {
    public Schema fromKsql(List<KsqlRESTClient.KsqlField> ksql) throws Exception {
        Schema s = new Schema();
        for (KsqlRESTClient.KsqlField field : ksql) {
            s.addColumn(this.fromKsql(field));
        }
        return s;
    }

    public SchemaColumn fromKsql(KsqlRESTClient.KsqlField ksql) throws Exception {
        SchemaColumn sc = this.fromKsql(ksql.schema);
        sc.setName(ksql.name);
        return sc;
    }

    public SchemaColumn fromKsql(KsqlRESTClient.KsqlFieldSchema ksql) throws Exception {
        switch (ksql.type) {
            case INTEGER: {
                return new SchemaColumn("n/a", Type.INT);
            }
            case BIGINT: {
                return new SchemaColumn("n/a", Type.BIGINT);
            }
            case DOUBLE: {
                return new SchemaColumn("n/a", Type.DOUBLE);
            }
            case STRING: {
                return new SchemaColumn("n/a", Type.STRING);
            }
            case BOOLEAN: {
                return new SchemaColumn("n/a", Type.BOOLEAN);
            }
            case TIMESTAMP: {
                return new SchemaColumn("n/a", Type.DATE);
            }
            case DATE: {
                return new SchemaColumn("n/a", Type.DATEONLY);
            }
            case ARRAY: {
                SchemaColumn sc = new SchemaColumn("n/a", Type.ARRAY);
                sc.arrayContent = this.fromKsql(ksql.memberSchema);
                return sc;
            }
            case MAP: {
                SchemaColumn sc = new SchemaColumn("n/a", Type.ARRAY);
                sc.mapKeys = new SchemaColumn("key", Type.STRING);
                sc.mapValues = this.fromKsql(ksql.memberSchema);
                return sc;
            }
            case STRUCT: {
                SchemaColumn sc = new SchemaColumn("n/a", Type.OBJECT);
                sc.objectFields = Lists.newArrayList();
                for (KsqlRESTClient.KsqlField field : ksql.fields) {
                    sc.objectFields.add(this.fromKsql(field));
                }
                return sc;
            }
            case DECIMAL: {
                return new SchemaColumn("n/a", Type.DOUBLE);
            }
        }
        throw new Exception("Unknown ksql type " + String.valueOf((Object)ksql.type));
    }

    public List<KsqlRESTClient.KsqlField> toKsql(Schema s) throws Exception {
        ArrayList l = Lists.newArrayList();
        for (SchemaColumn sc : s.getColumns()) {
            l.add(this.toKsqlField(sc));
        }
        return l;
    }

    public KsqlRESTClient.KsqlField toKsqlField(SchemaColumn dss) throws Exception {
        KsqlRESTClient.KsqlField ksql = new KsqlRESTClient.KsqlField();
        ksql.name = dss.getName();
        ksql.schema = this.toKsqlSchema(dss);
        return ksql;
    }

    public KsqlRESTClient.KsqlFieldSchema toKsqlSchema(SchemaColumn dss) throws Exception {
        KsqlRESTClient.KsqlFieldSchema ksql = new KsqlRESTClient.KsqlFieldSchema();
        switch (dss.getType()) {
            case TINYINT: 
            case SMALLINT: 
            case INT: {
                ksql.type = KsqlRESTClient.KsqlFieldType.INTEGER;
                return ksql;
            }
            case BIGINT: {
                ksql.type = KsqlRESTClient.KsqlFieldType.BIGINT;
                return ksql;
            }
            case FLOAT: 
            case DOUBLE: {
                ksql.type = KsqlRESTClient.KsqlFieldType.DOUBLE;
                return ksql;
            }
            case BOOLEAN: {
                ksql.type = KsqlRESTClient.KsqlFieldType.BOOLEAN;
                return ksql;
            }
            case DATE: 
            case DATETIMENOTZ: {
                ksql.type = KsqlRESTClient.KsqlFieldType.TIMESTAMP;
                return ksql;
            }
            case DATEONLY: {
                ksql.type = KsqlRESTClient.KsqlFieldType.DATE;
                return ksql;
            }
            case STRING: {
                ksql.type = KsqlRESTClient.KsqlFieldType.STRING;
                return ksql;
            }
            case GEOMETRY: 
            case GEOPOINT: {
                ksql.type = KsqlRESTClient.KsqlFieldType.STRING;
                return ksql;
            }
            case ARRAY: {
                ksql.type = KsqlRESTClient.KsqlFieldType.ARRAY;
                if (dss.arrayContent == null) {
                    ksql.memberSchema = new KsqlRESTClient.KsqlFieldSchema();
                    ksql.memberSchema.type = KsqlRESTClient.KsqlFieldType.STRING;
                } else {
                    ksql.memberSchema = this.toKsqlSchema(dss.arrayContent);
                }
                return ksql;
            }
            case MAP: {
                ksql.type = KsqlRESTClient.KsqlFieldType.MAP;
                if (dss.mapValues == null) {
                    ksql.memberSchema = new KsqlRESTClient.KsqlFieldSchema();
                    ksql.memberSchema.type = KsqlRESTClient.KsqlFieldType.STRING;
                } else {
                    ksql.memberSchema = this.toKsqlSchema(dss.mapValues);
                }
                return ksql;
            }
            case OBJECT: {
                ksql.type = KsqlRESTClient.KsqlFieldType.STRUCT;
                ksql.fields = Lists.newArrayList();
                if (dss.objectFields != null) {
                    for (SchemaColumn field : dss.objectFields) {
                        ksql.fields.add(this.toKsqlField(field));
                    }
                }
                return ksql;
            }
        }
        throw new Exception("Ksql doesn't handle " + String.valueOf(dss.getType()));
    }
}

