/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.resourceusage.k8s;

import com.dataiku.dip.cluster.ClusterSelection;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.ContainerOverrideMask;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.KubernetesClusterService;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.containers.exec.kubernetes.CpuQuantity;
import com.dataiku.dip.containers.exec.kubernetes.MemoryQuantity;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.resourceusage.k8s.KubernetesClusterUsageStatus;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.util.JsonUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class KubernetesClusterUsageGatherer {
    private final String clusterId;
    private final ContainerExecRuntimeConfig k8sConfig;
    private final Map<String, String> k8sBaseEnv;
    private final GeneralSettingsDAO.ComputeResourceUsageReportingSettings settings;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.resourceusage.k8s");

    public KubernetesClusterUsageGatherer(ClusterSelection selection, GeneralSettingsDAO.ComputeResourceUsageReportingSettings settings) throws IOException, DKUSecurityException {
        ClusterSettings clusterSettings;
        this.settings = settings;
        if (selection.clusterMode == ClusterSelection.ClusterMode.EXPLICIT_CLUSTER) {
            clusterSettings = new ClusterSelector().selectForCluster(DSSAuthCtx.fakeAdminForTests("n/a"), "__builtin__", selection.clusterId);
            this.clusterId = selection.clusterId;
        } else {
            clusterSettings = new ClusterSelector().selectGlobal();
            this.clusterId = "DKU_INSTANCE_DEFAULT";
        }
        ContainerExecRuntimeConfig inlineConfig = new ContainerExecRuntimeConfig();
        inlineConfig.type = ContainerExecRuntimeConfig.Container.KUBERNETES;
        inlineConfig.noImplicitK8sClusterAndNoDefaultClusterId = clusterSettings.isNoImplicitK8sClusterAndNoDefaultClusterId();
        ContainerExecRuntimeConfig configOverrides = clusterSettings.getContainerSettings().executionConfigsGenericOverrides;
        this.k8sConfig = ContainerOverrideMask.getOverriden(inlineConfig, configOverrides);
        this.k8sConfig.kubernetesNamespace = null;
        this.k8sBaseEnv = KubernetesExecUtils.getKubeCtlEnv(this.k8sConfig);
    }

    public KubernetesClusterUsageStatus getUsageStatus() throws Exception {
        logger.info((Object)("Fetching cluster info for " + this.clusterId));
        KubernetesClusterUsageStatus ret = new KubernetesClusterUsageStatus();
        ret.clusterId = this.clusterId;
        ret.podsStatus = this.getPodsStatus();
        logger.info((Object)("Done fetching cluster info for " + this.clusterId + ", gathered info about " + ret.podsStatus.pods.size() + " pods"));
        return ret;
    }

    private KubernetesClusterUsageStatus.KubernetesClusterPodsStatus getPodsStatus() throws Exception {
        Map<String, KubernetesClusterUsageStatus.PodDescription> pods = this.listAllPods();
        this.enrichWithTop(pods);
        KubernetesClusterUsageStatus.KubernetesClusterPodsStatus ret = new KubernetesClusterUsageStatus.KubernetesClusterPodsStatus();
        ret.pods.addAll(pods.values());
        return ret;
    }

    private void enrichWithTop(Map<String, KubernetesClusterUsageStatus.PodDescription> pods) throws Exception {
        ProcessBuilder pb = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommandNoNamespace(DSSAuthCtx.fakeAdminForTests("n/a"), this.k8sConfig, "top", "pods", "--all-namespaces", "--no-headers"));
        pb.environment().putAll(this.k8sBaseEnv);
        Process process = pb.start();
        DKUtils.ByteCollectingSubscription outputCollector = new DKUtils.ByteCollectingSubscription();
        DKUtils.ExecOutputConsumer pollServiceEoc = new DKUtils.ExecOutputConsumer().withOutputConsumer((DKUtils.ExecSubscription)outputCollector);
        pollServiceEoc.start(process.getInputStream(), process.getErrorStream(), null);
        int rv = process.waitFor();
        if (rv != 0) {
            throw new Exception("Unable to get pods, retcode " + rv);
        }
        String result = new String(outputCollector.getCollected(), StandardCharsets.UTF_8);
        pollServiceEoc.finish();
        List<KubernetesClusterService.ClusterPodTopMetrics> podMetricsList = KubernetesClusterService.parsePodsMetrics(result, true);
        podMetricsList.forEach(podMetrics -> {
            String podKey = KubernetesClusterUsageGatherer.podKey(podMetrics.getNamespace(), podMetrics.getName());
            KubernetesClusterUsageStatus.PodDescription podDescription = (KubernetesClusterUsageStatus.PodDescription)pods.get(podKey);
            if (podDescription == null) {
                logger.trace(() -> "Pod " + podKey + " not found in list - probably belongs to excluded namespace");
                return;
            }
            podDescription.cpuCurrentMillis = podMetrics.getCpuMillis();
            podDescription.memoryMB = podMetrics.getMemoryMB();
            logger.trace(() -> "Enriched pod info pod " + JSON.json((Object)podDescription));
        });
    }

    private static String podKey(String namespace, String name) {
        return namespace + "$$$" + name;
    }

    private Map<String, KubernetesClusterUsageStatus.PodDescription> listAllPods() throws Exception {
        ProcessBuilder pb = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommandNoNamespace(DSSAuthCtx.fakeAdminForTests("n/a"), this.k8sConfig, "get", "pods", "--all-namespaces", "-o", "json"));
        pb.environment().putAll(this.k8sBaseEnv);
        Process process = pb.start();
        DKUtils.ByteCollectingSubscription outputCollector = new DKUtils.ByteCollectingSubscription();
        DKUtils.ExecOutputConsumer pollServiceEoc = new DKUtils.ExecOutputConsumer().withOutputConsumer((DKUtils.ExecSubscription)outputCollector);
        pollServiceEoc.start(process.getInputStream(), process.getErrorStream(), null);
        int rv = process.waitFor();
        if (rv != 0) {
            throw new Exception("Unable to get pods, retcode " + rv);
        }
        pollServiceEoc.finish();
        JsonObject obj = (JsonObject)JSON.parse((InputStream)new ByteArrayInputStream(outputCollector.getCollected()), JsonObject.class);
        JsonArray items = JsonUtils.getOrEmptyArr(obj, "items");
        HashMap<String, KubernetesClusterUsageStatus.PodDescription> ret = new HashMap<String, KubernetesClusterUsageStatus.PodDescription>();
        for (JsonElement item : items) {
            JsonObject annotations;
            String memoryLimit;
            String memoryReq;
            String cpuLimit;
            JsonObject podObj = (JsonObject)item;
            KubernetesClusterUsageStatus.PodDescription pd = new KubernetesClusterUsageStatus.PodDescription();
            pd.name = JsonUtils.getOrNullStr(podObj, "metadata", "name");
            pd.namespace = JsonUtils.getOrNullStr(podObj, "metadata", "namespace");
            if (pd.name == null || pd.namespace == null) {
                logger.warn((Object)("Failed to parse a pod from " + item.getAsString()));
                continue;
            }
            Pattern p = Pattern.compile(this.settings.namespacePattern);
            if (!p.matcher(pd.namespace).matches()) {
                logger.trace(() -> "Pod does not belong to matching namespace, not adding): " + JSON.json((Object)pd));
                continue;
            }
            String cpuReq = JsonUtils.getOrNullStr(podObj, "spec", "containers", 0, "resources", "requests", "cpu");
            if (cpuReq != null) {
                pd.cpuRequestMillis = new CpuQuantity(cpuReq).getAsMilli();
            }
            if ((cpuLimit = JsonUtils.getOrNullStr(podObj, "spec", "containers", 0, "resources", "limits", "cpu")) != null) {
                pd.cpuLimitMillis = new CpuQuantity(cpuLimit).getAsMilli();
            }
            if ((memoryReq = JsonUtils.getOrNullStr(podObj, "spec", "containers", 0, "resources", "requests", "memory")) != null) {
                pd.memoryRequestMB = new MemoryQuantity(memoryReq).getAsMb();
            }
            if ((memoryLimit = JsonUtils.getOrNullStr(podObj, "spec", "containers", 0, "resources", "limits", "memory")) != null) {
                pd.memoryLimitMB = new MemoryQuantity(memoryLimit).getAsMb();
            }
            pd.phase = JsonUtils.getOrNullStr(podObj, "status", "phase");
            pd.hostIP = JsonUtils.getOrNullStr(podObj, "status", "hostIP");
            JsonObject labels = JsonUtils.getOrEmptyObj(podObj, "metadata", "labels");
            if (labels != null) {
                pd.labels = JsonUtils.toStrMap(labels);
            }
            if ((annotations = JsonUtils.getOrEmptyObj(podObj, "metadata", "annotations")) != null) {
                pd.annotations = JsonUtils.toStrMap(annotations);
            }
            ret.put(KubernetesClusterUsageGatherer.podKey(pd.namespace, pd.name), pd);
        }
        return ret;
    }
}

