/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.runnables;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.frontend.TimeoutableTaskKeepAlive;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StoppableWithTimeoutService {
    private static final DKULogger logger = DKULogger.getLogger((String)"com.dataiku.dip.scheduler.runnables.StoppableWithTimeoutService");
    @Autowired
    private PubSubService pubSub;
    private final Map<String, StoppableWithTimeout> callablesExecutionTime = new HashMap<String, StoppableWithTimeout>();

    private List<Stoppable> killAllExpired() {
        ArrayList killed = Lists.newArrayList();
        Iterator<Map.Entry<String, StoppableWithTimeout>> iterator = this.callablesExecutionTime.entrySet().iterator();
        logger.infoV("Checking timeout for %d processes", new Object[]{this.callablesExecutionTime.size()});
        for (String key : new HashSet<String>(this.callablesExecutionTime.keySet())) {
            killed.addAll(this.killIfExpired(key));
        }
        return killed;
    }

    @PostConstruct
    public void postConstruct() {
        this.pubSub.subscribe("timeoutable-task-keepalive", (DSSEventListener)new DSSEventListener<TimeoutableTaskKeepAlive>(){

            public void on(TimeoutableTaskKeepAlive evt) throws Exception {
                StoppableWithTimeoutService.this.refreshTask(evt.taskId);
            }
        });
    }

    public synchronized Pair<Long, Long> getElapsedTime(String id) {
        StoppableWithTimeout callableWithTime = this.callablesExecutionTime.get(id);
        return callableWithTime == null ? null : new Pair((Object)((long)callableWithTime.timeout), (Object)(System.currentTimeMillis() - callableWithTime.lastRefreshTime));
    }

    public synchronized List<Stoppable> kill(String id) {
        StoppableWithTimeout callableWithTime = this.callablesExecutionTime.get(id);
        this.callablesExecutionTime.remove(id);
        return callableWithTime != null ? Lists.newArrayList((Object[])new Stoppable[]{callableWithTime.stoppable}) : Collections.emptyList();
    }

    public synchronized List<Stoppable> killIfExpired(String id) {
        if (this.callablesExecutionTime.containsKey(id)) {
            StoppableWithTimeout callableWithTime = this.callablesExecutionTime.get(id);
            long now = System.currentTimeMillis();
            logger.infoV("Expirable task: %s, time until timeout: %f ms", new Object[]{id, Float.valueOf((float)(callableWithTime.lastRefreshTime - now) + callableWithTime.timeout)});
            if ((float)(callableWithTime.lastRefreshTime - now) + callableWithTime.timeout < 0.0f) {
                this.callablesExecutionTime.remove(id);
                return Lists.newArrayList((Object[])new Stoppable[]{callableWithTime.stoppable});
            }
        }
        return Lists.newArrayList();
    }

    public synchronized List<Stoppable> killIfExpiredByPrefix(String prefix) {
        ArrayList killed = Lists.newArrayList();
        for (Map.Entry<String, StoppableWithTimeout> c2 : new HashMap<String, StoppableWithTimeout>(this.callablesExecutionTime).entrySet()) {
            if (!c2.getKey().startsWith(prefix)) continue;
            killed.addAll(this.killIfExpired(c2.getKey()));
        }
        return killed;
    }

    public synchronized void stopWithTimeout(String id, Stoppable stoppable, float timeoutMins) {
        this.stopWithTimeout(id, stoppable, timeoutMins, false);
    }

    public synchronized void stopWithTimeout(String id, Stoppable stoppable, float timeoutMins, boolean overwriteExisting) {
        if (this.callablesExecutionTime.containsKey(id) && !overwriteExisting) {
            throw new IllegalArgumentException("Another execution has been already submitted with the same id: " + id);
        }
        this.callablesExecutionTime.put(id, new StoppableWithTimeout(System.currentTimeMillis(), timeoutMins * 60.0f * 1000.0f, stoppable));
    }

    public synchronized boolean isRunning(String id) {
        return this.callablesExecutionTime.containsKey(id);
    }

    public synchronized void refreshTask(String id) {
        if (this.callablesExecutionTime.containsKey(id)) {
            this.callablesExecutionTime.get((Object)id).lastRefreshTime = System.currentTimeMillis();
        }
    }

    private static class StoppableWithTimeout {
        public long lastRefreshTime;
        public final float timeout;
        private final Stoppable stoppable;

        public StoppableWithTimeout(long lastRefreshTime, float timeout, Stoppable stoppable) {
            this.lastRefreshTime = lastRefreshTime;
            this.timeout = timeout;
            this.stoppable = stoppable;
        }
    }

    public static abstract class Stoppable {
        public abstract void stop();
    }

    @DisallowConcurrentExecution
    public static class KillExpiredCallables
    implements Job {
        @Autowired
        StoppableWithTimeoutService stoppableWithTimeoutService;

        public KillExpiredCallables() {
            SpringUtils.getInstance().autowire((Object)this);
        }

        public void execute(JobExecutionContext jobExecutionContext) {
            List<Stoppable> killed = this.stoppableWithTimeoutService.killAllExpired();
            for (Stoppable stoppable : killed) {
                stoppable.stop();
            }
        }
    }
}

