/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scoring.exports.pmml;

import com.dataiku.dip.scoring.exports.pmml.helpers.PMMLConstants;
import java.beans.Transient;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XML {
    private static List<Field> getAllFields(Class<?> c2) {
        ArrayDeque<Field> f = new ArrayDeque<Field>();
        do {
            Field[] fields = c2.getDeclaredFields();
            ArrayDeque<Field> currentList = new ArrayDeque<Field>(fields.length);
            for (Field field : fields) {
                currentList.add(field);
            }
            Iterator revIt = currentList.descendingIterator();
            while (revIt.hasNext()) {
                f.addFirst((Field)revIt.next());
            }
        } while ((c2 = c2.getSuperclass()) != null);
        return new ArrayList<Field>(f);
    }

    static Node textToNode(Document dom, String text, String name) {
        org.w3c.dom.Element e = dom.createElement(name);
        e.appendChild(dom.createTextNode(text));
        return e;
    }

    static void appendContents(Document dom, Node parent, Object o, String name) {
        if (o instanceof List) {
            for (Object sub : (List)o) {
                XML.appendContents(dom, parent, sub, name);
            }
        } else if (o instanceof String || o instanceof Number) {
            parent.appendChild(XML.textToNode(dom, o.toString(), name));
        } else if (o instanceof XMLPrimitive) {
            XMLPrimitive xp = (XMLPrimitive)o;
            parent.appendChild(xp.toNode(dom, xp.getName()));
        } else if (o.getClass().getAnnotation(Named.class) != null) {
            parent.appendChild(XML.objectToNode(dom, o, o.getClass().getAnnotation(Named.class).name()));
        } else {
            parent.appendChild(XML.objectToNode(dom, o, name));
        }
    }

    static boolean shouldTryParse(Field f) {
        int vis = f.getModifiers();
        return !Modifier.isPrivate(vis) && !Modifier.isProtected(vis) && f.getAnnotation(Transient.class) == null;
    }

    static Node objectToNode(Document dom, Object o, String name) {
        org.w3c.dom.Element result = dom.createElement(name);
        for (Field f : XML.getAllFields(o.getClass())) {
            if (!XML.shouldTryParse(f)) continue;
            f.setAccessible(true);
            try {
                Object fieldValue = f.get(o);
                if (fieldValue == null) continue;
                if (fieldValue instanceof CustomAttribute) {
                    CustomAttribute ca = (CustomAttribute)fieldValue;
                    result.setAttribute(ca.getName(), ca.getValue());
                    continue;
                }
                if (f.getAnnotation(Attribute.class) != null) {
                    result.setAttribute(f.getName(), f.get(o).toString());
                    continue;
                }
                if (f.getAnnotation(Element.class) != null) {
                    XML.appendContents(dom, result, f.get(o), f.getName());
                    continue;
                }
                if (fieldValue instanceof PMMLConstants.PMMLDoubleTagContent) {
                    result.setTextContent(String.valueOf(((PMMLConstants.PMMLDoubleTagContent)fieldValue).value));
                    continue;
                }
                if (!(fieldValue instanceof PMMLConstants.PMMLStringTagContent)) continue;
                result.setTextContent(((PMMLConstants.PMMLStringTagContent)fieldValue).value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("XML serializaiton failed : failed to parse field " + f.getName(), e);
            }
        }
        return result;
    }

    public static Document toDocument(Object o) throws ParserConfigurationException {
        Named a = o.getClass().getAnnotation(Named.class);
        if (a == null) {
            throw new IllegalArgumentException("Top node should be annotated with @Root");
        }
        String docName = a.name();
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = f.newDocumentBuilder();
        Document doc = builder.newDocument();
        doc.appendChild(XML.objectToNode(doc, o, docName));
        return doc;
    }

    public static Document toDocument(Object o, Map<String, String> additionalAttributes) throws ParserConfigurationException {
        Named a = o.getClass().getAnnotation(Named.class);
        if (a == null) {
            throw new IllegalArgumentException("Top node should be annotated with @Root");
        }
        String docName = a.name();
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = f.newDocumentBuilder();
        Document doc = builder.newDocument();
        doc.appendChild(XML.objectToNode(doc, o, docName));
        return doc;
    }

    public static Node toNode(Document doc, Object o) {
        Named a = o.getClass().getAnnotation(Named.class);
        if (a == null) {
            throw new IllegalArgumentException("Top node should be annotated with @Root, or use the toNode method with the tagName parameter instead.");
        }
        String name = a.name();
        return XML.objectToNode(doc, o, name);
    }

    public static Node toNode(Document doc, Object o, String tagName) {
        return XML.objectToNode(doc, o, tagName);
    }

    public static interface XMLPrimitive {
        public String getName();

        public Node toNode(Document var1, String var2);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Named {
        public String name();
    }

    public static interface CustomAttribute {
        public String getName();

        public String getValue();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Attribute {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Element {
    }
}

