/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scoring.exports.pmml.helpers;

import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionPreprocessingParams;
import com.dataiku.dip.scoring.exports.pmml.helpers.PMMLSegmentations;
import com.dataiku.dip.scoring.exports.pmml.models.classification.multiclass.PMMLTreeMultiClassClassifier;
import com.dataiku.scoring.models.DecisionTreeClassifier;
import com.dataiku.scoring.models.ForestClassifier;
import com.dataiku.scoring.pipelines.ClassificationPipeline;

public class TreeUtils {
    public static void addTreesToSegmentation(ClassificationPipeline pipe, ResolvedPredictionPreprocessingParams rppp, PMMLSegmentations.PMMLTreeMultiClassSegmentation segmentation) {
        ForestClassifier forest = (ForestClassifier)pipe.getModel();
        switch (forest.getPolicy()) {
            case AVERAGE: {
                segmentation.multipleModelMethod = "average";
                break;
            }
            case VOTE: {
                segmentation.multipleModelMethod = "majorityVote";
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(forest.getPolicy()));
            }
        }
        int treeIndex = 0;
        for (DecisionTreeClassifier t : forest.getTrees()) {
            segmentation.Segment.add(new PMMLSegmentations.PMMLTreeMultiClassSegmentation.PMMLSegment(new PMMLTreeMultiClassClassifier(pipe, rppp, t, treeIndex)));
            ++treeIndex;
        }
    }
}

