/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scoring.exports.pmml.models.classification;

import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionPreprocessingParams;
import com.dataiku.dip.scoring.exports.pmml.XML;
import com.dataiku.dip.scoring.exports.pmml.helpers.PMMLTransformationDictionary;
import com.dataiku.dip.scoring.exports.pmml.models.PMMLModel;
import com.dataiku.dip.scoring.exports.pmml.models.classification.binary.PMMLGradientBoostingBinaryClassifier;
import com.dataiku.dip.scoring.exports.pmml.models.classification.binary.PMMLLogisticBinaryClassifier;
import com.dataiku.dip.scoring.exports.pmml.models.classification.binary.PMMLRandomForestBinaryClassifier;
import com.dataiku.dip.scoring.exports.pmml.models.classification.binary.PMMLTreeBinaryClassifier;
import com.dataiku.dip.scoring.exports.pmml.models.classification.multiclass.PMMLGradientBoostingMultiClassClassifier;
import com.dataiku.dip.scoring.exports.pmml.models.classification.multiclass.PMMLLogisticMultiClassClassifier;
import com.dataiku.dip.scoring.exports.pmml.models.classification.multiclass.PMMLRandomForestMultiClassClassifier;
import com.dataiku.dip.scoring.exports.pmml.models.classification.multiclass.PMMLTreeMultiClassClassifier;
import com.dataiku.scoring.models.Classifier;
import com.dataiku.scoring.models.DecisionTreeClassifier;
import com.dataiku.scoring.models.ForestClassifier;
import com.dataiku.scoring.models.GradientBoostingClassifier;
import com.dataiku.scoring.models.LogisticRegression;
import com.dataiku.scoring.pipelines.BinaryProbabilisticPipeline;
import com.dataiku.scoring.pipelines.BinaryProbabilisticPipelineImpl;
import com.dataiku.scoring.pipelines.ClassificationPipeline;
import com.dataiku.scoring.pipelines.MulticlassProbabilisticPipeline;

public abstract class PMMLClassifier
extends PMMLModel {
    @XML.Attribute
    final String functionName = "classification";

    public PMMLClassifier(ClassificationPipeline pipe, ResolvedPredictionPreprocessingParams rppp) {
        this.MiningSchema = PMMLModel.PMMLMiningSchema.createFrom(pipe, rppp);
    }

    public static PMMLClassifier fromClassificationPipeline(ClassificationPipeline pipe, ResolvedPredictionPreprocessingParams rppp) {
        Classifier model = pipe.getModel();
        boolean isBinaryProbabilitic = pipe instanceof BinaryProbabilisticPipeline;
        if (model instanceof LogisticRegression) {
            return isBinaryProbabilitic ? new PMMLLogisticBinaryClassifier((BinaryProbabilisticPipeline)pipe, rppp) : new PMMLLogisticMultiClassClassifier((MulticlassProbabilisticPipeline)pipe, rppp);
        }
        if (model instanceof DecisionTreeClassifier) {
            return isBinaryProbabilitic ? new PMMLTreeBinaryClassifier((BinaryProbabilisticPipeline)pipe, rppp) : new PMMLTreeMultiClassClassifier((MulticlassProbabilisticPipeline)pipe, rppp);
        }
        if (model instanceof ForestClassifier) {
            return isBinaryProbabilitic ? new PMMLRandomForestBinaryClassifier((BinaryProbabilisticPipeline)pipe, rppp) : new PMMLRandomForestMultiClassClassifier((MulticlassProbabilisticPipeline)pipe, rppp);
        }
        if (model instanceof GradientBoostingClassifier) {
            return isBinaryProbabilitic ? new PMMLGradientBoostingBinaryClassifier((BinaryProbabilisticPipeline)((BinaryProbabilisticPipelineImpl)pipe), rppp) : new PMMLGradientBoostingMultiClassClassifier((MulticlassProbabilisticPipeline)pipe, rppp);
        }
        throw new IllegalArgumentException("Algorithm " + String.valueOf(pipe.getModel().getClass()) + " not supported for PMML export.");
    }

    public abstract void enrichTransformationDictionaryFromModel(PMMLTransformationDictionary var1, String[] var2, Classifier var3);
}

