/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthorizationMatrix;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AuthorizationMatrixBuilder {
    @Autowired
    private UsersService usersService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    private LimitsStatusComputer.LicenseLimitsStatus lls;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.security.authorizationmatrix");

    public AuthorizationMatrixBuilder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public AuthorizationMatrix compute() throws Exception {
        AuthorizationMatrix ret = new AuthorizationMatrix();
        List<SerializedProject> allProjects = this.projectsService.listAllUnsafe();
        List<UsersDAO.User> allUsers = this.usersService.listUsersInternalUnsafeEnabledOnly();
        ret.perUser = this.computePerUser(allProjects, allUsers);
        ret.perGroup = this.computePerGroup(allProjects);
        return ret;
    }

    public AuthorizationMatrix.PerUser computePerUser(Collection<SerializedProject> projects, Collection<UsersDAO.User> users) throws IOException {
        if (this.lls == null) {
            this.lls = this.licenseEnforcementService.getLimitsStatus();
        }
        AuthorizationMatrix.PerUser perUser = new AuthorizationMatrix.PerUser();
        ArrayList<DSSAuthCtx> lius = new ArrayList<DSSAuthCtx>();
        perUser.users = new ArrayList<PublicUser>();
        for (UsersDAO.User u : users) {
            PublicUser pu = new PublicUser();
            pu.login = u.login;
            pu.displayName = u.displayName;
            perUser.users.add(pu);
            DSSAuthCtx liu = DSSAuthCtx.forUserLogin(u);
            lius.add(liu);
            perUser.setPermissions(liu.getPermissions());
        }
        for (SerializedProject sp : projects) {
            AuthorizationMatrix.ProjectGrants grants = new AuthorizationMatrix.ProjectGrants();
            grants.projectKey = sp.projectKey;
            grants.projectName = sp.name;
            for (AuthCtx authCtx : lius) {
                grants.grants.add(this.computeProjectGrant(authCtx, sp));
            }
            perUser.projectsGrants.add(grants);
        }
        return perUser;
    }

    private AuthorizationMatrix.PerGroup computePerGroup(List<SerializedProject> projects) throws IOException {
        AuthorizationMatrix.PerGroup perGroup = new AuthorizationMatrix.PerGroup();
        List<UsersDAO.Group> groups = this.usersDAO.listGroupsUnsafe();
        perGroup.groups = new ArrayList<String>();
        for (UsersDAO.Group g : groups) {
            perGroup.groups.add(g.name);
            perGroup.setPermissions(g);
        }
        for (SerializedProject sp : projects) {
            AuthorizationMatrix.ProjectGrants grants = new AuthorizationMatrix.ProjectGrants();
            grants.projectKey = sp.projectKey;
            grants.projectName = sp.name;
            for (UsersDAO.Group g : groups) {
                grants.grants.add(this.computeProjectGrant(g, sp));
            }
            perGroup.projectsGrants.add(grants);
        }
        return perGroup;
    }

    public AuthorizationMatrix.PerPendingUserEmail computePerPendingUserEmail(Collection<SerializedProject> projects) {
        AuthorizationMatrix.PerPendingUserEmail perPendingUserEmail = new AuthorizationMatrix.PerPendingUserEmail();
        HashSet<String> pendingUserEmails = new HashSet<String>();
        for (SerializedProject sp : projects) {
            for (SerializedProject.PermissionItem pi : sp.permissions) {
                if (pi == null || pi.pendingUserEmail == null || pi.isEmpty()) continue;
                pendingUserEmails.add(pi.pendingUserEmail.toLowerCase(Locale.ROOT));
            }
        }
        perPendingUserEmail.pendingUserEmails = new ArrayList<String>(pendingUserEmails);
        for (SerializedProject sp : projects) {
            AuthorizationMatrix.ProjectGrants grants = new AuthorizationMatrix.ProjectGrants();
            grants.projectKey = sp.projectKey;
            grants.projectName = sp.name;
            for (String pendingUserEmail : pendingUserEmails) {
                grants.grants.add(this.computeProjectGrant(pendingUserEmail, sp));
            }
            perPendingUserEmail.projectsGrants.add(grants);
        }
        return perPendingUserEmail;
    }

    private AuthorizationMatrix.ProjectGrant computeProjectGrant(AuthCtx u, SerializedProject sp) {
        AuthorizationMatrix.ProjectGrant ret = new AuthorizationMatrix.ProjectGrant();
        assert (sp != null);
        assert (sp.permissions != null);
        SerializedProject.PermissionItem maxPermission = new SerializedProject.PermissionItem();
        String user = u.getAssociatedDSSUser();
        if (StringUtils.equals((String)user, (String)sp.owner) || u.isAdmin()) {
            maxPermission.admin = true;
            PermissionsService.makeEffective(maxPermission);
            ret.grantedBy.add("Global administrator");
        } else {
            LimitsStatusComputer.LicensedProfile lp;
            for (String gid : u.getGroupsIfRelevant()) {
                for (SerializedProject.PermissionItem pi : sp.permissions) {
                    if (pi == null || !gid.equals(pi.group)) continue;
                    ret.grantedBy.add("Group " + gid);
                    maxPermission.addPermissionsFrom(pi);
                }
            }
            if (user != null) {
                for (SerializedProject.PermissionItem pi : sp.permissions) {
                    if (pi == null || !user.equals(pi.user)) continue;
                    ret.grantedBy.add("User " + user);
                    maxPermission.addPermissionsFrom(pi);
                }
                for (SerializedProject.AdditionalDashboardUser adu : sp.additionalDashboardUsers.users) {
                    if (!adu.login.equals(user)) continue;
                    maxPermission.readDashboards = true;
                    break;
                }
            }
            if ((lp = (LimitsStatusComputer.LicensedProfile)this.lls.licensedProfiles.get(u.getUserProfile())) == null) {
                lp = (LimitsStatusComputer.LicensedProfile)this.lls.licensedProfiles.get(this.lls.fallbackProfile);
            }
            PermissionsService.makeEffective(maxPermission);
            if (!lp.mayAdmin) {
                maxPermission.admin = false;
            }
            if (!lp.mayWriteProjectContent) {
                maxPermission.writeProjectContent = false;
            }
            if (!lp.mayReadProjectContent) {
                maxPermission.readProjectContent = false;
            }
            if (!lp.mayWriteDashboards) {
                maxPermission.writeDashboards = false;
            }
        }
        if (!maxPermission.isEmpty()) {
            ret.item = maxPermission;
            return ret;
        }
        return null;
    }

    private AuthorizationMatrix.ProjectGrant computeProjectGrant(UsersDAO.Group group, SerializedProject sp) {
        AuthorizationMatrix.ProjectGrant ret = new AuthorizationMatrix.ProjectGrant();
        assert (sp != null);
        assert (sp.permissions != null);
        SerializedProject.PermissionItem maxPermission = new SerializedProject.PermissionItem();
        if (group.isAdmin()) {
            maxPermission.admin = true;
            ret.grantedBy.add("Global administrator");
        }
        for (SerializedProject.PermissionItem pi : sp.permissions) {
            if (pi == null || !group.name.equals(pi.group)) continue;
            ret.grantedBy.add("Group " + group.name);
            maxPermission.addPermissionsFrom(pi);
        }
        if (!maxPermission.isEmpty()) {
            ret.item = maxPermission;
            PermissionsService.makeEffective(ret.item);
            return ret;
        }
        return null;
    }

    private AuthorizationMatrix.ProjectGrant computeProjectGrant(String pendingUserEmail, SerializedProject sp) {
        AuthorizationMatrix.ProjectGrant ret = new AuthorizationMatrix.ProjectGrant();
        SerializedProject.PermissionItem maxPermission = new SerializedProject.PermissionItem();
        for (SerializedProject.PermissionItem pi : sp.permissions) {
            if (pi == null || !pendingUserEmail.equalsIgnoreCase(pi.pendingUserEmail)) continue;
            ret.grantedBy.add("Pending user email " + pendingUserEmail);
            maxPermission.addPermissionsFrom(pi);
        }
        if (!maxPermission.isEmpty()) {
            ret.item = maxPermission;
            PermissionsService.makeEffective(ret.item);
            return ret;
        }
        return null;
    }
}

