/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.code;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.AvailablePythonInterpretersService;
import com.dataiku.dip.code.CodeEnvImportUtils;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvUsagesService;
import com.dataiku.dip.code.CodeEnvUtilsBase;
import com.dataiku.dip.code.DesignNodeCodeEnvPackagePresets;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.requestcenter.Request;
import com.dataiku.dip.requestcenter.RequestsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class CodeEnvsAdminController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private CodeEnvUsagesService codeEnvUsagesService;
    @Autowired
    private DesignNodeCodeEnvsService designNodeEnvsService;
    @Autowired
    private AutomationNodeCodeEnvsService automationNodeEnvsService;
    @Autowired
    private AvailablePythonInterpretersService availablePythonInterpretersService;
    @Autowired
    private IPluginsRegistryService pluginsRegistryService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private RequestsService requestService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.codeenv.admin");

    @AuditedCall(value={"msgType", "admin-code-envs-list"})
    @RequestMapping(value={"/api/code-envs/design/list"})
    public void designListEnvs(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        List<CodeEnvModel.CodeEnvListItem> envs = this.designNodeEnvsService.listCodeEnvsWithKernelSpecNames_NT();
        ArrayList accessibleEnvs = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            for (CodeEnvModel.CodeEnvListItem env : envs) {
                env.canUpdateCodeEnv = this.permissionsService.hasCodeEnvPrivilege(authCtx, env.envLang, env.envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
                env.canManageUsersCodeEnv = this.permissionsService.hasCodeEnvPrivilege(authCtx, env.envLang, env.envName, Privileges.CodeEnvLevelPrivilegeType.MANAGE_USERS);
                if (!this.permissionsService.hasAnyCodeEnvAccess(authCtx, env.envLang, env.envName)) continue;
                accessibleEnvs.add(env);
            }
        }
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, (Object)accessibleEnvs);
    }

    @AuditedCall(value={"msgType", "admin-code-envs-list"})
    @RequestMapping(value={"/api/code-envs/design/list-names"})
    public void anyListEnvs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        List<CodeEnvModel.CodeEnvListItem> items = this.designNodeEnvsService.listCodeEnvs();
        ArrayList ret = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            for (CodeEnvModel.CodeEnvListItem item : items) {
                if (item.envLang != CodeEnvModel.EnvLang.valueOf(envLang) || !this.permissionsService.hasAnyCodeEnvAccess(authCtx, item.envLang, item.envName)) continue;
                ret.add(item.envName);
            }
        }
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "admin-code-envs-list-logs", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/design/list-logs"})
    public void listDesignLogs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.designNodeEnvsService.listLogs(CodeEnvModel.EnvLang.valueOf(envLang), envName));
    }

    @AuditedCall(value={"msgType", "admin-code-envs-stream-log", "envLang", "${envLang}", "envName", "${envName}", "logName", "${logName}"})
    @RequestMapping(value={"/api/code-envs/design/stream-log"})
    public void streamDesignLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam String logName) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUserNoXSRF(req);
        }
        String dlName = DKUtils.getCompressedLogFileName((String)logName);
        resp.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", dlName));
        this.designNodeEnvsService.streamLog(CodeEnvModel.EnvLang.valueOf(envLang), envName, logName, (OutputStream)resp.getOutputStream());
    }

    @AuditedCall(value={"msgType", "admin-code-envs-get-log", "envLang", "${envLang}", "envName", "${envName}", "logName", "${logName}"})
    @RequestMapping(value={"/api/code-envs/design/get-log"})
    public void getDesignLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam String logName) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, (Object)this.designNodeEnvsService.getLog(CodeEnvModel.EnvLang.valueOf(envLang), envName, logName));
    }

    @AuditedCall(value={"msgType", "admin-code-envs-list-logs", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/automation/list-logs"})
    public void listAutomationLogs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.automationNodeEnvsService.listLogs(CodeEnvModel.EnvLang.valueOf(envLang), envName));
    }

    @AuditedCall(value={"msgType", "admin-code-envs-stream-log", "envLang", "${envLang}", "envName", "${envName}", "logName", "${logName}"})
    @RequestMapping(value={"/api/code-envs/automation/stream-log"})
    public void streamAutomationLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam String logName) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUserNoXSRF(req);
        }
        String dlName = DKUtils.getCompressedLogFileName((String)logName);
        resp.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", dlName));
        this.automationNodeEnvsService.streamLog(CodeEnvModel.EnvLang.valueOf(envLang), envName, logName, (OutputStream)resp.getOutputStream());
    }

    @AuditedCall(value={"msgType", "admin-code-envs-get-log", "envLang", "${envLang}", "envName", "${envName}", "logName", "${logName}"})
    @RequestMapping(value={"/api/code-envs/automation/get-log"})
    public void getAutomationLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam String logName) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, (Object)this.automationNodeEnvsService.getLog(CodeEnvModel.EnvLang.valueOf(envLang), envName, logName));
    }

    @RequestMapping(value={"/api/code-envs/design/prepare-from-request"})
    public void designPrepareEnvFromRequest(HttpServletRequest req, HttpServletResponse resp, @RequestParam String requestId) throws Exception {
        try {
            DSSAuthCtx authCtx = null;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
                if (!authCtx.getPermissions().mayCreateCodeEnvs()) {
                    throw new SecurityException("You may not create new code envs from requests");
                }
            }
            Request request = Optional.ofNullable(this.requestService.getRequestOrNull(requestId)).orElseThrow(() -> new IllegalArgumentException("No request found for id :" + requestId));
            if (request.objectType != Request.RequestObjectType.CODE_ENV) {
                throw new IllegalArgumentException("The request " + requestId + " is not a code env request");
            }
            if (request.status != Request.RequestStatus.PENDING) {
                throw new IllegalArgumentException("The code env cannot be created from request " + requestId + " since it has been already processed");
            }
            Request.CodeEnvRequestDetails codeEnvRequestDetails = (Request.CodeEnvRequestDetails)request.requestDetails;
            DesignNodeCodeEnvsService.CodeEnvDraft response = this.designNodeEnvsService.prepareCodeEnv(authCtx, request.objectId, codeEnvRequestDetails.desc, codeEnvRequestDetails.envLang, codeEnvRequestDetails.specCondaEnvironment, codeEnvRequestDetails.specPackagesList);
            CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, (Object)response);
            this.auditTrailService.generic("admin-code-env-prepare-from-request").with("requestId", requestId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-code-env-prepare-from-request", (Throwable)e).with("requestId", requestId).emit();
            throw e;
        }
    }

    @RequestMapping(value={"/api/code-envs/design/prepare-from-project-import"})
    public void designPrepareEnvFromProjectImport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam String desc, @RequestParam String specCondaEnvironment, @RequestParam String specPackageList) throws Exception {
        try {
            CodeEnvModel.AbstractEnvDesc envDesc;
            DSSAuthCtx authCtx = null;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
                if (!authCtx.getPermissions().mayCreateCodeEnvs()) {
                    throw new SecurityException("You may not create new code envs from requests");
                }
            }
            CodeEnvModel.EnvLang lang = CodeEnvModel.EnvLang.valueOf(envLang);
            if (lang == CodeEnvModel.EnvLang.PYTHON) {
                envDesc = (CodeEnvModel.AbstractEnvDesc)JSON.parse((String)desc, CodeEnvModel.PythonEnvDesc.class);
            } else if (lang == CodeEnvModel.EnvLang.R) {
                envDesc = (CodeEnvModel.AbstractEnvDesc)JSON.parse((String)desc, CodeEnvModel.REnvDesc.class);
            } else {
                throw new NotImplementedException();
            }
            DesignNodeCodeEnvsService.CodeEnvDraft response = this.designNodeEnvsService.prepareCodeEnv(authCtx, envName, envDesc, lang, specCondaEnvironment, specPackageList);
            CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, (Object)response);
            this.auditTrailService.generic("admin-code-env-prepare-from-project-import").with("envLang", envLang).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-code-env-prepare-from-project-import", (Throwable)e).with("envLang", envLang).emit();
            throw e;
        }
    }

    @RequestMapping(value={"/api/code-envs/design/draft/{codeEnvDraftId}"})
    public void getCodeEnvDraft(HttpServletRequest req, HttpServletResponse resp, @PathVariable String codeEnvDraftId) throws Exception {
        DSSAuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (!authCtx.getPermissions().mayCreateCodeEnvs()) {
                throw new SecurityException("You may not create new code envs from requests");
            }
        }
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, (Object)this.designNodeEnvsService.getCodeEnvDraft(codeEnvDraftId));
    }

    @RequestMapping(value={"/api/code-envs/design/draft/{codeEnvDraftId}/create"})
    public void designCreateEnvFromDraft(HttpServletRequest req, HttpServletResponse resp, @PathVariable String codeEnvDraftId, @RequestParam String envLang, @RequestParam String envSpec) throws Exception {
        try {
            DSSAuthCtx authCtx = null;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
                if (!authCtx.getPermissions().mayCreateCodeEnvs()) {
                    throw new SecurityException("You may not create new code envs");
                }
            }
            CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.designNodeEnvsService.startCreateEnvFromDraft(authCtx, codeEnvDraftId, envLang, envSpec));
            this.auditTrailService.generic("admin-code-env-create-from-draft").with("envLang", envLang).with("draftId", codeEnvDraftId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-code-env-create-from-draft", (Throwable)e).with("envLang", envLang).emit();
            throw e;
        }
    }

    @RequestMapping(value={"/api/code-envs/design/create"})
    public void designCreateEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envSpec) throws Exception {
        block12: {
            try {
                CodeEnvModel.AbstractEnvDesc newEnvSpec;
                DSSAuthCtx authCtx = null;
                try (Transaction t = this.transactionService.beginRead();){
                    authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
                    if (!authCtx.getPermissions().mayCreateCodeEnvs()) {
                        throw new SecurityException("You may not create new code envs");
                    }
                }
                if (CodeEnvModel.EnvLang.PYTHON.toString().equals(envLang)) {
                    newEnvSpec = (CodeEnvModel.DesignNewPythonEnvSpec)JSON.parse((String)envSpec, CodeEnvModel.DesignNewPythonEnvSpec.class);
                    newEnvSpec.initializeCorePackageSetBasedOnInterpreter();
                    newEnvSpec.owner = authCtx.getIdentifier();
                    this.validateEnvName(newEnvSpec.envName);
                    CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.designNodeEnvsService.startCreatePythonEnv(authCtx, (CodeEnvModel.DesignNewPythonEnvSpec)newEnvSpec));
                    this.auditTrailService.generic("admin-code-env-create").with("envLang", envLang).with("envName", newEnvSpec.envName).emit();
                    break block12;
                }
                if (CodeEnvModel.EnvLang.R.toString().equals(envLang)) {
                    newEnvSpec = (CodeEnvModel.DesignNewREnvSpec)JSON.parse((String)envSpec, CodeEnvModel.DesignNewREnvSpec.class);
                    ((CodeEnvModel.DesignNewREnvSpec)newEnvSpec).owner = authCtx.getIdentifier();
                    this.validateEnvName(((CodeEnvModel.DesignNewREnvSpec)newEnvSpec).envName);
                    CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.designNodeEnvsService.startCreateREnv(authCtx, (CodeEnvModel.DesignNewREnvSpec)newEnvSpec));
                    this.auditTrailService.generic("admin-code-env-create").with("envLang", envLang).with("envName", ((CodeEnvModel.DesignNewREnvSpec)newEnvSpec).envName).emit();
                    break block12;
                }
                throw new NotImplementedException();
            }
            catch (Exception e) {
                this.auditTrailService.failure("admin-code-env-create", (Throwable)e).with("envLang", envLang).emit();
                throw e;
            }
        }
    }

    private void validateEnvName(String envName) throws IOException {
        if (StringUtils.isBlank((String)envName)) {
            throw new IllegalArgumentException("Name not defined");
        }
        if (CodeEnvUtilsBase.getEnvNamesSet().contains(envName)) {
            throw new IllegalArgumentException("Name already used");
        }
        if (!Pattern.matches("[_A-Za-z0-9-]+", envName)) {
            throw new IllegalArgumentException("Name contains illegal characters (only a-Z, 0-9, _ and - allowed))");
        }
    }

    @AuditedCall(value={"msgType", "admin-code-env-package-presets-python", "interpreter", "${interpreter}", "useConda", "${useConda}"})
    @RequestMapping(value={"/api/code-envs/design/package-presets/python"})
    @ResponseBody
    public List<DesignNodeCodeEnvPackagePresets.CodeEnvPackagePreset> designListPythonPackagePresets(HttpServletRequest req, @RequestParam StandardPythonInterpreter interpreter, @RequestParam(defaultValue="false") boolean useConda, @RequestParam(defaultValue="") String corePackageSet) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        return DesignNodeCodeEnvPackagePresets.forPython(interpreter, useConda, corePackageSet);
    }

    @AuditedCall(value={"msgType", "admin-code-env-update-package-presets-python", "interpreter", "${interpreter}"})
    @RequestMapping(value={"/api/code-envs/design/update-package-presets/python"})
    public void designUpdatePythonPackagePresets(HttpServletRequest req, HttpServletResponse resp, @RequestParam String specPackageList, @RequestParam StandardPythonInterpreter interpreter) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        resp.setContentType("text/plain; charset=UTF-8");
        resp.getWriter().write(this.designNodeEnvsService.updatePackagesRequirements(specPackageList, interpreter));
    }

    @AuditedCall(value={"msgType", "admin-code-env-get", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/design/get"})
    public void designGetEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        CodeEnvModel.AbstractDesignUIEnv<?> env = this.designNodeEnvsService.getEnvForUI(el, envName, true);
        try (Transaction t = this.transactionService.beginRead();){
            env.canManageUsersCodeEnv = this.permissionsService.hasCodeEnvPrivilege(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.MANAGE_USERS);
            env.canUpdateCodeEnv = this.permissionsService.hasCodeEnvPrivilege(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
        }
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, env);
    }

    @AuditedCall(value={"msgType", "admin-code-env-save", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/design/save"})
    public void designSaveEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam String data) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        boolean canManageUsers = false;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
            canManageUsers = this.permissionsService.hasCodeEnvPrivilege(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.MANAGE_USERS);
        }
        logger.infoV("Saving code env name=%s canManageUsers=%s", new Object[]{envName, canManageUsers});
        CodeEnvModel.AbstractDesignUIEnv env = switch (el) {
            case CodeEnvModel.EnvLang.PYTHON -> (CodeEnvModel.DesignUIPythonEnv)JSON.parse((String)data, CodeEnvModel.DesignUIPythonEnv.class);
            case CodeEnvModel.EnvLang.R -> (CodeEnvModel.DesignUIREnv)JSON.parse((String)data, CodeEnvModel.DesignUIREnv.class);
            default -> throw new Error("unreachable");
        };
        this.designNodeEnvsService.saveEnvForUI(authCtx, el, envName, env, canManageUsers);
    }

    @AuditedCall(value={"msgType", "admin-code-env-save", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/automation/save"})
    public void automationSaveEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam String data) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        boolean canManageUsers = false;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
            canManageUsers = this.permissionsService.hasCodeEnvPrivilege(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.MANAGE_USERS);
        }
        logger.infoV("Saving code env name=%s canManageUsers=%s", new Object[]{envName, canManageUsers});
        CodeEnvModel.AutomationUIEnv env = el == CodeEnvModel.EnvLang.PYTHON ? (CodeEnvModel.AutomationUIEnv)JSON.parse((String)data, CodeEnvModel.AutomationUIPythonEnv.class) : (CodeEnvModel.AutomationUIEnv)JSON.parse((String)data, CodeEnvModel.AutomationUIREnv.class);
        this.automationNodeEnvsService.saveEnvForUI(authCtx, el, envName, env, canManageUsers);
    }

    @AuditedCall(value={"msgType", "admin-code-env-save", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/automation/save-version"})
    public void automationSaveEnvVersion(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam String data) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            boolean canUpdate = this.permissionsService.hasCodeEnvPrivilege(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
            if (!canUpdate) {
                throw new UnauthorizedException("Action forbidden", "codeenv-authorization-failure").with("requiredPrivileges", "UPDATE");
            }
        }
        CodeEnvModel.AbstractAutomationUIEnvVersion env = el == CodeEnvModel.EnvLang.PYTHON ? (CodeEnvModel.AbstractAutomationUIEnvVersion)JSON.parse((String)data, CodeEnvModel.AutomationUIPythonEnvVersion.class) : (CodeEnvModel.AbstractAutomationUIEnvVersion)JSON.parse((String)data, CodeEnvModel.AutomationUIREnvVersion.class);
        this.automationNodeEnvsService.saveEnvVersionForUI(authCtx, el, envName, env);
    }

    @AuditedCall(value={"msgType", "admin-code-env-update", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/design/update"})
    public void designUpdateEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam String updateSettings) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        CodeEnvModel.CodeEnvUpdateSettings updateSettingsObj = (CodeEnvModel.CodeEnvUpdateSettings)JSON.parse((String)updateSettings, CodeEnvModel.CodeEnvUpdateSettings.class);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
        }
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.designNodeEnvsService.startUpdateEnvAccordingToSpec(authCtx, el, envName, updateSettingsObj));
    }

    @AuditedCall(value={"msgType", "admin-code-env-recreate", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/design/recreate"})
    public void designRecreateEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
        }
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.designNodeEnvsService.startRecreateEnvAccordingToSpec(authCtx, el, envName));
    }

    @AuditedCall(value={"msgType", "admin-code-env-get-details", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/design/fetch-non-managed-env-details"})
    public void fetchNonManagedEnvDetails(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
        }
        File log = ApplicationConfigurator.getFile((File)this.designNodeEnvsService.getEnvLogsDir(el, envName), (String[])new String[]{"fetchDetails.log"});
        DKUFileUtils.mkdirsParent((File)log);
        DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        switch (el) {
            case PYTHON: {
                CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, (Object)this.designNodeEnvsService.computePyEnvActualData(authCtx, envName, logTailBuilder, log));
                break;
            }
            case R: {
                CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, (Object)this.designNodeEnvsService.computeREnvActualData(authCtx, envName, logTailBuilder, log));
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
    }

    @AuditedCall(value={"msgType", "admin-code-env-install-jupyter", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/design/install-jupyter-support"})
    public void installDesignJupyterSupport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
        }
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.designNodeEnvsService.startInstallJupyterSupport(authCtx, el, envName));
    }

    @AuditedCall(value={"msgType", "admin-code-env-install-jupyter", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/automation/install-jupyter-support"})
    public void installAutomationJupyterSupport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam(required=false) String versionId) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
        }
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.automationNodeEnvsService.startInstallJupyterSupport(authCtx, el, envName, versionId));
    }

    @AuditedCall(value={"msgType", "admin-code-env-remove-jupyter", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/design/remove-jupyter-support"})
    public void removeDesignJupyterSupport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
        }
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.designNodeEnvsService.startRemoveJupyterSupport(authCtx, el, envName));
    }

    @AuditedCall(value={"msgType", "admin-code-env-remove-jupyter", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/automation/remove-jupyter-support"})
    public void removeAutomationJupyterSupport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam(required=false) String versionId) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
        }
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.automationNodeEnvsService.startRemoveJupyterSupport(authCtx, el, envName, versionId));
    }

    @AuditedCall(value={"msgType", "admin-code-envs-list"})
    @RequestMapping(value={"/api/code-envs/automation/list"})
    public void automationListEnvs(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        List<CodeEnvModel.CodeEnvListItem> envs = this.automationNodeEnvsService.listCodeEnvsWithKernelSpecNames_NT();
        ArrayList accessibleEnvs = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            for (CodeEnvModel.CodeEnvListItem env : envs) {
                env.canUpdateCodeEnv = this.permissionsService.hasCodeEnvPrivilege(authCtx, env.envLang, env.envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
                env.canManageUsersCodeEnv = this.permissionsService.hasCodeEnvPrivilege(authCtx, env.envLang, env.envName, Privileges.CodeEnvLevelPrivilegeType.MANAGE_USERS);
                if (!this.permissionsService.hasAnyCodeEnvAccess(authCtx, env.envLang, env.envName)) continue;
                accessibleEnvs.add(env);
            }
        }
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, (Object)accessibleEnvs);
    }

    @RequestMapping(value={"/api/code-envs/automation/create"})
    public void automationCreateEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envSpec) throws Exception {
        try {
            DSSAuthCtx authCtx = null;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
                if (!authCtx.getPermissions().mayCreateCodeEnvs()) {
                    throw new SecurityException("You may not create new code envs");
                }
            }
            CodeEnvModel.AutomationNewEnvSpec newEnvSpec = (CodeEnvModel.AutomationNewEnvSpec)JSON.parse((String)envSpec, CodeEnvModel.AutomationNewEnvSpec.class);
            newEnvSpec.owner = authCtx.getIdentifier();
            this.validateEnvName(newEnvSpec.envName);
            newEnvSpec.envLang = CodeEnvModel.EnvLang.valueOf(envLang);
            CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.automationNodeEnvsService.startCreateEnv(authCtx, newEnvSpec));
            this.auditTrailService.generic("admin-code-env-create").with("envLang", envLang).with("envName", newEnvSpec.envName).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-code-env-create", (Throwable)e).with("envLang", envLang).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "admin-code-env-get", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/automation/get"})
    public void automationGetEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        CodeEnvModel.AutomationUIEnv<?> env = this.automationNodeEnvsService.getEnvForUI(el, envName, true);
        try (Transaction t = this.transactionService.beginRead();){
            env.canUpdateCodeEnv = this.permissionsService.hasCodeEnvPrivilege(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
            env.canManageUsersCodeEnv = this.permissionsService.hasCodeEnvPrivilege(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.MANAGE_USERS);
        }
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, env);
    }

    @AuditedCall(value={"msgType", "admin-code-env-get", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/automation/get-version"})
    public void automationGetEnvVersion(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam String versionId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        CodeEnvModel.AbstractAutomationUIEnvVersion<?> env = this.automationNodeEnvsService.getEnvVersionForUI(el, envName, versionId);
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, env);
    }

    @AuditedCall(value={"msgType", "admin-code-env-update", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/automation/update"})
    public void automationUpdateEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam String updateSettings) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        CodeEnvModel.CodeEnvUpdateSettings updateSettingsObj = (CodeEnvModel.CodeEnvUpdateSettings)JSON.parse((String)updateSettings, CodeEnvModel.CodeEnvUpdateSettings.class);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
        }
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.automationNodeEnvsService.startUpdateEnvAccordingToSpec(authCtx, el, envName, updateSettingsObj));
    }

    @AuditedCall(value={"msgType", "admin-code-env-export", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/automation/download-diagnostic"})
    public void automationDiagEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName) throws IOException, DKUSecurityException {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
        }
        try {
            HashMap exported = Maps.newHashMap();
            exported.put("def/", AutomationNodeCodeEnvsService.getEnvRootDir(el, envName));
            exported.put("log/", this.automationNodeEnvsService.getEnvLogsDir(el, envName));
            resp.setContentType("application/zip");
            resp.setHeader("Content-Disposition", "attachment; filename=\"dss_" + envName + "_diag.zip\"");
            resp.setStatus(200);
            ZipUnzipDir.zipDirectoriesToStream(exported, new BufferedOutputStream((OutputStream)resp.getOutputStream()), Pattern.compile("^(env|links)/?$"));
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Export failed", (Throwable)e);
            resp.setStatus(404);
            resp.getWriter().write("Code env not found");
        }
    }

    @AuditedCall(value={"msgType", "admin-code-env-get-details", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/automation/fetch-non-managed-env-details"})
    public void automationFetchNonManagedEnvDetails(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
        }
        File log = ApplicationConfigurator.getFile((File)this.automationNodeEnvsService.getEnvLogsDir(CodeEnvModel.EnvLang.PYTHON, envName), (String[])new String[]{"fetchDetails.log"});
        DKUFileUtils.mkdirsParent((File)log);
        DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        switch (el) {
            case PYTHON: {
                CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, (Object)this.automationNodeEnvsService.computePyEnvActualData(authCtx, envName, logTailBuilder, log));
                break;
            }
            case R: {
                CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, (Object)this.automationNodeEnvsService.computeREnvActualData(authCtx, envName, logTailBuilder, log));
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
    }

    @AuditedCall(value={"msgType", "admin-code-env-usages", "envLang", "${envLang}", "envName", "${envName}", "globalOnly", "${globalOnly}"})
    @RequestMapping(value={"/api/code-envs/design/list-usages"})
    public void listDesignUsages(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam(defaultValue="false") boolean globalOnly) throws Exception {
        this.listUsages(req, resp, envLang, envName, globalOnly);
    }

    @AuditedCall(value={"msgType", "admin-code-env-usages", "envLang", "${envLang}", "envName", "${envName}", "globalOnly", "${globalOnly}"})
    @RequestMapping(value={"/api/code-envs/automation/list-usages"})
    public void listAutomationUsages(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam(defaultValue="false") boolean globalOnly) throws Exception {
        this.listUsages(req, resp, envLang, envName, globalOnly);
    }

    private void listUsages(HttpServletRequest req, HttpServletResponse resp, String envLang, String envName, boolean globalOnly) throws IOException, DKUSecurityException {
        String[] stringArray;
        AuthCtx authCtx;
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
        }
        if (globalOnly) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "__DKU_ANY_PROJECT__";
        } else {
            stringArray = new String[]{};
        }
        String[] projectKeys = stringArray;
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.codeEnvUsagesService.listUsagesAnonymize_NT(authCtx, new CodeEnvModel.UsedCodeEnvRef(el, envName), projectKeys));
    }

    @AuditedCall(value={"msgType", "admin-code-env-delete", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/design/delete"})
    public void deleteDesign(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.MANAGE_USERS);
        }
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.designNodeEnvsService.startEnvDelete(authCtx, el, envName));
    }

    @AuditedCall(value={"msgType", "admin-code-env-delete", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/automation/delete"})
    public void deleteAutomation(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.MANAGE_USERS);
        }
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.automationNodeEnvsService.startEnvDelete(authCtx, el, envName));
    }

    @AuditedCall(value={"msgType", "admin-code-envs-list"})
    @RequestMapping(value={"/api/code-envs/plugin/list"})
    public void listForPlugins(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        List<CodeEnvModel.CodeEnvListItem> items = null;
        switch (ApplicationConfigurator.getNodeType()) {
            case AUTOMATION: {
                items = this.automationNodeEnvsService.listCodeEnvsWithKernelSpecNames_NT();
                break;
            }
            case DESIGN: {
                items = this.designNodeEnvsService.listCodeEnvsWithKernelSpecNames_NT();
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
        ArrayList ret = Lists.newArrayList();
        for (CodeEnvModel.CodeEnvListItem item : items) {
            if (item.deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED && item.deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_NON_MANAGED || !item.envName.startsWith("plugin_" + pluginId)) continue;
            ret.add(item);
        }
        switch (ApplicationConfigurator.getNodeType()) {
            case AUTOMATION: {
                for (CodeEnvModel.CodeEnvListItem item : ret) {
                    this.automationNodeEnvsService.checkPluginEnvUptodateWithDefinition(pluginId, item);
                }
                break;
            }
            case DESIGN: {
                for (CodeEnvModel.CodeEnvListItem item : ret) {
                    this.designNodeEnvsService.checkPluginEnvUptodateWithDefinition(pluginId, item);
                }
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
        CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/code-envs/get-plugin-default-available-interpreter"})
    @ResponseBody
    public StandardPythonInterpreter pluginDefaultAvailableInterpreter(HttpServletRequest req, @RequestParam String pluginId) throws IOException {
        DSSAuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (!authCtx.getPermissions().mayCreateCodeEnvs() && !authCtx.getPermissions().mayManageCodeEnvs()) {
                throw new SecurityException("You may not get default code env info");
            }
        }
        InstalledPluginDesc installedDesc = this.pluginsRegistryService.getInstalledDesc(pluginId);
        if (installedDesc == null) {
            throw new IllegalArgumentException("Plugin " + pluginId + " not found");
        }
        CodeEnvModel.EnvLang envLang = installedDesc.codeEnvLang;
        if (envLang != CodeEnvModel.EnvLang.PYTHON || !(installedDesc.codeEnvSpec instanceof CodeEnvModel.PythonPluginEnvDesc)) {
            throw new IllegalArgumentException("Plugin " + pluginId + " env is not a python env");
        }
        List<StandardPythonInterpreter> acceptedPythonInterpreters = ((CodeEnvModel.PythonPluginEnvDesc)installedDesc.codeEnvSpec).acceptedPythonInterpreters;
        List<StandardPythonInterpreter> availablePythonInterpreters = this.availablePythonInterpretersService.getAvailablePythonInterpreters();
        StandardPythonInterpreter defaultInterpreter = CodeEnvUtilsBase.getDefaultInterpreterForPlugin(availablePythonInterpreters, acceptedPythonInterpreters);
        return defaultInterpreter;
    }

    @AuditInline
    @RequestMapping(value={"/api/code-envs/plugin/create"})
    public void pluginCreateEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String desc, @RequestParam(required=false) boolean associateToPlugin) throws Exception {
        try {
            CodeEnvModel.AbstractEnvDesc envDesc;
            DSSAuthCtx authCtx = null;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
                if (!authCtx.getPermissions().mayCreateCodeEnvs()) {
                    throw new SecurityException("You may not create new code envs");
                }
            }
            InstalledPluginDesc installedDesc = this.pluginsRegistryService.getInstalledDesc(pluginId);
            if (installedDesc == null) {
                throw new IllegalArgumentException("Plugin " + pluginId + " not found");
            }
            CodeEnvModel.EnvLang envLang = installedDesc.codeEnvLang;
            if (envLang == CodeEnvModel.EnvLang.PYTHON) {
                envDesc = (CodeEnvModel.AbstractEnvDesc)JSON.parse((String)desc, CodeEnvModel.PythonEnvDesc.class);
            } else if (envLang == CodeEnvModel.EnvLang.R) {
                envDesc = (CodeEnvModel.AbstractEnvDesc)JSON.parse((String)desc, CodeEnvModel.REnvDesc.class);
            } else {
                throw new Error("unreachable");
            }
            String initialEnvName = "plugin_" + pluginId + "_" + (envDesc.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED ? "managed" : "non_managed");
            StringTransmogrifier st2 = new StringTransmogrifier();
            for (String name : CodeEnvUtilsBase.getEnvNamesSet()) {
                st2.addAlreadyTransmogrified(name);
            }
            String envName = st2.transmogrify(initialEnvName);
            File envFolder = new File(new File(this.pluginsRegistryService.getActualPluginFolder(pluginId), "code-env"), envLang.getFolderName());
            File unzipDir = CodeEnvUtilsBase.preparePluginImport(envFolder, envLang, envDesc, this.availablePythonInterpretersService.getAvailablePythonInterpreters());
            CodeEnvModel.CodeEnvUpdateSettings updateSettings = new CodeEnvModel.CodeEnvUpdateSettings();
            switch (ApplicationConfigurator.getNodeType()) {
                case AUTOMATION: {
                    CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.automationNodeEnvsService.startImportEnv(authCtx, authCtx.getIdentifier(), envDesc.deploymentMode, envName, envLang, unzipDir, unzipDir, updateSettings, pluginId, associateToPlugin));
                    break;
                }
                case DESIGN: {
                    CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.designNodeEnvsService.startImportEnv(authCtx, authCtx.getIdentifier(), envDesc.deploymentMode, envName, envLang, unzipDir, unzipDir, updateSettings, pluginId, associateToPlugin));
                    break;
                }
                default: {
                    throw new Error("unreachable");
                }
            }
            this.auditTrailService.generic("admin-code-env-create").with("envLang", envLang.name()).with("envName", envName).with("pluginId", pluginId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-code-env-create", (Throwable)e).with("pluginId", pluginId).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/code-envs/plugin/update"})
    public void pluginUpdateEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String envName) throws Exception {
        try {
            AuthCtx authCtx = null;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
                this.authService.failIfNotAdmin(authCtx);
            }
            InstalledPluginDesc installedDesc = this.pluginsRegistryService.getInstalledDesc(pluginId);
            if (installedDesc == null) {
                throw new IllegalArgumentException("Plugin " + pluginId + " not found");
            }
            CodeEnvModel.EnvLang envLang = installedDesc.codeEnvLang;
            File envFolder = new File(new File(this.pluginsRegistryService.getActualPluginFolder(pluginId), "code-env"), envLang.getFolderName());
            CodeEnvModel.CodeEnvUpdateSettings updateSettings = new CodeEnvModel.CodeEnvUpdateSettings();
            switch (ApplicationConfigurator.getNodeType()) {
                case AUTOMATION: {
                    this.automationNodeEnvsService.updateSpecFromPlugin(authCtx, envLang, envName, envFolder);
                    CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.automationNodeEnvsService.startUpdateEnvAccordingToSpec(authCtx, envLang, envName, updateSettings, pluginId));
                    break;
                }
                case DESIGN: {
                    this.designNodeEnvsService.updateSpecFromPlugin(authCtx, envLang, envName, envFolder);
                    CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.designNodeEnvsService.startUpdateEnvAccordingToSpec(authCtx, envLang, envName, updateSettings, pluginId));
                    break;
                }
                default: {
                    throw new Error("unreachable");
                }
            }
            this.auditTrailService.generic("admin-code-env-update").with("envLang", envLang.name()).with("envName", envName).with("pluginId", pluginId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-code-env-update", (Throwable)e).with("pluginId", pluginId).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "admin-code-env-export", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/design/export"})
    public void designExportEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUserNoXSRF(req);
        }
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        try (AutoDelete exportDir = DSSTempUtils.getTempFolder((String)"codeenv-export", (String)envName);){
            this.designNodeEnvsService.exportEnvDefStandalone(el, envName, (File)exportDir);
            resp.setContentType("application/zip");
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + envName + ".zip\"");
            resp.setStatus(200);
            ZipUnzipDir.zipDirectoryToStream((File)exportDir, new BufferedOutputStream((OutputStream)resp.getOutputStream()));
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Export failed", (Throwable)e);
            resp.setStatus(404);
            resp.getWriter().write("Code env not found");
        }
    }

    @AuditedCall(value={"msgType", "admin-code-env-export", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/design/download-diagnostic"})
    public void designDiagEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName) throws IOException, DKUSecurityException {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
        }
        try (AutoDelete exportDir = DSSTempUtils.getTempFolder((String)"codeenv-diag", (String)envName);){
            this.designNodeEnvsService.exportEnvDefStandalone(el, envName, (File)exportDir);
            HashMap exported = Maps.newHashMap();
            exported.put("desc/", new File((File)exportDir, el.getFolderName()));
            exported.put("log/", this.designNodeEnvsService.getEnvLogsDir(el, envName));
            resp.setContentType("application/zip");
            resp.setHeader("Content-Disposition", "attachment; filename=\"dss_" + envName + "_diag.zip\"");
            resp.setStatus(200);
            ZipUnzipDir.zipDirectoriesToStream(exported, new BufferedOutputStream((OutputStream)resp.getOutputStream()), null);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Export failed", (Throwable)e);
            resp.setStatus(404);
            resp.getWriter().write("Code env not found");
        }
    }

    @AuditedCall(value={"msgType", "admin-code-env-import", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/design/import"})
    public void designImportEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (!authCtx.getPermissions().mayCreateCodeEnvs()) {
                throw new SecurityException("You may not create new code envs");
            }
        }
        logger.info((Object)("Uploading new code env from file " + filePart.getOriginalFilename()));
        try (AutoDelete importDir = CodeEnvImportUtils.getTempImportFolder(filePart.getOriginalFilename());){
            File importZip = new File((File)importDir, filePart.getOriginalFilename());
            FileUtils.copyInputStreamToFile((InputStream)filePart.getInputStream(), (File)importZip);
            logger.info((Object)"Code env received, installing it");
            CodeEnvModel.CodeEnvUpdateSettings updateSettings = new CodeEnvModel.CodeEnvUpdateSettings();
            updateSettings.updateResources = false;
            CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.designNodeEnvsService.startImportEnvDefStandalone(authCtx, authCtx.getIdentifier(), importZip, updateSettings));
        }
    }

    @AuditedCall(value={"msgType", "admin-code-env-import", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/automation/import"})
    public void automationImportEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (!authCtx.getPermissions().mayCreateCodeEnvs()) {
                throw new SecurityException("You may not create new code envs");
            }
        }
        logger.info((Object)("Uploading new code env from file " + filePart.getOriginalFilename()));
        try (AutoDelete importDir = CodeEnvImportUtils.getTempImportFolder(filePart.getName());){
            File importZip = new File((File)importDir, filePart.getOriginalFilename());
            FileUtils.copyInputStreamToFile((InputStream)filePart.getInputStream(), (File)importZip);
            logger.info((Object)"Code env received, installing it");
            CodeEnvModel.CodeEnvUpdateSettings updateSettings = new CodeEnvModel.CodeEnvUpdateSettings();
            updateSettings.updateResources = false;
            CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.automationNodeEnvsService.startImportEnvDefStandalone(authCtx, authCtx.getIdentifier(), importZip, updateSettings));
        }
    }

    @AuditedCall(value={"msgType", "admin-code-env-import", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/automation/import-version"})
    public void automationImportEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        DSSAuthCtx authCtx;
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (!authCtx.getPermissions().mayCreateCodeEnvs()) {
                throw new SecurityException("You may not create new code envs");
            }
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
        }
        logger.info((Object)("Uploading new code env version from file " + filePart.getOriginalFilename() + " into " + envName));
        try (AutoDelete importDir = CodeEnvImportUtils.getTempImportFolder(filePart.getName());){
            File importZip = new File((File)importDir, filePart.getOriginalFilename());
            FileUtils.copyInputStreamToFile((InputStream)filePart.getInputStream(), (File)importZip);
            logger.info((Object)"Code env received, installing it");
            CodeEnvModel.CodeEnvUpdateSettings updateSettings = new CodeEnvModel.CodeEnvUpdateSettings();
            updateSettings.updateResources = false;
            CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, this.automationNodeEnvsService.startImportEnvVersion(authCtx, authCtx.getIdentifier(), importZip, el, envName, updateSettings));
        }
    }

    @AuditedCall(value={"msgType", "admin-code-env-browse-resources", "envLang", "${envLang}", "envName", "${envName}", "relativePath", "${relativePath}", "withDirectoriesSize", "${withDirectoriesSize}"})
    @RequestMapping(value={"/api/code-envs/design/browse-resources"})
    public void browseResourcesDesign(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam String relativePath, @RequestParam boolean withDirectoriesSize) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.USE);
            CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, (Object)this.designNodeEnvsService.browseResourcesDir(el, envName, relativePath, withDirectoriesSize));
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/code-envs/automation/browse-resources"})
    public void browseResourcesAutomation(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam(required=false) String versionId, @RequestParam String relativePath, @RequestParam boolean withDirectoriesSize) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.USE);
            CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, (Object)this.automationNodeEnvsService.browseResourcesDir(el, envName, versionId, relativePath, withDirectoriesSize));
            if (StringUtils.isBlank((String)versionId)) {
                this.auditTrailService.generic("admin-code-env-browse-resources").with("envLang", envLang).with("envName", envName).with("relativePath", relativePath).with("withDirectoriesSize", withDirectoriesSize).emit();
            } else {
                this.auditTrailService.generic("admin-code-env-browse-resources").with("envLang", envLang).with("envName", envName).with("versionId", versionId).with("relativePath", relativePath).with("withDirectoriesSize", withDirectoriesSize).emit();
            }
        }
        catch (Exception e) {
            if (StringUtils.isBlank((String)versionId)) {
                this.auditTrailService.failure("admin-code-env-browse-resources", (Throwable)e).with("envLang", envLang).with("envName", envName).with("relativePath", relativePath).with("withDirectoriesSize", withDirectoriesSize).emit();
            } else {
                this.auditTrailService.failure("admin-code-env-browse-resources", (Throwable)e).with("envLang", envLang).with("envName", envName).with("versionId", versionId).with("relativePath", relativePath).with("withDirectoriesSize", withDirectoriesSize).emit();
            }
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "admin-code-env-upload-resources", "envLang", "${envLang}", "envName", "${envName}", "relativePath", "${relativePath}", "withDirectoriesSize", "${withDirectoriesSize}"})
    @RequestMapping(value={"/api/code-envs/design/upload-resources"})
    public void uploadResourcesDesign(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam String relativePath, @RequestParam(value="file") MultipartFile filePart, @RequestParam boolean overwrite) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
            CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, (Object)this.designNodeEnvsService.uploadResourcesZip(el, envName, relativePath, filePart.getInputStream(), filePart.getOriginalFilename(), overwrite));
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/code-envs/automation/upload-resources"})
    public void uploadResourcesAutomation(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam(required=false) String versionId, @RequestParam String relativePath, @RequestParam(value="file") MultipartFile filePart, @RequestParam boolean overwrite) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
            CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, (Object)this.automationNodeEnvsService.uploadResourcesZip(el, envName, versionId, relativePath, filePart.getInputStream(), filePart.getOriginalFilename(), overwrite));
            if (StringUtils.isBlank((String)versionId)) {
                this.auditTrailService.generic("admin-code-env-upload-resources").with("envLang", envLang).with("envName", envName).with("relativePath", relativePath).with("filename", filePart.getOriginalFilename()).with("overwrite", overwrite).emit();
            } else {
                this.auditTrailService.generic("admin-code-env-upload-resources").with("envLang", envLang).with("envName", envName).with("versionId", versionId).with("relativePath", relativePath).with("filename", filePart.getOriginalFilename()).with("overwrite", overwrite).emit();
            }
        }
        catch (Exception e) {
            if (StringUtils.isBlank((String)versionId)) {
                this.auditTrailService.failure("admin-code-env-upload-resources", (Throwable)e).with("envLang", envLang).with("envName", envName).with("relativePath", relativePath).with("filename", filePart.getOriginalFilename()).with("overwrite", overwrite).emit();
            } else {
                this.auditTrailService.failure("admin-code-env-upload-resources", (Throwable)e).with("envLang", envLang).with("envName", envName).with("versionId", versionId).with("relativePath", relativePath).with("filename", filePart.getOriginalFilename()).with("overwrite", overwrite).emit();
            }
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "admin-code-env-clear-resources", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/design/clear-resources"})
    public void clearResourcesDesign(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
            this.designNodeEnvsService.clearResourcesDir(el, envName);
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/code-envs/automation/clear-resources"})
    public void clearResourcesAutomation(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam(required=false) String versionId) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
            this.automationNodeEnvsService.clearResourcesDir(el, envName, versionId);
            if (StringUtils.isBlank((String)versionId)) {
                this.auditTrailService.generic("admin-code-env-clear-resources").with("envLang", envLang).with("envName", envName).emit();
            } else {
                this.auditTrailService.generic("admin-code-env-clear-resources").with("envLang", envLang).with("envName", envName).with("versionId", versionId).emit();
            }
        }
        catch (Exception e) {
            if (StringUtils.isBlank((String)versionId)) {
                this.auditTrailService.failure("admin-code-env-clear-resources", (Throwable)e).with("envLang", envLang).with("envName", envName).emit();
            } else {
                this.auditTrailService.failure("admin-code-env-clear-resources", (Throwable)e).with("envLang", envLang).with("envName", envName).with("versionId", versionId).emit();
            }
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "admin-code-env-get-resources-env-vars", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/api/code-envs/design/resources-env-vars"})
    public void getResourcesEnvVarsDesign(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.USE);
            CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, (Object)this.designNodeEnvsService.getResourcesEnvVars(el, envName));
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/code-envs/automation/resources-env-vars"})
    public void getResourcesEnvVarsAutomation(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String envName, @RequestParam(required=false) String versionId) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.USE);
            CodeEnvsAdminController.writeJSON((HttpServletResponse)resp, (Object)this.automationNodeEnvsService.getResourcesEnvVars(el, envName, versionId));
            if (StringUtils.isBlank((String)versionId)) {
                this.auditTrailService.generic("admin-code-env-get-resources-env-vars").with("envLang", envLang).with("envName", envName).emit();
            } else {
                this.auditTrailService.generic("admin-code-env-get-resources-env-vars").with("envLang", envLang).with("envName", envName).with("versionId", versionId).emit();
            }
        }
        catch (Exception e) {
            if (StringUtils.isBlank((String)versionId)) {
                this.auditTrailService.failure("admin-code-env-get-resources-env-vars", (Throwable)e).with("envLang", envLang).with("envName", envName).emit();
            } else {
                this.auditTrailService.failure("admin-code-env-get-resources-env-vars", (Throwable)e).with("envLang", envLang).with("envName", envName).with("versionId", versionId).emit();
            }
            throw e;
        }
    }
}

