/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.export.DataLineageExportService;
import com.dataiku.dip.dataflow.export.model.FlowExport;
import com.dataiku.dip.dataflow.export.model.FlowExportFormat;
import com.dataiku.dip.datalineage.ColumnRelation;
import com.dataiku.dip.datalineage.ManualDataLineage;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.graphicsexport.model.ExportResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.DataLineageService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.j2ts.annotations.UIModel;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DataLineageController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DataLineageService dataLineageService;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private DataLineageExportService dataLineageExportService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;

    @AuditedCall(value={"msgType", "save-manual-relations", "projectKey", "${projectKey}", "recipeName", "${recipeName}", "ignoreAutoComputedLineage", "${ignoreAutoComputedLineage}"})
    @RequestMapping(value={"/api/data-lineage/save-manual-relations"}, method={RequestMethod.POST})
    public void saveManualRelations(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeName, @RequestParam(name="manualDataLineages") Map<String, ManualDataLineage> manualDataLineages, @RequestParam boolean ignoreAutoComputedLineage) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            boolean updated = this.dataLineageService.updateManualColumnRelations(authCtx, projectKey, manualDataLineages, ignoreAutoComputedLineage, recipeName);
            if (updated) {
                t.commit("Saved manual data lineage");
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to save manual data lineage");
            throw e;
        }
        DataLineageController.writeJSON((HttpServletResponse)resp, (Object)true);
    }

    @AuditedCall(value={"msgType", "get-full-data-lineage", "projectKey", "${projectKey}", "recipeName", "${recipeName}", "datasetNames", "${datasetNames}"})
    @RequestMapping(value={"/api/data-lineage/get-full-data-lineage"}, method={RequestMethod.GET})
    @ResponseBody
    public FullDataLineage getFullDataLineage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeName, @RequestParam List<String> datasetNames) throws Exception {
        boolean ignoreAutoComputedLineage;
        Set<ColumnRelation> autoComputedRelations;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            ProjectFlowGraph projectFlowGraph = this.flowGraphService.getProjectGraphUnsafe(projectKey);
            DataLineageService.RecipeColumnRelations recipeColumnRelations = this.dataLineageService.getRecipeAutoComputedRelations(projectFlowGraph.getRecipe(projectKey, recipeName), authCtx, true);
            autoComputedRelations = recipeColumnRelations.columnRelations;
            ignoreAutoComputedLineage = recipeColumnRelations.ignoreAutoComputed;
        }
        HashMap<String, ManualDataLineage> manualDataLineages = new HashMap<String, ManualDataLineage>();
        for (String datasetName : datasetNames) {
            ManualDataLineage manualDataLineage = new ManualDataLineage();
            manualDataLineage.columnRelationsPatch.addAll(this.dataLineageService.getManualColumnRelation_NT((String)projectKey, (String)datasetName).columnRelationsPatch);
            manualDataLineages.put(datasetName, manualDataLineage);
        }
        return new FullDataLineage(autoComputedRelations, manualDataLineages, ignoreAutoComputedLineage);
    }

    @AuditedCall(value={"msgType", "export-data-lineage", "projectKey", "${contextProjectKey}", "datasetName", "${smartName}", "columnName", "${columnName}", "exportFormat", "${exportFormat}"})
    @RequestMapping(value={"/api/data-lineage/export"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<ExportResult> exportDataLineage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String smartName, @RequestParam String columnName, @RequestParam FlowExportFormat exportFormat) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, contextProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        FlowExport export = new FlowExport(contextProjectKey, exportFormat, smartName, columnName);
        return this.dataLineageExportService.export(user, export);
    }

    @AuditedCall(value={"msgType", "data-lineage-download-export", "projectKey", "${projectKey}", "exportId", "${exportId}"})
    @RequestMapping(value={"/api/data-lineage/download-export"}, method={RequestMethod.GET})
    public void downloadExport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String exportId) throws Exception {
        File file;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            file = this.dataLineageExportService.getExportFile(user, projectKey, exportId);
        }
        this.auditTrailService.generic("data-lineage-flow-export-download").with("ProjectKey", projectKey).with("ExportId", exportId).emit();
        String mimeType = DKUtils.probeContentTypeWithFallback((File)file);
        this.writeFileForDownload(resp, file, mimeType, file.getName());
        this.dataLineageExportService.clean(projectKey, exportId);
    }

    @AuditedCall(value={"msgType", "data-lineage-send-mail-data-stewards"})
    @RequestMapping(value={"/api/data-lineage/send-data-stewards-mail"}, method={RequestMethod.POST})
    public void sendDataStewardsMail(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String datasetSmartName, @RequestParam String column, @RequestParam List<String> userRecipients, @RequestParam DataLineageService.DataStewardLocation direction, @Nullable String message, @RequestParam(required=false, defaultValue="false") boolean includeHiddenDataStewards) throws Exception {
        GeneralSettingsDAO.GeneralSettings gs;
        AuthCtx authCtx;
        DatasetLocUtils.DatasetLoc datasetLoc = DatasetLocUtils.resolveSmart(contextProjectKey, datasetSmartName);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoDatasetReadUseAccess(authCtx, datasetLoc, contextProjectKey);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        }
        if (StringUtils.isBlank((String)gs.notifications.emailChannelId)) {
            logger.warn((Object)"Email channel is disabled or not configured, no email was sent");
            DataLineageController.sendErrorExplicit((int)422, (String)"NoNotificationChannel", (String)"Could not send any mail as notification channel is not set, ask your administrator to set one.", (HttpServletResponse)resp);
            return;
        }
        DataLineageService.SendDataStewardsNotificationEmailParams params = new DataLineageService.SendDataStewardsNotificationEmailParams();
        params.contextProjectKey = contextProjectKey;
        params.datasetSmartName = datasetSmartName;
        params.includeHiddenDataStewards = includeHiddenDataStewards;
        params.direction = direction;
        params.column = column;
        params.message = message;
        params.userRecipients = userRecipients;
        DataLineageService.EmailStatus emailStatus = this.dataLineageService.sendDataStewardColumnChangeNotification_NT(authCtx, params);
        DataLineageController.writeJSON((HttpServletResponse)resp, (Object)emailStatus);
    }

    @AuditedCall(value={"msgType", "data-lineage-get-data-stewards-lineage", "contextProjectKey", "${contextProjectKey}", "smartName", "${smartName}", "column", "${column}"})
    @RequestMapping(value={"/api/data-lineage/get-data-stewards-lineage"})
    public void getDataStewardLineage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String smartName, @RequestParam String column) throws Exception {
        AuthCtx authCtx;
        DatasetLocUtils.DatasetLoc datasetLoc = DatasetLocUtils.resolveSmart(contextProjectKey, smartName);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoDatasetReadUseAccess(authCtx, datasetLoc, contextProjectKey);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
        }
        Map<String, DataLineageService.DataStewardLineageInfo> dataStewardsInfo = this.dataLineageService.getDataStewardsInLineage_NT(authCtx, contextProjectKey, datasetLoc.getProjectKey(), datasetLoc.getName(), column);
        DataLineageService.DataStewardsLineageDTO dto = new DataLineageService.DataStewardsLineageDTO();
        dto.visibleDatastewards = dataStewardsInfo.values().stream().filter(dsInfo -> !dsInfo.ownedUpstreamDatasets.isEmpty() || !dsInfo.ownedDownstreamDatasets.isEmpty()).map(dsInfo -> {
            DataLineageService.DataStewardLineageDTO datastewardLineageDTO = new DataLineageService.DataStewardLineageDTO();
            datastewardLineageDTO.displayedName = dsInfo.displayedName;
            datastewardLineageDTO.login = dsInfo.login;
            datastewardLineageDTO.email = dsInfo.email;
            datastewardLineageDTO.isDeleted = dsInfo.isDeleted;
            datastewardLineageDTO.ownedUpstreamDatasets = dsInfo.ownedUpstreamDatasets;
            datastewardLineageDTO.ownedDownstreamDatasets = dsInfo.ownedDownstreamDatasets;
            return datastewardLineageDTO;
        }).collect(Collectors.toList());
        dto.hiddenDatastewardsUpstreamCount = (int)dataStewardsInfo.values().stream().filter(DataLineageService.DataStewardLineageInfo::isHiddenUpstreamDataSteward).count();
        dto.hiddenDatastewardsDownstreamCount = (int)dataStewardsInfo.values().stream().filter(DataLineageService.DataStewardLineageInfo::isHiddenDownstreamDataSteward).count();
        dto.hiddenDatastewardsBothCount = (int)dataStewardsInfo.values().stream().filter(DataLineageService.DataStewardLineageInfo::isHiddenDataSteward).count();
        DataLineageController.writeJSON((HttpServletResponse)resp, (Object)dto);
    }

    @UIModel
    public static class FullDataLineage {
        public Set<ColumnRelation> autoComputedDataLineage;
        public Map<String, ManualDataLineage> manualDataLineages;
        public boolean ignoreAutoComputedLineage;

        public FullDataLineage(Set<ColumnRelation> autoComputedRelations, Map<String, ManualDataLineage> manualDataLineages, boolean ignoreAutoComputedLineage) {
            this.autoComputedDataLineage = autoComputedRelations;
            this.manualDataLineages = manualDataLineages;
            this.ignoreAutoComputedLineage = ignoreAutoComputedLineage;
        }
    }
}

