/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.admin;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.plugins.dev.FolderEditorService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.MimeTypesSecurity;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionProvider;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.DSSTransactionProviderSettings;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class AdminEditionController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private FolderEditorService folderEditorService;
    @Autowired
    private IPermissionsService permissionsService;
    private TransactionProvider libPythonTransactionProvider;
    private TransactionProvider libRTransactionProvider;
    private TransactionProvider localStaticTransactionProvider;
    private static final Logger logger = Logger.getLogger((String)"dku.admin.edit");

    @PostConstruct
    public void setupGit() throws IOException {
        logger.debug((Object)"Init adminedit service");
        File libR = ApplicationConfigurator.getFile((String[])new String[]{"lib", "R"});
        DKUFileUtils.mkdirs((File)libR);
        this.libRTransactionProvider = new TransactionProvider(libR, (TransactionProvider.TransactionProviderSettings)new DSSTransactionProviderSettings(false, true, true, true));
        File libPython = ApplicationConfigurator.getFile((String[])new String[]{"lib", "python"});
        DKUFileUtils.mkdirs((File)libPython);
        this.libPythonTransactionProvider = new TransactionProvider(libPython, (TransactionProvider.TransactionProviderSettings)new DSSTransactionProviderSettings(false, true, true, true));
        File localStatic = ApplicationConfigurator.getFile((String[])new String[]{"local", "static"});
        DKUFileUtils.mkdirs((File)localStatic);
        this.localStaticTransactionProvider = new TransactionProvider(localStatic, (TransactionProvider.TransactionProviderSettings)new DSSTransactionProviderSettings(false, true, true, true));
        logger.debug((Object)"Done init adminedit service");
    }

    private AuthCtx getAndCheckEditorUser_NT(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckEditorUser(req);
            return authCtx;
        }
    }

    private AuthCtx getAndCheckEditorUser(HttpServletRequest req) throws Exception {
        AuthCtx authCtx = this.authService.getMandatoryUser(req);
        this.permissionsService.checkEditLibFoldersPrivilege(authCtx);
        return authCtx;
    }

    private TransactionProvider getTransactionProvider(GlobalCodeZone zone) {
        switch (zone) {
            case LIB_R: {
                return this.libRTransactionProvider;
            }
            case LIB_PYTHON: {
                return this.libPythonTransactionProvider;
            }
            case LOCAL_STATIC: {
                return this.localStaticTransactionProvider;
            }
        }
        throw new NotImplementedException("Zone for dev files " + String.valueOf((Object)zone) + " is not known");
    }

    @AuditedCall(value={"msgType", "admin-folder-edit-list", "folderType", "${type}"})
    @RequestMapping(value={"/api/admin/folder-edition/list-contents"})
    public void listContents(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type) throws Exception {
        this.getAndCheckEditorUser_NT(req);
        GlobalCodeZone zone = GlobalCodeZone.valueOf(type);
        try (Transaction t = this.getTransactionProvider(zone).beginRead();){
            AdminEditionController.writeJSON((HttpServletResponse)resp, this.folderEditorService.getFolderContent(RelFile.root(), (TransactionRef)t));
        }
    }

    @AuditedCall(value={"msgType", "admin-folder-edit-get", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/admin/folder-edition/get-content"})
    public void getContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String path, @RequestParam boolean sendAnyway) throws Exception {
        this.getAndCheckEditorUser_NT(req);
        GlobalCodeZone zone = GlobalCodeZone.valueOf(type);
        try (Transaction t = this.getTransactionProvider(zone).beginRead();){
            AdminEditionController.writeJSON((HttpServletResponse)resp, (Object)this.folderEditorService.getFolderContent(RelFile.root(), path, sendAnyway, null, t));
        }
    }

    @AuditedCall(value={"msgType", "admin-folder-edit-preview-image", "folderType", "${type}", "path", "${path}", "contentType", "${contentType}"})
    @RequestMapping(value={"/api/admin/folder-edition/preview-image"}, method={RequestMethod.GET})
    public void previewImage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String path, @RequestParam String contentType) throws Exception {
        byte[] picData;
        MimeTypesSecurity.failIfNotSafeImageType((String)contentType);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkEditLibFoldersPrivilege(authCtx);
        }
        GlobalCodeZone zone = GlobalCodeZone.valueOf(type);
        try (Transaction t = this.getTransactionProvider(zone).beginRead();){
            picData = this.folderEditorService.previewImageStream(RelFile.root(), path, t);
        }
        resp.setContentType(contentType);
        resp.getOutputStream().write(picData);
    }

    @AuditedCall(value={"msgType", "admin-folder-edit-save", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/admin/folder-edition/set-content"})
    public void setContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String path, @RequestParam String data) throws Exception {
        AuthCtx authCtx = this.getAndCheckEditorUser_NT(req);
        GlobalCodeZone zone = GlobalCodeZone.valueOf(type);
        try (RWTransaction t = this.getTransactionProvider(zone).beginWrite(authCtx);){
            this.folderEditorService.setFolderContent(RelFile.root(), path, data, (RWTransactionRef)t);
            t.commit("edit file");
        }
    }

    @AuditedCall(value={"msgType", "admin-folder-edit-save", "folderType", "${type}"})
    @RequestMapping(value={"/api/admin/folder-edition/set-content-multiple"})
    public void setContentMultiple(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String contentMap) throws Exception {
        AuthCtx authCtx = this.getAndCheckEditorUser_NT(req);
        GlobalCodeZone zone = GlobalCodeZone.valueOf(type);
        Map fileMap = (Map)JSON.parse((String)contentMap, (TypeToken)new TypeToken<Map<String, String>>(){});
        try (RWTransaction t = this.getTransactionProvider(zone).beginWrite(authCtx);){
            this.folderEditorService.setFolderContentList(RelFile.root(), fileMap, t);
            t.commit("edit files");
        }
    }

    @AuditedCall(value={"msgType", "admin-folder-edit-create", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/admin/folder-edition/create-content"})
    public void createContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String path, @RequestParam boolean isFolder) throws Exception {
        AuthCtx authCtx = this.getAndCheckEditorUser_NT(req);
        GlobalCodeZone zone = GlobalCodeZone.valueOf(type);
        try (RWTransaction t = this.getTransactionProvider(zone).beginWrite(authCtx);){
            this.folderEditorService.addFolderContent(RelFile.root(), path, isFolder, (RWTransactionRef)t);
            t.commit("create file");
        }
    }

    @AuditedCall(value={"msgType", "admin-folder-edit-delete", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/admin/folder-edition/delete-content"})
    public void deleteContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String path) throws Exception {
        AuthCtx authCtx = this.getAndCheckEditorUser_NT(req);
        GlobalCodeZone zone = GlobalCodeZone.valueOf(type);
        try (RWTransaction t = this.getTransactionProvider(zone).beginWrite(authCtx);){
            this.folderEditorService.removeFolderContent(RelFile.root(), path, t);
            t.commit("edit file/folder");
        }
    }

    @AuditedCall(value={"msgType", "admin-folder-edit-save", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/admin/folder-edition/decompress-content"})
    public void decompressContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String path) throws Exception {
        AuthCtx authCtx = this.getAndCheckEditorUser_NT(req);
        GlobalCodeZone zone = GlobalCodeZone.valueOf(type);
        try (RWTransaction t = this.getTransactionProvider(zone).beginWrite(authCtx);){
            this.folderEditorService.decompressFolderContent(RelFile.root(), path, t);
            t.commit("decompress file");
        }
    }

    @AuditedCall(value={"msgType", "admin-folder-edit-save", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/admin/folder-edition/rename-content"})
    public void renameContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String path, @RequestParam String newName) throws Exception {
        AuthCtx authCtx = this.getAndCheckEditorUser_NT(req);
        GlobalCodeZone zone = GlobalCodeZone.valueOf(type);
        try (RWTransaction t = this.getTransactionProvider(zone).beginWrite(authCtx);){
            FolderEditorService.FolderContent newContent = this.folderEditorService.renameFolderContent(RelFile.root(), path, newName, t);
            AdminEditionController.writeJSON((HttpServletResponse)resp, (Object)newContent);
            t.commit("rename file/folder");
        }
    }

    @AuditedCall(value={"msgType", "admin-folder-edit-save", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/admin/folder-edition/move-content"})
    public void moveContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String path, @RequestParam String toPath) throws Exception {
        AuthCtx authCtx = this.getAndCheckEditorUser_NT(req);
        GlobalCodeZone zone = GlobalCodeZone.valueOf(type);
        try (RWTransaction t = this.getTransactionProvider(zone).beginWrite(authCtx);){
            FolderEditorService.FolderContent newContent = this.folderEditorService.moveFolderContent(RelFile.root(), path, toPath, t);
            AdminEditionController.writeJSON((HttpServletResponse)resp, (Object)newContent);
            t.commit("move file/folder");
        }
    }

    @AuditedCall(value={"msgType", "admin-folder-edit-save", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/admin/folder-edition/copy-content"})
    public void copyContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String path) throws Exception {
        AuthCtx authCtx = this.getAndCheckEditorUser_NT(req);
        GlobalCodeZone zone = GlobalCodeZone.valueOf(type);
        try (RWTransaction t = this.getTransactionProvider(zone).beginWrite(authCtx);){
            FolderEditorService.FolderContent newContent = this.folderEditorService.copyFolderContent(RelFile.root(), path, t);
            AdminEditionController.writeJSON((HttpServletResponse)resp, (Object)newContent);
            t.commit("copy file/folder");
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/admin/folder-edition/check-upload-content"})
    public void checkUploadContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String path, @RequestParam(value="filePaths") String filePathsData) throws Exception {
        this.getAndCheckEditorUser_NT(req);
        List filePaths = (List)JSON.parse((String)filePathsData, (TypeToken)new TypeToken<List<String>>(){});
        GlobalCodeZone zone = GlobalCodeZone.valueOf(type);
        try (Transaction t = this.getTransactionProvider(zone).beginRead();){
            AdminEditionController.writeJSON((HttpServletResponse)resp, (Object)this.folderEditorService.checkUploadContent(RelFile.root(), path, filePaths, t));
        }
    }

    @AuditedCall(value={"msgType", "admin-folder-edit-upload", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/admin/folder-edition/upload-content"})
    public void uploadContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String path, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        GlobalCodeZone zone;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkEditLibFoldersPrivilege(authCtx);
            zone = GlobalCodeZone.valueOf(type);
        }
        t = this.getTransactionProvider(zone).beginWrite(authCtx);
        try {
            Callable<FolderEditorService.FolderContent> callableUploadHandler = this.folderEditorService.uploadContent(RelFile.root(), path, filePart.getInputStream(), filePart.getOriginalFilename(), (RWTransaction)t);
            FolderEditorService.FolderContent newContent = callableUploadHandler.call();
            t.commit("upload file");
            AdminEditionController.writeJSON((HttpServletResponse)resp, (Object)newContent);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "admin-folder-edit-download", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/admin/folder-edition/download-content"}, method={RequestMethod.GET})
    public void downloadContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String path) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkEditLibFoldersPrivilege(authCtx);
        }
        GlobalCodeZone zone = GlobalCodeZone.valueOf(type);
        try (Transaction t = this.getTransactionProvider(zone).beginRead();){
            this.folderEditorService.streamContent(RelFile.root(), path, resp, t);
        }
    }

    public static final class GlobalCodeZone
    extends Enum<GlobalCodeZone> {
        public static final /* enum */ GlobalCodeZone LIB_R = new GlobalCodeZone("lib", "R");
        public static final /* enum */ GlobalCodeZone LIB_PYTHON = new GlobalCodeZone("lib", "python");
        public static final /* enum */ GlobalCodeZone LIB = new GlobalCodeZone("lib");
        public static final /* enum */ GlobalCodeZone LOCAL_STATIC = new GlobalCodeZone("local", "static");
        private final String[] elements;
        private static final /* synthetic */ GlobalCodeZone[] $VALUES;

        public static GlobalCodeZone[] values() {
            return (GlobalCodeZone[])$VALUES.clone();
        }

        public static GlobalCodeZone valueOf(String name) {
            return Enum.valueOf(GlobalCodeZone.class, name);
        }

        private GlobalCodeZone(String ... elements) {
            this.elements = elements;
        }

        public File getPath() {
            File path = new File(ApplicationConfigurator.getBaseFolder());
            for (String element : this.elements) {
                path = new File(path, element);
            }
            return path;
        }

        public RelFile getPath(String projectKey) {
            assert (StringUtils.isNotBlank((String)projectKey));
            ArrayList projectElements = Lists.newArrayList((Object[])new String[]{"projects", projectKey});
            projectElements.addAll(Arrays.asList(this.elements));
            return new RelFile((List)projectElements);
        }

        public RelFile getProjectSubPath(String projectKey) {
            assert (StringUtils.isNotBlank((String)projectKey));
            ArrayList projectElements = Lists.newArrayList((Object[])new String[]{projectKey});
            return new RelFile((List)projectElements);
        }

        public String getZoneSubPath() {
            return StringUtils.join((Object[])this.elements, (String)"/");
        }

        private static /* synthetic */ GlobalCodeZone[] $values() {
            return new GlobalCodeZone[]{LIB_R, LIB_PYTHON, LIB, LOCAL_STATIC};
        }

        static {
            $VALUES = GlobalCodeZone.$values();
        }
    }
}

