/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class VariablesIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private TransactionService transactionService;

    @AuditedCall(value={"msgType", "project-resolved-variables-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/tintercom/variables/get-resolved-for-project"})
    public void getResolvedForProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(defaultValue="false") Boolean typed) throws Exception {
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            this.permissionsService.checkProjectPrivileges(authCtxUsage.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            VariablesContext context = this.variablesService.getForProject(projectKey);
            VariablesIntercomController.writeJSON((HttpServletResponse)resp, (Object)(typed != false ? context.getAllVariablesTyped() : context.getAllVariables()));
        }
    }

    @AuditedCall(value={"msgType", "project-resolved-variables-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/tintercom/variables/get-context-for-project"})
    public void getContextForProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            this.permissionsService.checkProjectPrivileges(authCtxUsage.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            VariablesContext context = this.variablesService.getForProject(projectKey);
            VariablesIntercomController.writeJSON((HttpServletResponse)resp, (Object)context);
        }
    }

    @AuditedCall(value={"msgType", "project-variables-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/tintercom/variables/get-for-project"})
    public void getResolvedForProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            this.permissionsService.checkProjectPrivileges(authCtxUsage.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            VariablesService.ProjectVariables pv = VariablesService.readLocalUnresolvedProjectVariables(projectKey, t);
            VariablesIntercomController.writeJSON((HttpServletResponse)resp, (Object)pv);
        }
    }

    @AuditedCall(value={"msgType", "project-variables-set", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/tintercom/variables/set-for-project"}, method={RequestMethod.POST})
    public void setForProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        VariablesService.ProjectVariables pv = (VariablesService.ProjectVariables)this.getRequestBodyAs(req, VariablesService.ProjectVariables.class);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkProjectPrivileges(t.getUser(), projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            VariablesService.writeLocalProjectVariables(projectKey, t, pv, true);
        }
    }
}

