/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.backend;

import com.dataiku.dip.analysis.coreservices.TrainingSessionDetailsService;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.EventWithHumanReadableString;
import com.dataiku.dip.server.notifications.backend.EventWithSeverity;
import com.dataiku.dip.server.notifications.backend.ProjectEvent;
import com.dataiku.dip.server.notifications.backend.UserEvent;

public class MLTaskStateChangedEvent
extends BackendEvent
implements UserEvent,
ProjectEvent,
EventWithSeverity,
EventWithHumanReadableString {
    public static final String NAME = "mltask-state-change";
    public final MLTask.MLTaskType taskType;
    public final String projectKey;
    public final String analysisId;
    public final String sessionId;
    public final String taskId;
    public final String name;
    public final String initiator;
    public final boolean isRunning;
    public final String type = "MLTASK";
    public final String dataset;
    public final TrainingSessionDetailsService.TrainingSessionResultSummary results;

    public MLTaskStateChangedEvent(MLTask task, String projectKey, String analysisId, String sessionId, String dataset, boolean isRunning, String initiator, TrainingSessionDetailsService.TrainingSessionResultSummary results) {
        this.taskType = task.taskType;
        this.projectKey = projectKey;
        this.analysisId = analysisId;
        this.taskId = task.id;
        this.name = task.name;
        this.initiator = initiator;
        this.isRunning = isRunning;
        this.dataset = dataset;
        this.results = results;
        this.sessionId = sessionId;
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getUserLogin() {
        return this.initiator;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String toHumanReadableString(MarkupFormatter markup) {
        String minimalStatus = this.isRunning ? "started" : "done";
        String userMsg = this.isRunning ? " by " + markup.user(this.initiator, this.initiator) : "";
        return String.format("ML task %s %s%s", markup.mlTask(this.projectKey, this.analysisId, this.taskType, this.taskId, this.name), minimalStatus, userMsg);
    }

    @Override
    public EventWithSeverity.EventSeverity getSeverity() {
        if (this.isRunning) {
            return EventWithSeverity.EventSeverity.NEUTRAL;
        }
        return EventWithSeverity.EventSeverity.OK;
    }
}

