/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.EmailNotificationsSender;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.notifications.emails.MessageContentBuilder;
import com.dataiku.dip.server.notifications.emails.TemplatedContent;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class InstanceAccessGrantedEmailBuilder {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersService usersService;
    private GeneralSettingsDAO.GeneralSettings settings;
    protected static final Logger logger = Logger.getLogger((String)"dku.notifications.instance-access-granted-email-builder");

    public InstanceAccessGrantedEmailBuilder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    protected String makeSubject() {
        String productLongName = this.settings.whiteLabeling != null ? this.settings.whiteLabeling.productLongName : new GeneralSettingsDAO.WhiteLabelingSettings().productLongName;
        return "You have been granted access to a " + productLongName + "  instance";
    }

    protected String makeBody() throws IOException, TemplateException {
        File templateFile = ApplicationConfigurator.getResourceFile((String[])new String[]{"notifications", "generic-request-approved-email-with-instance-link.ftl"});
        VariableLookup lookup = new VariableLookup();
        lookup.addVariable("studioExternalUrl", StringUtils.isBlank((String)this.settings.studioExternalUrl) ? null : this.settings.studioExternalUrl);
        lookup.addVariable("emailPreferencesLink", this.settings.studioExternalUrl + "/profile/");
        lookup.addVariable("title", "Instance access");
        lookup.addVariable("mainText", this.makeSubject());
        MessageContentBuilder.ExpandedTemplate expandedTemplate = new MessageContentBuilder(lookup).buildMessage(new TemplatedContent(), templateFile);
        return expandedTemplate.message;
    }

    public void sendToUser(String user) throws Exception {
        PublicUser dstUser;
        try (Transaction ignored = this.transactionService.beginRead();){
            dstUser = this.usersService.getPublicUser(user);
            if (StringUtils.isBlank((String)dstUser.email)) {
                return;
            }
            this.settings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        }
        UserSettingsService.EmailNotificationsSettings params = new UserSettingsService.EmailNotificationsSettings();
        params.enabled = true;
        params.subject = "Dataiku \u2022 " + this.makeSubject();
        EmailNotificationsSender sender = new EmailNotificationsSender();
        logger.info((Object)("Sending email to " + dstUser.login));
        sender.sendToUser(dstUser.email, params, this.makeBody());
    }
}

