/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.PermissionsWatcher;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.notifications.EmailNotificationsSender;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.notifications.emails.AbstractInviteEmailSendService;
import com.dataiku.dip.server.notifications.emails.MessageContentBuilder;
import com.dataiku.dip.server.notifications.emails.TemplatedContent;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dss.shadelib.com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectGrantEmailSendService {
    @Autowired
    private UsersService usersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private UserSettingsService userSettingsService;
    private static final Logger logger = Logger.getLogger((String)"dku.notifications.access.granted");

    @PostConstruct
    public void init() {
        logger.debug((Object)"Init project grants mail service");
        this.pubSubService.subscribe("project-permissions-changed", evt -> {
            Map<String, UserSettingsService.UserSettings> usersSettings;
            Set<String> users = evt.diff.getUsers();
            try (Transaction ignored = this.transactionService.beginRead();){
                usersSettings = this.userSettingsService.getForUsers(users);
            }
            Multimap<String, PermissionsWatcher.ProjectPermissionChange> changesPerUser = evt.diff.getChangesPerUser();
            Multimap<String, PermissionsWatcher.ProjectPermissionChange> pendingUserEmailChangesPerEmail = evt.diff.getPendingUserEmailChangesPerEmail();
            for (Map.Entry<String, UserSettingsService.UserSettings> userSettings : usersSettings.entrySet()) {
                String login = userSettings.getKey();
                if (StringUtils.equals((String)login, (String)evt.getTriggeringUser()) || !userSettings.getValue().grantedAccessEmails.enabled) continue;
                try {
                    this.sendToUser(login, changesPerUser, pendingUserEmailChangesPerEmail);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to send mail to " + login + " for grants"));
                }
            }
        });
        logger.debug((Object)"Done init project grants mail service");
    }

    private void sendToUser(String user, Multimap<String, PermissionsWatcher.ProjectPermissionChange> changesPerUser, Multimap<String, PermissionsWatcher.ProjectPermissionChange> pendingUserEmailChangesPerEmail) throws Exception {
        PublicUser publicUser;
        try (Transaction ignored = this.transactionService.beginRead();){
            publicUser = this.usersService.getPublicUser(user);
        }
        if (StringUtils.isBlank((String)publicUser.email)) {
            logger.debug((Object)("User " + user + " has no email address, not sending"));
            return;
        }
        ArrayList<String> projects = new ArrayList<String>();
        Collection pendingUserEmailChanges = pendingUserEmailChangesPerEmail.get((Object)publicUser.email.toLowerCase(Locale.ROOT));
        for (PermissionsWatcher.ProjectPermissionChange pn : changesPerUser.get((Object)publicUser.login)) {
            if (!PermissionsService.permissionChangeAddsGrant(pn, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS) || this.isConvertedFromPendingEmailPermission(pendingUserEmailChanges, pn.projectKey) || AbstractInviteEmailSendService.InvitationEmailStatus.SENT.equals((Object)pn.after.invitationEmailStatus)) continue;
            projects.add(pn.projectKey);
        }
        UserSettingsService.EmailNotificationsSettings params = new UserSettingsService.EmailNotificationsSettings();
        params.enabled = true;
        params.subject = "Dataiku \u2022 You have been granted access to projects";
        if (!projects.isEmpty()) {
            logger.info((Object)("Sending grant email to " + user));
            String body = this.makeBody(projects);
            EmailNotificationsSender sender = new EmailNotificationsSender();
            sender.sendToUser(publicUser.email, params, body);
        }
    }

    private boolean isConvertedFromPendingEmailPermission(Collection<PermissionsWatcher.ProjectPermissionChange> pendingUserEmailChanges, String projectKey) {
        return pendingUserEmailChanges.stream().anyMatch(change -> change.projectKey.equals(projectKey) && PermissionsService.permissionChangeRemovesGrant(change, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS));
    }

    private String makeBody(List<String> projects) throws Exception {
        VariableLookup lookup = new VariableLookup();
        ArrayList projectList = new ArrayList();
        try (Transaction ignored = this.transactionService.beginRead();){
            GeneralSettingsDAO.GeneralSettings settings = this.generalSettingsService.read();
            lookup.addVariable("studioExternalUrl", StringUtils.isBlank((String)settings.studioExternalUrl) ? null : settings.studioExternalUrl);
            lookup.addVariable("emailPreferencesLink", settings.studioExternalUrl + "/profile/");
            HrefContext href = new HrefContext(settings.studioExternalUrl);
            for (String projectKey : projects) {
                HashMap<String, String> project = new HashMap<String, String>();
                project.put("name", this.projectsService.getMandatory((String)projectKey).name);
                project.put("link", href.project(projectKey));
                projectList.add(project);
            }
        }
        lookup.addVariable("projectList", projectList);
        lookup.addVariable("objectType", "PROJECT");
        if (projects.size() == 1) {
            lookup.addVariable("objectLink", ((Map)projectList.get(0)).get("link"));
            lookup.addVariable("openButtonLabel", "PROJECT");
            lookup.addVariable("title", "You have been granted access to a project");
            lookup.addVariable("requestAction", "You now have access to project");
        } else {
            lookup.addVariable("title", "You have been granted access to projects");
            lookup.addVariable("requestAction", "You now have access to projects");
        }
        File templateFile = ApplicationConfigurator.getResourceFile((String[])new String[]{"notifications", "access-granted-email.ftl"});
        MessageContentBuilder.ExpandedTemplate expandedTemplate = new MessageContentBuilder(lookup).buildMessage(new TemplatedContent(), templateFile);
        return expandedTemplate.message;
    }
}

