/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import freemarker.ext.util.WrapperTemplateModel;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TemplateVariableLookup
implements TemplateHashModel {
    private Map<String, TemplateMethodModelEx> helpers = Maps.newHashMap();
    private ObjectWrapper wrapper = DefaultObjectWrapper.DEFAULT_WRAPPER;
    private VariableLookup parent;
    private static Logger logger = Logger.getLogger((String)"scenarios.reporting");

    public TemplateVariableLookup(VariableLookup parent) {
        this.parent = parent;
        this.helpers.put("getBearerOfError", new SingleParameterTemplateMethodModelEx<StepRun>("getBearerOfError", StepRun.class){

            @Override
            protected Object execSingle(StepRun stepRun) {
                ArrayList itemsToSearchInto = Lists.newArrayList();
                if (stepRun.getResult() != null) {
                    itemsToSearchInto.add(stepRun.getResult());
                }
                if (stepRun.getAdditionalReportItems() != null) {
                    itemsToSearchInto.addAll(stepRun.getAdditionalReportItems());
                }
                for (ReportItem item : itemsToSearchInto) {
                    if (item.getThrown() == null) continue;
                    return item;
                }
                return null;
            }
        });
        this.helpers.put("getBearerOfLog", new SingleParameterTemplateMethodModelEx<StepRun>("getBearerOfLog", StepRun.class){

            @Override
            protected Object execSingle(StepRun stepRun) {
                ArrayList itemsToSearchInto = Lists.newArrayList();
                if (stepRun.getResult() != null) {
                    itemsToSearchInto.add(stepRun.getResult());
                }
                if (stepRun.getAdditionalReportItems() != null) {
                    itemsToSearchInto.addAll(stepRun.getAdditionalReportItems());
                }
                for (ReportItem item : itemsToSearchInto) {
                    if (item.getLogTail() == null) continue;
                    return item;
                }
                return null;
            }
        });
    }

    public TemplateModel get(String arg0) throws TemplateModelException {
        if (this.helpers.containsKey(arg0)) {
            logger.info((Object)("LOOKUP " + arg0 + " -> helper method"));
            return (TemplateModel)this.helpers.get(arg0);
        }
        logger.info((Object)("LOOKUP " + arg0 + " -> " + String.valueOf(this.parent.rawGet(arg0))));
        return this.wrapper.wrap(this.parent.rawGet(arg0));
    }

    public boolean isEmpty() throws TemplateModelException {
        return false;
    }

    private abstract class SingleParameterTemplateMethodModelEx<T>
    implements TemplateMethodModelEx {
        private Class<? extends T> clazz;
        private String name;

        SingleParameterTemplateMethodModelEx(String name, Class<? extends T> clazz) {
            this.name = name;
            this.clazz = clazz;
        }

        protected abstract Object execSingle(T var1);

        public Object exec(List args) throws TemplateModelException {
            if (args.size() != 1) {
                throw new TemplateModelException(this.name + " takes 1 parameter");
            }
            Object arg = args.get(0);
            if (arg instanceof WrapperTemplateModel) {
                if (!this.clazz.isAssignableFrom((arg = ((WrapperTemplateModel)arg).getWrappedObject()).getClass())) {
                    throw new TemplateModelException(this.name + " takes a " + this.clazz.getName() + " object, got a wrapped " + arg.getClass().getCanonicalName());
                }
            } else if (!this.clazz.isAssignableFrom(arg.getClass())) {
                throw new TemplateModelException(this.name + " takes a " + this.clazz.getName() + " object, got a " + arg.getClass().getCanonicalName());
            }
            return this.execSingle(this.clazz.cast(arg));
        }
    }
}

