/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.twitter.TwitterDatasetHandler;
import com.dataiku.dip.datasets.twitter.TwitterStreamManager;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.DatasetLocUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TwitterConnectorsService {
    public static final RelFile configFile = RelFile.global((String)"twitter.json");
    @Autowired
    private ConnectionsDAO connectionsDAOUnused;
    @Autowired
    private SpringUtils springUtilsUnused;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    private TwitterStreamManager manager = new TwitterStreamManager();
    private static Logger logger = Logger.getLogger((String)"dip.twitter");

    @PostConstruct
    void init() throws IOException, DKUSecurityException {
        logger.debug((Object)"Init Twitter service");
        if (FeatureFlags.isEnabled((String)"NO_TWITTER")) {
            logger.info((Object)"disabled");
            return;
        }
        try (RWTransaction t = this.transactionService.beginWriteAsDSS();){
            Config config = this.getConfig();
            if (StringUtils.isNotBlank((String)config.connection)) {
                this.manager.setConnection(config.connection);
            }
            boolean added = false;
            for (String datasetFullName : config.running) {
                Dataset ds = this.getDataset(datasetFullName);
                config.running.add(datasetFullName);
                this.manager.registerDataset(ds);
                added = true;
            }
            if (added) {
                this.manager.startStreaming();
            }
            this.writeConfig(config);
        }
        logger.debug((Object)"Done init Twitter service");
    }

    private synchronized void writeConfig(Config config) {
        try {
            RWTransactionRef t = TransactionContext.retrieveWrite();
            t.writeObject(configFile, (Object)config);
        }
        catch (IOException e) {
            logger.error((Object)("Failed to write twitter config to " + String.valueOf(configFile)), (Throwable)e);
        }
    }

    public synchronized boolean isStarted(String name) {
        Config config = this.getConfig();
        return config.running.contains(name);
    }

    public Dataset getDataset(String fullName) {
        Dataset dataset;
        try {
            dataset = this.datasetAccessService.getMandatory(DatasetLocUtils.resolveFull(fullName));
        }
        catch (Exception e) {
            logger.error((Object)("Could not open dataset " + fullName), (Throwable)e);
            return null;
        }
        return dataset;
    }

    public boolean hasData(String fullName) throws Exception {
        Dataset dataset = this.getDataset(fullName);
        if (dataset == null) {
            return false;
        }
        try (DatasetHandler dh = DatasetHandlerFactory.build(DSSAuthCtx.newNone(), dataset);){
            TwitterDatasetHandler twdh = (TwitterDatasetHandler)dh;
            DatasetHandler.DatasetParams params = twdh.getRealDataset().getParams();
            ((AbstractFSDatasetHandler.AbstractFSConfig)params).notReadyIfEmpty = true;
            boolean bl = dh.getReadiness(Partition.newNP(), null).isReady();
            return bl;
        }
    }

    public synchronized void stopStreaming(String fullName) {
        if (this.isStarted(fullName)) {
            logger.info((Object)("Stop twitter streaming " + fullName));
            this.manager.stopStreaming();
            this.manager.removeDataset(fullName);
            if (this.manager.hasFilters()) {
                this.manager.startStreaming();
            }
            Config config = this.getConfig();
            config.running.remove(fullName);
            this.writeConfig(config);
        } else {
            logger.warn((Object)("Nothing to stop : " + fullName + " is not running"));
        }
    }

    public synchronized void startStreaming(String fullName) {
        if (this.isStarted(fullName)) {
            logger.error((Object)("Already streaming twitter dataset " + fullName));
            return;
        }
        Dataset dataset = this.getDataset(fullName);
        if (dataset == null) {
            return;
        }
        logger.info((Object)("Start twitter streaming " + fullName));
        if (this.manager.isStreaming()) {
            this.manager.stopStreaming();
        }
        this.manager.registerDataset(dataset);
        this.manager.startStreaming();
        Config config = this.getConfig();
        config.running.add(fullName);
        this.writeConfig(config);
    }

    public synchronized Config getConfig() {
        try {
            TransactionRef t = TransactionContext.retrieveRead();
            if (t.exists(configFile)) {
                return (Config)t.readObject(configFile, Config.class);
            }
        }
        catch (IOException e) {
            logger.error((Object)"Failed to read Twitter configuration", (Throwable)e);
        }
        return new Config();
    }

    public synchronized void setActiveConnection(String name) throws DKUSecurityException, IOException {
        Config config = this.getConfig();
        if (name == null) {
            config.connection = "";
        } else {
            config.connection = name;
            this.manager.setConnection(config.connection);
        }
        this.writeConfig(config);
    }

    public static class Config {
        public Set<String> running = new HashSet<String>();
        public String connection;
    }
}

