/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.dao.DkuUser;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WelcomeEmailService {
    @Autowired
    private UsersDAO dao;
    @Autowired
    private UsersService usersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GeneralSettingsDAO gsDAO;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.welcomeEmails");

    public void sendWelcomeEmailToUsersMissingIt(DKULogger logger) throws IOException {
        List<UsersDAO.User> users;
        GeneralSettingsDAO.GeneralSettings gs = this.gsDAO.getUnsafeAutoTXN();
        if (StringUtils.isBlank((String)gs.notifications.emailChannelId) || gs.welcomeEmailSettings == null || !gs.welcomeEmailSettings.enabled) {
            logger.info((Object)"Welcome emails or notification channel not enabled");
            return;
        }
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            users = this.dao.listUsersUnsafe();
        }
        users.forEach(user -> {
            if (!user.welcomeEmailSent && this.userLessThanWeekOldAndNotNONE(gs, (UsersDAO.User)user)) {
                logger.info((Object)("Sending Welcome Email: " + user.login));
                try {
                    this.usersService.sendWelcomeEmail((DkuUser)user);
                }
                catch (Exception e) {
                    logger.error((Object)("Error sending Welcome Email to user: " + user.login), (Throwable)e);
                }
            }
        });
    }

    private boolean userLessThanWeekOldAndNotNONE(GeneralSettingsDAO.GeneralSettings gs, UsersDAO.User user) {
        long userAccessTime;
        long now = System.currentTimeMillis();
        Pair<LicenseEnforcementService.TrialTokenStatus, String> trialStatusAndProfile = UsersService.computeTrialStatusAndResultingUserProfile(gs, user);
        LicenseEnforcementService.TrialTokenStatus tokenStatus = (LicenseEnforcementService.TrialTokenStatus)trialStatusAndProfile.first;
        if ("NONE".equals(trialStatusAndProfile.second)) {
            return false;
        }
        if (tokenStatus.exists) {
            userAccessTime = tokenStatus.grantedOn;
        } else {
            if (user.creationDate == null) {
                return false;
            }
            userAccessTime = user.creationDate;
        }
        int days = DKUDateUtils.daysBetweenLocal((long)userAccessTime, (long)now);
        return days < 7;
    }

    public int countWelcomeEmailsSent() {
        List<UsersDAO.User> users;
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            users = this.dao.listUsersUnsafe();
        }
        catch (IOException e) {
            return 0;
        }
        return (int)users.stream().filter(user -> user.welcomeEmailSent).count();
    }
}

