/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.facet;

import com.dataiku.dip.shaker.facet.AlphanumLikeFacet;
import java.util.Comparator;
import org.apache.commons.lang.ArrayUtils;

public class FacetUtils {
    public static void clip(AlphanumLikeFacet f, int newLen) {
        if (f.counts.length >= newLen) {
            return;
        }
        f.counts = ArrayUtils.subarray((int[])f.counts, (int)0, (int)newLen);
        f.values = (String[])ArrayUtils.subarray((Object[])f.values, (int)0, (int)newLen);
        f.percentages = ArrayUtils.subarray((double[])f.percentages, (int)0, (int)newLen);
        f.cumPercentages = ArrayUtils.subarray((double[])f.cumPercentages, (int)0, (int)newLen);
    }

    public static class FacetValue {
        public String key;
        public int value;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Sort implements Comparator<FacetValue>
    {
        ALPHANUM{

            @Override
            public int compare(FacetValue o1, FacetValue o2) {
                String lowerO2;
                String lowerO1 = o1.key.toLowerCase();
                int cmp = lowerO1.compareTo(lowerO2 = o2.key.toLowerCase());
                if (cmp == 0) {
                    return o1.key.compareTo(o2.key);
                }
                return cmp;
            }
        }
        ,
        COUNT_FAST{

            @Override
            public int compare(FacetValue o1, FacetValue o2) {
                return -Integer.compare(o1.value, o2.value);
            }
        }
        ,
        COUNT{

            @Override
            public int compare(FacetValue o1, FacetValue o2) {
                if (o1.value == o2.value) {
                    return ALPHANUM.compare(o1, o2);
                }
                return -Integer.compare(o1.value, o2.value);
            }
        };


        @Override
        public abstract int compare(FacetValue var1, FacetValue var2);
    }
}

