/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;

public abstract class AppliesToProcessor
extends SingleRowProcessor {
    protected Iterable<Column> columns;
    protected Pattern columnNameCompiledPattern;

    public void init() throws Exception {
        if (this.getParams().appliesTo == AppliesTo.SINGLE_COLUMN) {
            this.columns = Collections.singletonList(this.getColumnFactory().column(this.getParams().columns.get(0), Processor.ProcessorRole.INPUT_COLUMN));
            this.columnsUpdated();
        } else if (this.getParams().appliesTo == AppliesTo.COLUMNS) {
            ArrayList<Column> columnList = new ArrayList<Column>(this.getParams().columns.size());
            for (String col : this.getParams().columns) {
                columnList.add(this.getColumnFactory().column(col, Processor.ProcessorRole.INPUT_COLUMN));
            }
            this.columns = columnList;
            this.columnsUpdated();
        } else if (this.getParams().appliesTo == AppliesTo.PATTERN) {
            try {
                this.columnNameCompiledPattern = Pattern.compile(this.getParams().appliesToPattern);
            }
            catch (PatternSyntaxException ex) {
                throw new IllegalArgumentException("The pattern is invalid: " + ExceptionUtils.getMessageWithCauses((Throwable)ex), ex);
            }
        }
    }

    public void processRow(Row row) throws Exception {
        if (this.getParams().appliesTo == AppliesTo.ALL) {
            this.columns = this.getColumnFactory().columns();
            this.columnsUpdated();
        } else if (this.getParams().appliesTo == AppliesTo.PATTERN) {
            ArrayList<Column> matchingColumns = new ArrayList<Column>();
            for (Column column : this.getColumnFactory().columns()) {
                if (!this.columnNameCompiledPattern.matcher(column.getName()).matches()) continue;
                matchingColumns.add(column);
            }
            this.columns = matchingColumns;
            this.columnsUpdated();
        }
        this.processRowForColumns(row, this.columns);
    }

    protected void columnsUpdated() {
    }

    public abstract void processRowForColumns(Row var1, Iterable<Column> var2) throws Exception;

    public abstract AppliesToParams getParams();

    public static JsonObject selfReport(AppliesToParams parameter) {
        JsonObject obj = (JsonObject)JSON.parse((String)JSON.json((Object)parameter), JsonObject.class);
        obj.remove("columns");
        obj.addProperty("numColumns", (Number)parameter.columns.size());
        return obj;
    }

    public static abstract class AppliesToParams
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public AppliesTo appliesTo = AppliesTo.SINGLE_COLUMN;
        public List<String> columns = new ArrayList<String>();
        public String appliesToPattern;

        public void validate() throws IllegalArgumentException {
            if (this.appliesTo == AppliesTo.SINGLE_COLUMN) {
                if (this.columns.isEmpty() || StringUtils.isBlank((String)this.columns.get(0))) {
                    throw new IllegalArgumentException("Empty column name");
                }
            } else if (this.appliesTo == AppliesTo.COLUMNS) {
                if (this.columns.isEmpty()) {
                    throw new IllegalArgumentException("Empty column list");
                }
                for (String columnName : this.columns) {
                    if (!StringUtils.isBlank((String)columnName)) continue;
                    throw new IllegalArgumentException("Empty column name in list");
                }
            } else if (this.appliesTo == AppliesTo.PATTERN && StringUtils.isBlank((String)this.appliesToPattern)) {
                throw new IllegalArgumentException("Empty pattern");
            }
        }

        public Set<String> getImpactedColumns(Set<String> availableColumns) {
            Set<String> impactedColumns = new HashSet<String>();
            switch (this.appliesTo) {
                case SINGLE_COLUMN: {
                    String column;
                    if (this.columns.isEmpty() || !availableColumns.contains(column = this.columns.get(0))) break;
                    impactedColumns = Sets.newHashSet((Object[])new String[]{column});
                    break;
                }
                case COLUMNS: {
                    for (String c2 : this.columns) {
                        if (!availableColumns.contains(c2)) continue;
                        impactedColumns.add(c2);
                    }
                    break;
                }
                case ALL: {
                    impactedColumns = availableColumns;
                    break;
                }
                case PATTERN: {
                    try {
                        Pattern columnNameCompiledPattern = Pattern.compile(this.appliesToPattern);
                        for (String c3 : availableColumns) {
                            if (!columnNameCompiledPattern.matcher(c3).matches()) continue;
                            impactedColumns.add(c3);
                        }
                        break;
                    }
                    catch (PatternSyntaxException ex) {
                        throw new IllegalArgumentException("The pattern is invalid: " + ExceptionUtils.getMessageWithCauses((Throwable)ex), ex);
                    }
                }
            }
            return impactedColumns;
        }
    }

    public static enum AppliesTo {
        SINGLE_COLUMN,
        COLUMNS,
        PATTERN,
        ALL;

    }

    public static abstract class AppliesToProcessorMeta<T extends AppliesToProcessor, P extends AppliesToParams>
    extends ProcessorMeta<T, P> {
        public DatasetPairLineage getUpdatedDatasetPairLineage(StepParams param, DatasetPairLineage previousDatasetPairLineage, String referenceColumn, RelationDirection relationDirection, boolean removeRelationsToReferenceColumn) {
            return this.getUpdatedDatasetPairLineage(param, previousDatasetPairLineage, referenceColumn, relationDirection, removeRelationsToReferenceColumn, false);
        }

        public DatasetPairLineage getUpdatedDatasetPairLineage(StepParams param, DatasetPairLineage previousDatasetPairLineage, String referenceColumn, RelationDirection relationDirection, boolean removeRelationsToReferenceColumn, boolean markAsIndirect) {
            if (!(param instanceof AppliesToParams)) {
                throw new IllegalArgumentException("Unsupported param type: " + param.getClass().getSimpleName());
            }
            AppliesToParams appliesToParams = (AppliesToParams)param;
            DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage(previousDatasetPairLineage);
            if (AppliesTo.SINGLE_COLUMN.equals((Object)appliesToParams.appliesTo) && appliesToParams.columns.isEmpty()) {
                throw new IllegalConfigurationException("Missing input column information for lineage on " + this.getName() + " processor parameters.");
            }
            if (relationDirection == RelationDirection.TO && removeRelationsToReferenceColumn) {
                updatedDatasetPairLineage.removeRelationsOnColumn(referenceColumn);
            }
            if (StringUtils.isNotBlank((String)referenceColumn)) {
                Set<String> impactedColumns = appliesToParams.getImpactedColumns(previousDatasetPairLineage.getOutputColumns());
                for (String impactedColumn : impactedColumns) {
                    String fromColumn;
                    updatedDatasetPairLineage.addFactorizedColumnRelations(fromColumn, switch (relationDirection) {
                        case RelationDirection.TO -> {
                            fromColumn = impactedColumn;
                            yield referenceColumn;
                        }
                        case RelationDirection.FROM -> {
                            fromColumn = referenceColumn;
                            yield impactedColumn;
                        }
                        default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)relationDirection));
                    }, markAsIndirect);
                }
            }
            return updatedDatasetPairLineage;
        }

        public static enum RelationDirection {
            TO,
            FROM;

        }
    }
}

