/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.join;

import com.dataiku.dip.shaker.processors.expr.TextSimplifier;
import com.dataiku.dip.shaker.processors.expr.TokenizedText;
import com.dataiku.dip.shaker.processors.join.MemoryEquiJoiner;
import org.apache.log4j.Logger;

public abstract class FuzzySearchEngine {
    int threshold;
    private TextSimplifier textSimplifier;
    private static Logger logger = Logger.getLogger((String)"dku.shaker.fuzzy_join");

    protected String simplify(String w) {
        TokenizedText tokenized = new TokenizedText(w);
        this.textSimplifier.simplify(tokenized);
        return tokenized.toString(" ");
    }

    public abstract void populate(String var1);

    public abstract void endPopulating();

    protected FuzzySearchEngine(MemoryEquiJoiner.Parameter params) {
        this.threshold = params.maxLevenshtein;
        try {
            this.textSimplifier = new TextSimplifier(params);
        }
        catch (Exception e) {
            logger.error((Object)"Could not build text simplifier with these parameters");
        }
    }

    public abstract String search(String var1) throws InterruptedException;
}

