/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.numbers;

import com.dataiku.dip.ProcessorWithResourceFiles;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.data.currency.CurrencyDataUtils;
import com.dataiku.dip.datalayer.CellData;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.PrepareSnowflakeUDFUtils;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.numbers.CurrencyConverterAlgorithm;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.sql.SnowflakeUDFProcessorTranslator;
import com.dataiku.dip.shaker.text.Labelled;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CurrencyConverterProcessor {
    public static final ProcessorMeta<StreamImpl, Parameter> META = new ProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "CurrencyConverterProcessor";
        }

        @Override
        public String getDocPage() {
            return "currency-converter";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.MATH});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.CurrencyConverterProcessor.HELP", "This processor converts a column with monetary data from one currency to another.\n\nIt supports around 40 currencies with historical data\n\n# Input currency\n\nThe processor can either use a constant input currency, or read a different input currency from a dedicated column. This can be used to 'realign' different input currencies to a single output\n\n# Output currency\n\nThe processor outputs all output in the same currency\n\n# Reference date\n\nThe processor includes historical data for the currencies. You can either set the conversion to a fixed date, or use a Date-typed column to use a different reference date for each row. If a row contains an empty reference date, the last known date for the currency will be used");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withCustomForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.CurrencyConverterProcessor.DESCRIPTION", 1.actionVerb("Convert") + " currencies")).withMNEColParam("inputColumn", this.translate(language, "SHAKER.PROCESSOR.CurrencyConverterProcessor.DESCRIPTION.INPUT_COLUMN", "Column to convert")).withBool("isCurrencyFromColumn", this.translate(language, "SHAKER.PROCESSOR.CurrencyConverterProcessor.DESCRIPTION.IS_CURRENCY_FROM_COLUMN", "Currency input is column")).withParam("refCurrencyColumn", "column", false, false, this.translate(language, "SHAKER.PROCESSOR.CurrencyConverterProcessor.DESCRIPTION.REF_CURRENCY_COLUMN", "Column currency input")).withParam("inputCurrency", "string", false, true, this.translate(language, "SHAKER.PROCESSOR.CurrencyConverterProcessor.DESCRIPTION.INPUT_CURRENCY", "Input currency")).withParam("outputCurrency", "string", false, true, this.translate(language, "SHAKER.PROCESSOR.CurrencyConverterProcessor.DESCRIPTION.OUTPUT_CURRENCY", "Output currency")).withParam(ParamDesc.advancedSelect("dateInput", this.translate(language, "SHAKER.PROCESSOR.CurrencyConverterProcessor.DESCRIPTION.DATE_INPUT", "Input date source"), "", DateInput.class).withDefaultValue(DateInput.LATEST)).withParam("refDateColumn", "column", false, false, this.translate(language, "SHAKER.PROCESSOR.CurrencyConverterProcessor.DESCRIPTION.REF_DATE_COLUMN", "Column date input")).withParam("refDateCustom", "string", false, true, this.translate(language, "SHAKER.PROCESSOR.CurrencyConverterProcessor.DESCRIPTION.REF_DATE_CUSTOM", "Custom date input")).withParam(ParamDesc.intP("decimalNumber", this.translate(language, "SHAKER.PROCESSOR.CurrencyConverterProcessor.DESCRIPTION.DECIMAL_NUMBER", "Precision"), "", 2)).withMandSParam("outputColumn", this.translate(language, "SHAKER.PROCESSOR.CurrencyConverterProcessor.DESCRIPTION.OUTPUT_COLUMN", "Output column"));
        }

        @Override
        public StreamImpl build(Parameter parameter) {
            return new StreamImpl(parameter);
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return this.getCapabilities(sp, report, dialect, null);
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect, AbstractSQLConnection conn) {
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            if (PrepareSnowflakeUDFUtils.canUseSnowflakeUDF(conn)) {
                ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
            }
            return ret;
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SnowflakeUDFSQLTranslator((Parameter)parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter params = (Parameter)pss.params;
            if (StringUtils.isBlank((String)params.inputColumn)) {
                throw new IllegalConfigurationException("Missing input column for Convert currencies processor");
            }
            String outputColumn = StringUtils.isBlank((String)params.outputColumn) ? params.inputColumn : params.outputColumn;
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                if (!params.inputColumn.equals(outputColumn)) {
                    updatedDatasetPairLineage.removeRelationsOnColumn(params.outputColumn);
                }
                updatedDatasetPairLineage.addFactorizedColumnRelations(params.inputColumn, outputColumn);
                if (params.isCurrencyFromColumn) {
                    if (StringUtils.isBlank((String)params.refCurrencyColumn)) {
                        throw new IllegalConfigurationException("Missing currency column for Convert currencies processor");
                    }
                    updatedDatasetPairLineage.addFactorizedColumnRelations(params.refCurrencyColumn, outputColumn);
                }
                if (params.dateInput == DateInput.COLUMN) {
                    if (StringUtils.isBlank((String)params.refDateColumn)) {
                        throw new IllegalConfigurationException("Missing date column for Convert currencies processor");
                    }
                    updatedDatasetPairLineage.addFactorizedColumnRelations(params.refDateColumn, outputColumn);
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };

    static class StreamImpl
    extends SingleRowProcessor
    implements Processor,
    ProcessorWithResourceFiles {
        private final Parameter parameter;
        private final DateTimeFormatter inFormatter = ISODateTimeFormat.dateTimeParser().withZone(DateTimeZone.UTC);
        private final DateTimeFormatter outFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        private Column currencyValueColumn;
        private Column outputColumn;
        private Column dateRateColumn;
        private Column currencyFromColumn;
        private File currencyResourceFolder;
        private CurrencyConverterAlgorithm currencyConverterAlgorithm;
        private final CellData currencyValueCell = new CellData();
        private final CellData dateRateCell = new CellData();
        private final CellData currencyFromCell = new CellData();

        private StreamImpl(Parameter parameter) {
            this.parameter = parameter;
        }

        public void init() {
            this.currencyConverterAlgorithm = CurrencyConverterAlgorithm.getInstance((File)new File(this.currencyResourceFolder, "data.csv.gz"));
            this.currencyValueColumn = this.getColumnFactory().column(this.parameter.inputColumn, Processor.ProcessorRole.INPUT_COLUMN);
            if (this.parameter.dateInput == DateInput.COLUMN && !StringUtils.isBlank((String)this.parameter.refDateColumn)) {
                this.dateRateColumn = this.getColumnFactory().column(this.parameter.refDateColumn, Processor.ProcessorRole.INPUT_COLUMN);
            }
            if (this.parameter.isCurrencyFromColumn && !StringUtils.isBlank((String)this.parameter.refCurrencyColumn)) {
                this.currencyFromColumn = this.getColumnFactory().column(this.parameter.refCurrencyColumn, Processor.ProcessorRole.INPUT_COLUMN);
            }
            this.outputColumn = !StringUtils.isBlank((String)this.parameter.outputColumn) ? this.getColumnFactory().columnAfter(this.parameter.inputColumn, this.parameter.outputColumn, Processor.ProcessorRole.OUTPUT_COLUMN) : this.currencyValueColumn;
        }

        private String getRateDate(Row row) {
            if (this.parameter.dateInput == DateInput.COLUMN && this.dateRateColumn != null) {
                row.get(this.dateRateColumn, this.dateRateCell);
                if (this.dateRateCell.hasData()) {
                    return this.outFormatter.print((ReadableInstant)this.inFormatter.parseDateTime(this.dateRateCell.toString()));
                }
            } else {
                if (this.parameter.dateInput == DateInput.CUSTOM) {
                    return this.parameter.refDateCustom;
                }
                if (this.parameter.dateInput == DateInput.LATEST) {
                    return "lastKnownDate";
                }
            }
            return null;
        }

        private String getInputCurrency(Row row) {
            if (this.currencyFromColumn != null) {
                row.get(this.currencyFromColumn, this.currencyFromCell);
                if (this.currencyFromCell.hasData()) {
                    return this.currencyFromCell.toString();
                }
            } else {
                return this.parameter.inputCurrency;
            }
            return null;
        }

        public void processRow(Row row) {
            row.get(this.currencyValueColumn, this.currencyValueCell);
            if (this.currencyValueCell.hasData()) {
                String date = this.getRateDate(row);
                String inputCurrency = this.getInputCurrency(row);
                Double convertedValue = this.currencyConverterAlgorithm.convert(this.currencyValueCell.toString(), inputCurrency, this.parameter.outputCurrency, date, this.parameter.decimalNumber);
                if (convertedValue != null) {
                    row.put(this.outputColumn, convertedValue.doubleValue());
                } else {
                    row.put(this.outputColumn, "");
                }
            } else {
                row.put(this.outputColumn, "");
            }
        }

        @Override
        public Map<String, File> gatherRequirements() {
            HashMap<String, File> ret = new HashMap<String, File>();
            ret.put("dku.currencyconverter.rates", CurrencyDataUtils.getStandardResourceFolder());
            return ret;
        }

        @Override
        public void setRequiredFiles(Map<String, File> requiredFiles) {
            this.currencyResourceFolder = requiredFiles.get("dku.currencyconverter.rates");
        }

        public void postProcess() {
        }
    }

    private static class SnowflakeUDFSQLTranslator
    implements SnowflakeUDFProcessorTranslator {
        private final Parameter parameter;
        private final String functionName;

        private SnowflakeUDFSQLTranslator(Parameter parameter) {
            this.parameter = parameter;
            this.functionName = "currencyConverter_" + SecretKeyGenerator.generate();
        }

        @Override
        public List<SnowflakeUDFProcessorTranslator.SnowflakeUDFResource> getUDFResources() throws IOException {
            List<SnowflakeUDFProcessorTranslator.SnowflakeUDFResource> resources = SnowflakeUDFProcessorTranslator.createStandardResourceList();
            SnowflakeUDFProcessorTranslator.addStandardResources(resources, SnowflakeUDFProcessorTranslator.StandardResource.DKU_CORE_JAR);
            resources.add(new SnowflakeUDFProcessorTranslator.SnowflakeUDFResource(CurrencyDataUtils.getStandardResourceFile(), ""));
            return resources;
        }

        @Override
        public List<SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef> getUDFs() {
            SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef def = new SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef(this.functionName, "com.dataiku.dip.shaker.processors.numbers.CurrencyConverterUDF.process", "input STRING, inputCurrency STRING, outputCurrency STRING, date STRING, decimalNumber INTEGER", "STRING, STRING, STRING, STRING, INTEGER", "FLOAT");
            def.importStandardResources(SnowflakeUDFProcessorTranslator.StandardResource.DKU_CORE_JAR);
            def.imports.add("data.csv.gz");
            return Lists.newArrayList((Object[])new SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef[]{def});
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            SQLDialect d = chain.getDialect();
            ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
            if (chain.isCreatedOrModifiedByCurrentQuery(this.parameter.inputColumn)) {
                chain = chain.makeSubquery();
            }
            String rateDate = d.quoteString("lastKnownDate");
            if (this.parameter.dateInput == DateInput.COLUMN) {
                rateDate = ebf.col(this.parameter.refDateColumn).format(Type.DATE, "yyyy-MM-dd").toSQL(d);
            } else if (this.parameter.dateInput == DateInput.CUSTOM) {
                rateDate = d.quoteString(this.parameter.refDateCustom);
            }
            String inputCurrency = this.parameter.isCurrencyFromColumn ? d.quoteIdentifier(this.parameter.refCurrencyColumn) : d.quoteString(this.parameter.inputCurrency);
            ExpressionBuilder func = ebf.expr(String.format(Locale.ROOT, "%s(%s, %s, %s, %s, %s)", this.functionName, d.quoteIdentifier(this.parameter.inputColumn), inputCurrency, d.quoteString(this.parameter.outputCurrency), rateDate, this.parameter.decimalNumber));
            chain.addAfterOrReplaceColumn(chain.getCurrentColumn(this.parameter.inputColumn), func, Type.DOUBLE, this.parameter.outputColumn, false);
            return chain;
        }
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String inputColumn;
        public String outputColumn;
        public String inputCurrency;
        public String outputCurrency;
        public DateInput dateInput;
        public String refDateColumn;
        public String refDateCustom;
        public String refCurrencyColumn;
        public Integer decimalNumber;
        public boolean isCurrencyFromColumn = false;

        public void validate() throws IllegalArgumentException {
            if (this.isCurrencyFromColumn && StringUtils.isBlank((String)this.refCurrencyColumn)) {
                throw ErrorContext.iae((String)"'refCurrencyColumn' is mandatory when 'isCurrencyFromColumn' is enabled");
            }
            if (this.dateInput == DateInput.COLUMN && StringUtils.isBlank((String)this.refDateColumn)) {
                throw ErrorContext.iae((String)"'refDateColumn' is mandatory when input date source is 'COLUMN'");
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum DateInput implements Labelled
    {
        LATEST{

            @Override
            public String getLabel() {
                return "Last known";
            }
        }
        ,
        COLUMN{

            @Override
            public String getLabel() {
                return "From column";
            }
        }
        ,
        CUSTOM{

            @Override
            public String getLabel() {
                return "Custom input";
            }
        };

    }
}

