/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.numbers;

import com.dataiku.dip.datalayer.CellData;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.types.DoubleMeaning;
import com.dataiku.dip.util.ParamDesc;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class MinMaxProcessor
extends SingleRowProcessor
implements Processor {
    public static final ProcessorMeta<MinMaxProcessor, Parameter> META = new ProcessorMeta<MinMaxProcessor, Parameter>(){

        @Override
        public String getName() {
            return "MinMaxProcessor";
        }

        @Override
        public String getDocPage() {
            return "number-clipping";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.MATH});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.MinMaxProcessor.HELP", "Creates upper and/or lower bounds in one or several numerical columns. This processor always acts in place.\n\n# Options\n\n**Clip outliers**\n\nReplaces outliers with lower and/or upper bounds.\n\n**Clear outliers**\n\nRemoves outliers.");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            ParamDesc columnsParam = new ParamDesc("columns", "columns").withDefaultValue(Collections.emptyList()).withMandatory(true).withLabel(this.translate(language, "SHAKER.PROCESSOR.MinMaxProcessor.DESCRIPTION.COLUMNS", "Columns"));
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.MinMaxProcessor.DESCRIPTION", 1.actionVerb("Force") + " numerical range")).withParam(columnsParam).withParam(ParamDesc.doubleP("lowerBound", this.translate(language, "SHAKER.PROCESSOR.MinMaxProcessor.DESCRIPTION.LOWER_BOUND", "Lower bound")).withMandatory(false)).withParam(ParamDesc.doubleP("upperBound", this.translate(language, "SHAKER.PROCESSOR.MinMaxProcessor.DESCRIPTION.UPPER_BOUND", "Upper bound")).withMandatory(false)).withBool("clear", "", this.translate(language, "SHAKER.PROCESSOR.MinMaxProcessor.DESCRIPTION.CLEAR.TRUE", "Clear outliers"), this.translate(language, "SHAKER.PROCESSOR.MinMaxProcessor.DESCRIPTION.CLEAR.FALSE", "Clip outliers"));
        }

        @Override
        public Object selfReport(Parameter param) {
            JsonObject out = new JsonObject();
            out.addProperty("clear", Boolean.valueOf(param.clear));
            out.addProperty("numColumns", (Number)param.columns.size());
            return out;
        }

        @Override
        public MinMaxProcessor build(Parameter parameter) {
            return new MinMaxProcessor(parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            return previousRecipeLineage;
        }
    };
    private final Parameter parameter;
    private List<Column> cds = new ArrayList<Column>();
    private DoubleMeaning dm = new DoubleMeaning();
    private boolean hasMin = false;
    private boolean hasMax = false;
    private double min;
    private double max;
    CellData buf = new CellData();

    public MinMaxProcessor(Parameter parameter) {
        this.parameter = parameter;
    }

    public void init() {
        for (String s : this.parameter.columns) {
            this.cds.add(this.getColumnFactory().column(s, Processor.ProcessorRole.INPUT_COLUMN));
        }
        try {
            this.min = Double.valueOf(this.parameter.lowerBound);
            this.hasMin = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.max = Double.valueOf(this.parameter.upperBound);
            this.hasMax = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasMin && this.hasMax && this.min > this.max) {
            throw new IllegalArgumentException("Lower bound > higher bound");
        }
    }

    public void processRow(Row row) {
        if (!this.hasMin && !this.hasMax) {
            return;
        }
        for (Column col : this.cds) {
            row.get(col, this.buf);
            if (!this.buf.hasData()) continue;
            try {
                double d = this.dm.doubleValue(this.buf.toString());
                if (this.hasMin && d < this.min) {
                    if (this.parameter.clear) {
                        row.delete(col);
                        continue;
                    }
                    row.put(col, this.parameter.lowerBound);
                    continue;
                }
                if (!this.hasMax || !(d > this.max)) continue;
                if (this.parameter.clear) {
                    row.delete(col);
                    continue;
                }
                row.put(col, this.parameter.upperBound);
            }
            catch (Exception e) {}
        }
    }

    public void postProcess() {
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = 1L;
        public List<String> columns = new ArrayList<String>();
        String lowerBound;
        String upperBound;
        boolean clear;

        public void validate() throws IllegalArgumentException {
        }
    }
}

