/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.reshaping;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class ObjectFoldProcessor
extends SingleInputSingleOutputRowProcessor
implements Processor {
    public static final ProcessorMeta<ObjectFoldProcessor, Parameter> META = new ProcessorMeta<ObjectFoldProcessor, Parameter>(){

        @Override
        public String getName() {
            return "ObjectFoldProcessor";
        }

        @Override
        public String getDocPage() {
            return "fold-object";
        }

        @Override
        public Category getCategory() {
            return Category.RESHAPING;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.RESHAPING});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.ObjectFoldProcessor.DESCRIPTION", 1.actionVerb("Fold") + " object keys")).withMNEColParam("column", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.COLUMN", "Column")).withBool("emitEmptyObject", this.translate(language, "SHAKER.PROCESSOR.ObjectFoldProcessor.DESCRIPTION.EMIT_EMPTY_OBJECT", "Produce a row for empty object {}")).withBool("emitNonObject", this.translate(language, "SHAKER.PROCESSOR.ObjectFoldProcessor.DESCRIPTION.EMIT_NON_OBJECT", "Produce a row for non-object"));
        }

        @Override
        public Object selfReport(Parameter p) {
            return JSON.deepCopyExcept((Object)p, (String[])new String[]{"column"});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.ObjectFoldProcessor.HELP", "This processor splits a JSON Object column and transforms them into several rows with key and value in new columns.");
        }

        @Override
        public ObjectFoldProcessor build(Parameter parameter) throws Exception {
            return new ObjectFoldProcessor(parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter objectFoldParams = (Parameter)pss.params;
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                if (StringUtils.isNotBlank((String)objectFoldParams.column)) {
                    String outputKey = objectFoldParams.column + "_key";
                    String outputVal = objectFoldParams.column + "_val";
                    updatedDatasetPairLineage.addFactorizedColumnRelations(objectFoldParams.column, outputKey);
                    updatedDatasetPairLineage.addFactorizedColumnRelations(objectFoldParams.column, outputVal);
                    HashSet<Object> directRelationColumns = new HashSet<Object>();
                    directRelationColumns.add(objectFoldParams.column);
                    directRelationColumns.add(outputKey);
                    directRelationColumns.add(outputVal);
                    if (!objectFoldParams.emitEmptyObject || !objectFoldParams.emitNonObject) {
                        for (String outputColumn : updatedDatasetPairLineage.getOutputColumns()) {
                            if (directRelationColumns.contains(outputColumn)) continue;
                            updatedDatasetPairLineage.addFactorizedColumnRelations(objectFoldParams.column, outputColumn, true);
                        }
                    }
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private final Parameter parameter;
    private Column foldC;
    private Column keyC;
    private Column valC;

    public ObjectFoldProcessor(Parameter parameter) {
        this.parameter = parameter;
    }

    public void init() {
        this.foldC = this.getCf().column(this.parameter.column, Processor.ProcessorRole.INPUT_COLUMN);
        this.valC = this.getCf().columnAfter(this.parameter.column, this.parameter.column + "_val", Processor.ProcessorRole.OUTPUT_COLUMN);
        this.keyC = this.getCf().columnAfter(this.parameter.column, this.parameter.column + "_key", Processor.ProcessorRole.OUTPUT_COLUMN);
    }

    public void processRow(Row row) throws Exception {
        JSONObject obj;
        String c2 = row.get(this.foldC);
        if (StringUtils.isBlank((String)c2)) {
            if (this.parameter.emitNonObject) {
                this.emit(row, null, null);
            }
            return;
        }
        try {
            obj = new JSONObject(c2);
        }
        catch (JSONException e) {
            if (this.parameter.emitNonObject) {
                this.emit(row, null, null);
            }
            return;
        }
        if (obj.length() == 0) {
            if (this.parameter.emitEmptyObject) {
                this.emit(row, null, null);
            }
            return;
        }
        Iterator keys = obj.keys();
        while (keys.hasNext()) {
            String k = keys.next().toString();
            this.emit(row, k, obj.get(k).toString());
        }
    }

    private void emit(Row in, String k, String v) throws Exception {
        Row out = this.getRf().row();
        for (Column c2 : this.getCf().columns()) {
            if (c2.equals(this.foldC)) {
                if (!StringUtils.isBlank((String)k)) {
                    out.put(this.keyC, k);
                }
                if (StringUtils.isBlank((String)v)) continue;
                out.put(this.valC, v);
                continue;
            }
            String cp = in.get(c2);
            if (StringUtils.isBlank((String)cp)) continue;
            out.put(c2, cp);
        }
        this.getProcessorOutput().emitRow(out);
    }

    public void postProcess() throws Exception {
        this.getCf().deleteColumn(this.parameter.column);
        this.getProcessorOutput().lastRowEmitted();
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String column;
        public boolean emitEmptyObject;
        public boolean emitNonObject;

        public void validate() throws IllegalArgumentException {
        }
    }
}

