/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.BigQueryConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryResultSet;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryResultSetMetadata;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetRecordCount;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.SQLCodes;
import com.dataiku.dip.datasets.sql.bigquery.BigQueryDatasetConfig;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.partitioning.ExactValueDimension;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.partitioning.TimeDimensionValue;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.BigQueryColumnReader;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.SQLAggregateAbility;
import com.dataiku.dip.sql.SQLAggregateType;
import com.dataiku.dip.sql.SQLCapability;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SchemaOptions;
import com.dataiku.dip.sql.SchemaReader;
import com.dataiku.dip.sql.bigquery.BigQueryClient;
import com.dataiku.dip.sql.bigquery.BigQueryCreateTableParser;
import com.dataiku.dip.sql.bigquery.BigQueryNativeClient;
import com.dataiku.dip.sql.bigquery.BigQuerySchemaHandler;
import com.dataiku.dip.sql.bigquery.EncryptionConfiguration;
import com.dataiku.dip.sql.bigquery.Field;
import com.dataiku.dip.sql.bigquery.JobResource;
import com.dataiku.dip.sql.bigquery.RangePartitioning;
import com.dataiku.dip.sql.bigquery.TableResource;
import com.dataiku.dip.sql.bigquery.TimePartitioning;
import com.dataiku.dip.sql.metadata.DatabaseObjectKey;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.util.DKUNumberUtils;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.JobStatistics;
import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.Schema;
import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.TableId;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class BigQuerySQLDialect
extends GenericSQLDialect {
    private static final String TABLE_OR_VIEW_REFERENCE_REGEX = "(`(?:%s)`?\\.`?[^.`]+`)";
    private static final String OR_REGEX = "|";
    private static final String SINGLE_SPACE = " ";
    private static final String WHITE_SPACE_OR_END_OF_STRING_REGEX = "(\\s|$)";
    private static final String CAPTURED_GROUP_REGEX = ".$1";
    private static final String CAPTURED_GROUP_2_REGEX = "$2";
    private static final Joiner OR_JOINER = Joiner.on((String)"|");
    private static final String TRIPLE_QUOTE = "'''";
    private static final String SIMPLE_QUOTE = "'";
    private static final String MISSING_SCHEMA_ERROR = "Schema is mandatory for BigQuery and corresponds to the BigQuery's dataset ID.";
    protected final ThreadLocal<SimpleDateFormat> localParser = new ThreadLocal();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.bigquery");

    @Override
    protected void ensureThreadLocalsAreHere() {
        super.ensureThreadLocalsAreHere();
        if (this.localParser.get() == null) {
            this.localParser.set(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"));
        }
    }

    @Override
    public boolean needSubQueryForConstantInWhereClause() {
        return true;
    }

    @Override
    public String alterQueryForResultSetMetadataOnPreparedStatement(String sql) {
        return "SELECT * FROM (\n" + sql + "\n) _subquery_ LIMIT 0";
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: {
                return new DSSTypeSQLMapping(Type.INT, 4, "INT64", new Integer[]{-6, 5, -5});
            }
            case FLOAT: 
            case DOUBLE: {
                return new DSSTypeSQLMapping(Type.DOUBLE, 8, "FLOAT64", new Integer[]{7, 2, 3});
            }
            case STRING: {
                return new DSSTypeSQLMapping(Type.STRING, 12, "STRING", new Integer[]{2003, 1, 1111, -16, -1, -9, 92});
            }
            case ARRAY: {
                if (BigQuerySchemaHandler.HIERARCHICAL_ENABLED) {
                    return new DSSTypeSQLMapping(Type.ARRAY, 12, "ARRAY", new Integer[]{2003});
                }
                return super.getSQLType(schemaColumn, dataset);
            }
            case OBJECT: {
                if (BigQuerySchemaHandler.HIERARCHICAL_ENABLED) {
                    return new DSSTypeSQLMapping(Type.OBJECT, 12, "STRUCT", new Integer[]{2002});
                }
                return super.getSQLType(schemaColumn, dataset);
            }
            case DATE: {
                return new DSSTypeSQLMapping(Type.DATE, 93, "timestamp", new Integer[]{91});
            }
            case DATEONLY: {
                return new DSSTypeSQLMapping(Type.DATEONLY, 91, "date", new Integer[]{93});
            }
            case DATETIMENOTZ: {
                return new DSSTypeSQLMapping(Type.DATETIMENOTZ, 93, "datetime", new Integer[]{91});
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    public SchemaColumn fromSQLType(String name, int sqlType, String sqlTypeName, int sqlPrecision, int sqlScale, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) {
        if (sqlType == 12 && "DATETIME".equalsIgnoreCase(sqlTypeName)) {
            if (datetimenotzReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE) {
                return new SchemaColumn(name, Type.DATE).withTimestampNoTzAsDate(true).withOriginalSQLType(sqlTypeName);
            }
            if (datetimenotzReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS) {
                return new SchemaColumn(name, Type.DATETIMENOTZ).withOriginalSQLType(sqlTypeName);
            }
        }
        SchemaColumn schemaColumn = super.fromSQLType(name, sqlType, sqlTypeName, sqlPrecision, sqlScale, datetimenotzReadMode, dateonlyReadMode);
        if (BigQuerySchemaHandler.LOSSY_TYPES.contains(sqlTypeName.toUpperCase())) {
            schemaColumn.originalSQLType = sqlTypeName;
        }
        return schemaColumn;
    }

    @Override
    public boolean lacksTimezoneInfo(String sqlTypeName, int sqlPrecision) {
        return "DATETIME".equalsIgnoreCase(sqlTypeName);
    }

    @Override
    public String getValueAsDSSString(ResultSet rs2, int sqlType, int colIdx, SchemaColumn schemaColumn, boolean normalizeDoubles, boolean timestampNoTzAsDate, DateTimeZone assumedTz) throws SQLException {
        Type dssType = schemaColumn.getType();
        if (rs2 instanceof BigQueryResultSet) {
            if (sqlType == 93) {
                String sqlTypeName = schemaColumn.originalSQLType != null ? schemaColumn.originalSQLType : rs2.getMetaData().getColumnTypeName(colIdx);
                String s = rs2.getString(colIdx);
                if ("DATETIME".equalsIgnoreCase(sqlTypeName) && schemaColumn != null) {
                    if (schemaColumn.getType() != Type.DATE) {
                        if (schemaColumn.getType() == Type.DATETIMENOTZ) {
                            return s != null ? s.replace('T', ' ') : s;
                        }
                        return s;
                    }
                } else {
                    return s;
                }
            }
            return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
        }
        if (sqlType == 12 && dssType == Type.DATE) {
            this.ensureThreadLocalsAreHere();
            return BigQueryColumnReader.readDateTime(rs2, colIdx, assumedTz, this.localParser.get());
        }
        if (sqlType == -2 || sqlType == -3) {
            return BigQueryColumnReader.readBytes(rs2, colIdx);
        }
        if (BigQuerySchemaHandler.HIERARCHICAL_ENABLED && sqlType == 12 && (dssType == Type.OBJECT || dssType == Type.ARRAY)) {
            return BigQueryColumnReader.readStructOrArray(rs2, colIdx, schemaColumn);
        }
        return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
    }

    @Override
    public String getIdentifierQuoteChar() {
        return "`";
    }

    @Override
    public String quoteIdentifier(String str) {
        return this.getIdentifierQuoteChar() + str + this.getIdentifierQuoteChar();
    }

    @Override
    public String quoteDate(String str) {
        return "CAST(" + this.quoteString(str) + " AS TIMESTAMP)";
    }

    @Override
    public String quoteDateOnly(String str) {
        return "CAST(" + this.quoteString(str) + " AS DATE)";
    }

    @Override
    public String quoteDatetimeNoTz(String str) {
        return "CAST(" + this.quoteString(str) + " AS DATETIME)";
    }

    @Override
    public String captureGroup(int group) {
        return "\\" + group;
    }

    @Override
    public boolean supportsLookAroundExpressions() {
        return false;
    }

    @Override
    protected String cast(String expr, Type exprType, Type requestedType, int maxLength) {
        if (requestedType == Type.BOOLEAN && exprType == Type.STRING) {
            return "case when (" + expr + ") is null or cast(" + expr + " as string) = '' then null else regexp_contains(cast(" + expr + " as string), r'^(?i)" + this.booleanTrueValuesRegex + "$') end";
        }
        return super.cast(expr, exprType, requestedType, maxLength);
    }

    @Override
    public boolean needCast(SchemaColumn col, boolean isDatasetManaged) {
        if (isDatasetManaged || col == null || StringUtils.isEmpty((String)col.originalSQLType)) {
            return false;
        }
        if (col.getType() == Type.STRING && Arrays.asList("DATE", "DATETIME").contains(col.originalSQLType)) {
            return true;
        }
        return Arrays.asList("TIME", "INTERVAL", "GEOGRAPHY", "BYTES", "JSON").contains(col.originalSQLType);
    }

    public boolean avoidTimestampCast(SchemaColumn col, DatasetHandler.DatasetParams config) {
        if (config == null) {
            return false;
        }
        BigQueryDatasetConfig cfg = (BigQueryDatasetConfig)config;
        return col.getName().equals(cfg.externalPartitionField) && col.getType().isTimestamp() && Arrays.asList("DATE", "DATETIME").contains(col.originalSQLType);
    }

    @Override
    public ExpressionBuilder getAdjustedColumnForTimeCondition(ExpressionBuilder col, SchemaColumn dimensionColumn, DatasetHandler.DatasetParams config, boolean isDatasetManaged) {
        if (dimensionColumn == null || this.avoidTimestampCast(dimensionColumn, config)) {
            return col;
        }
        return super.getAdjustedColumnForTimeCondition(col, dimensionColumn, config, isDatasetManaged);
    }

    @Override
    public String getStringForTimeDimensionValue(TimeDimensionValue timeValue, SchemaColumn dimensionColumn, DatasetHandler.DatasetParams config, boolean isDatasetManaged) {
        if (this.avoidTimestampCast(dimensionColumn, config)) {
            String valueString = timeValue.id();
            switch (timeValue.getDimension().mappedPeriod) {
                case YEAR: {
                    return valueString + "-01-01";
                }
                case MONTH: {
                    return valueString + "-01";
                }
                case DAY: {
                    return valueString;
                }
                case HOUR: {
                    if (this.avoidTimestampCast(dimensionColumn, config)) {
                        if (valueString.length() != 13) {
                            throw new QueryUtils.SQLGenerationException("Partition id " + valueString + " doesn't conform to format YYYY-MM-DD-HH");
                        }
                        DateTime partitionIdAtUTC = new DateTime(timeValue.getYear(), timeValue.getMonth(), timeValue.getDay(), timeValue.getHour(), 0, DateTimeZone.UTC);
                        DateTime partitionIdAtAssumedTimeZone = partitionIdAtUTC.toDateTime(DateTimeZone.forID((String)((BigQueryDatasetConfig)config).getAssumedJavaTzForUnknownTz()));
                        return partitionIdAtAssumedTimeZone.toString("yyyy-MM-dd HH:mm:ss");
                    }
                    throw new QueryUtils.SQLGenerationException("Using an HOUR partition period with a BigQuery DATE type is not supported");
                }
            }
            throw new QueryUtils.SQLGenerationException("Cannot convert time partition in " + String.valueOf(timeValue.getDimension().mappedPeriod) + " to SQL");
        }
        return super.getStringForTimeDimensionValue(timeValue, dimensionColumn, config, isDatasetManaged);
    }

    @Override
    public ExpressionBuilder cast(SchemaColumn col, ExpressionBuilder eb) {
        if ("DATE".equals(col.originalSQLType) || "DATETIME".equals(col.originalSQLType)) {
            return col.timestampNoTzAsDate ? eb.cast(Type.DATE) : eb.cast(Type.STRING);
        }
        if ("TIME".equals(col.originalSQLType) || "INTERVAL".equals(col.originalSQLType)) {
            return eb.cast(Type.STRING);
        }
        if ("GEOGRAPHY".equals(col.originalSQLType)) {
            return eb.stAsText();
        }
        if ("BYTES".equals(col.originalSQLType)) {
            return eb.toBase64();
        }
        if ("JSON".equals(col.originalSQLType)) {
            return eb.toJsonString();
        }
        return eb;
    }

    @Override
    public String quoteString(String str) {
        String strValue = str.replaceAll("\\\\", "\\\\\\\\").replaceAll(SIMPLE_QUOTE, "\\\\'").replaceAll("\\?", "\\\\?").replaceAll("`", "\\\\`");
        if (str.contains("\n")) {
            return TRIPLE_QUOTE + strValue + TRIPLE_QUOTE;
        }
        return SIMPLE_QUOTE + strValue + SIMPLE_QUOTE;
    }

    @Override
    public boolean needsBackslashDoubling() {
        return true;
    }

    @Override
    public String getQuotedTableFullName(String catalog, String schema, String table) {
        if (StringUtils.isBlank((String)catalog)) {
            if (StringUtils.isBlank((String)schema)) {
                return this.quoteIdentifier(table);
            }
            return this.quoteIdentifier(schema + "." + table);
        }
        if (StringUtils.isBlank((String)schema)) {
            throw new IllegalArgumentException("BigQuery dataset (aka schema) cannot be empty when BigQuery project (aka catalog) is specified");
        }
        return this.quoteIdentifier(catalog + "." + schema + "." + table);
    }

    public String getQuotedTableFullName(BigQueryClient.TableRef table) {
        return this.getQuotedTableFullName(table.projectId, table.datasetId, table.tableId);
    }

    @Override
    public String getInsertIntoInstruction(String catalog, String schema, String tableName, com.dataiku.dip.coremodel.Schema tableSchema) {
        String columnNames = Joiner.on((String)", ").join((Iterable)tableSchema.columns.stream().map(input -> this.quoteIdentifier(input.getName())).collect(Collectors.toList()));
        return "INSERT " + this.getQuotedTableFullName(catalog, schema, tableName) + " (" + columnNames + ")";
    }

    @Override
    public String getCreateViewInstruction(String catalog, String schema, String tableName) {
        return "CREATE OR REPLACE VIEW " + this.getQuotedTableFullName(catalog, schema, tableName) + " AS ";
    }

    @Override
    public String getDropViewInstruction(String catalog, String schema, String tableName) {
        return "DROP VIEW IF EXISTS " + this.getQuotedTableFullName(catalog, schema, tableName);
    }

    @Override
    public boolean requireDirectSchemaRetrieval(ResultSetMetaData resultSetMetaData) throws SQLException {
        if (!BigQuerySchemaHandler.HIERARCHICAL_ENABLED) {
            return false;
        }
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            String columnTypeName = resultSetMetaData.getColumnTypeName(i);
            if (!"ARRAY".equals(columnTypeName) && !"STRUCT".equals(columnTypeName) && !"RECORD".equals(columnTypeName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean requiresStrictTypeComparison() {
        return true;
    }

    @Override
    public boolean supportsDirectSchemaRetrieval() {
        return BigQuerySchemaHandler.HIERARCHICAL_ENABLED;
    }

    @Override
    public String cleanupColumnName(String columnName) {
        return super.cleanupColumnName(columnName);
    }

    @Override
    public com.dataiku.dip.coremodel.Schema directRetrieveSchema(ResultSetMetaData resultSetMetaData, SchemaOptions options) throws IOException {
        if (resultSetMetaData instanceof BigQueryResultSetMetadata) {
            Schema bqSchema = ((BigQueryResultSetMetadata)resultSetMetaData).getSchema();
            return BigQuerySchemaHandler.createDSSSchemaFromBigQuerySchema(bqSchema, options);
        }
        return null;
    }

    @Override
    public com.dataiku.dip.coremodel.Schema directRetrieveSchema(AuthCtx authCtx, AbstractSQLConnection conn, String catalog, String schema, String table, SchemaOptions options) throws IOException, DKUSecurityException, SQLException {
        TableResource tableResource = BigQuerySQLDialect.getTableResource(authCtx, (BigQueryConnection)conn, catalog, schema, table);
        return BigQuerySchemaHandler.createDSSSchemaFromBigQuerySchema(tableResource.schema, options);
    }

    @Override
    public com.dataiku.dip.coremodel.Schema directRetrieveSchema(AuthCtx authCtx, AbstractSQLConnection conn, String query, SchemaOptions options) throws IOException, DKUSecurityException, SQLException {
        BigQueryClient restClient = ((BigQueryConnection)conn).getRestClient(authCtx);
        try {
            JobResource job = restClient.executeSelectQueryAsync(null, query, null, true);
            job = restClient.waitForJobCompletion(job, TimeUnit.MINUTES, 2L);
            if (job.statistics != null && job.statistics.query != null && job.statistics.query.schema != null) {
                return BigQuerySchemaHandler.createDSSSchemaFromBigQuerySchema(job.statistics.query.schema, options);
            }
            logger.warn((Object)("Unable to retrieve schema of query. Formatting of nested and repeated fields will not be supported. Returned Job statistics: " + String.valueOf(job.statistics)));
            return null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Thread interrupted while waiting for BigQuery job completion", e);
        }
    }

    @Override
    public boolean supportsTablePartitionInfoRetrieval() {
        return true;
    }

    @Override
    public SchemaReader.TablePartitionInfo retrieveTablePartitionInfo(AuthCtx authCtx, AbstractSQLConnection conn, String catalog, String schema, String table) throws IOException, DKUSecurityException, SQLException {
        TableResource tableResource = BigQuerySQLDialect.getTableResource(authCtx, (BigQueryConnection)conn, catalog, schema, table);
        SchemaReader.TablePartitionInfo partitionInfo = new SchemaReader.TablePartitionInfo();
        if (tableResource.rangePartitioning != null) {
            RangePartitioning rangePartitioning = tableResource.rangePartitioning;
            ExactValueDimension evd = new ExactValueDimension(rangePartitioning.field);
            partitionInfo.dimension = evd;
            try {
                evd.integerRangeInfo = new ExactValueDimension.DimensionIntegerRangeInfo(Long.parseLong(rangePartitioning.range.start), Long.parseLong(rangePartitioning.range.end), Long.parseLong(rangePartitioning.range.interval));
            }
            catch (Exception e) {
                logger.warn((Object)("Could not construct integerRangeInfo for table " + table), (Throwable)e);
            }
        } else if (tableResource.timePartitioning != null) {
            TimePartitioning timePartitioning = tableResource.timePartitioning;
            if (StringUtils.isNotBlank((String)timePartitioning.field)) {
                partitionInfo.dimension = new TimeDimension(timePartitioning.field, TimeDimension.Period.parse((String)timePartitioning.type));
            } else {
                logger.info((Object)"Table is probably partitioned on pseudo column '_PARTITIONTIME', which is not automatically handled in DSS");
            }
        }
        return partitionInfo;
    }

    private static TableResource getTableResource(AuthCtx authCtx, BigQueryConnection conn, String catalog, String schema, String table) throws DKUSecurityException, IOException, SQLException {
        BigQueryClient restClient = conn.getRestClient(authCtx);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)schema), (Object)"BigQuery dataset Id cannot be empty or null.");
        BigQueryClient.DatasetRef datasetRef = new BigQueryClient.DatasetRef(catalog, schema);
        BigQueryClient.TableRef tableRef = new BigQueryClient.TableRef(datasetRef, table);
        return restClient.getTable(tableRef);
    }

    public String performRegexReplacementForCreatingAView(AuthCtx authCtx, String sql, String schemaName, SQLConnectionProvider.BigQuerySQLConnectionData connectionData) throws DKUSecurityException, IOException, SQLException {
        if (StringUtils.isBlank((String)schemaName)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_MISSING_SCHEMA, MISSING_SCHEMA_ERROR);
        }
        return this.performRegexReplacementForCreatingAView(authCtx, sql, (List<String>)ImmutableList.of((Object)schemaName), connectionData);
    }

    public String performRegexReplacementForCreatingAView(AuthCtx authCtx, String sql, List<String> schemaNames, SQLConnectionProvider.BigQuerySQLConnectionData connectionData) throws DKUSecurityException, IOException, SQLException {
        if (schemaNames.isEmpty()) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_MISSING_SCHEMA, MISSING_SCHEMA_ERROR);
        }
        String projectId = connectionData.getRestClient(authCtx).getProjectId();
        return sql.replaceAll(SINGLE_SPACE + String.format(TABLE_OR_VIEW_REFERENCE_REGEX, OR_JOINER.join(schemaNames)) + WHITE_SPACE_OR_END_OF_STRING_REGEX, SINGLE_SPACE + this.quoteIdentifier(projectId) + ".$1$2");
    }

    @Override
    public boolean requiresColumnNamesInCTEs() {
        return false;
    }

    @Override
    public boolean supportsIndexing() {
        return false;
    }

    @Override
    public boolean supportsIndexingOnTemporaryTables() {
        return false;
    }

    @Override
    public boolean isCatalogAware() {
        return true;
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return -1;
    }

    @Override
    public int getIdentifiersMaxLength() {
        return 128;
    }

    @Override
    public boolean supportsCommitAndRollback() {
        return false;
    }

    @Override
    public boolean supportsNullsOrdering() {
        return false;
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.NestedMultiLineCommentFinder.META, QuotedPortionFinders.PostgresStringLiteralFinder.META, QuotedPortionFinders.DoubleQuotedNoEscapeFinder.META, QuotedPortionFinders.EscapedStringLiteralFinder.META, QuotedPortionFinders.PostgresDollarQuotedLiteralFinder.META};
    }

    @Override
    @Deprecated
    public String convertToVarchar(String inputExpr, int len) {
        return "CAST((" + inputExpr + ") AS STRING)";
    }

    @Override
    @Deprecated
    public String convertStringToNumber(String inputExpr) {
        return "CAST((" + inputExpr + ") AS FLOAT64)";
    }

    @Override
    public String datePartExpression(String inputDateExpression, DatePart part) {
        switch (part) {
            case DAY_OF_MONTH: {
                return "EXTRACT(DAY FROM " + inputDateExpression + ")";
            }
            case HOUR_OF_DAY: {
                return "EXTRACT(HOUR FROM " + inputDateExpression + ")";
            }
            case MINUTE_OF_HOUR: {
                return "EXTRACT(MINUTE FROM " + inputDateExpression + ")";
            }
            case SECOND_OF_MINUTE: {
                return "EXTRACT(SECOND FROM " + inputDateExpression + ")";
            }
            case MILLISECOND_OF_SECOND: {
                return "EXTRACT(MILLISECOND FROM " + inputDateExpression + ")";
            }
            case MONTH_OF_YEAR: {
                return "EXTRACT(MONTH FROM " + inputDateExpression + ")";
            }
            case WEEK_OF_YEAR: {
                return "EXTRACT(ISOWEEK FROM " + inputDateExpression + ")";
            }
            case QUARTER_OF_YEAR: {
                return "EXTRACT(QUARTER FROM " + inputDateExpression + ")";
            }
            case YEAR: {
                return "EXTRACT(YEAR FROM " + inputDateExpression + ")";
            }
            case DAY_OF_WEEK: {
                return "(1 + MOD(EXTRACT(DAYOFWEEK FROM " + inputDateExpression + ") + 5, 7))";
            }
            case SECOND_FROM_EPOCH: {
                return "UNIX_SECONDS(" + inputDateExpression + ")";
            }
            case MILLIS_FROM_EPOCH: {
                return "UNIX_MILLIS(" + inputDateExpression + ")";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on BigQuery", part));
    }

    @Override
    public String dateonlyPartExpression(String inputDateExpression, DatePart part) {
        switch (part) {
            case DAY_OF_MONTH: {
                return "EXTRACT(DAY FROM " + inputDateExpression + ")";
            }
            case MONTH_OF_YEAR: {
                return "EXTRACT(MONTH FROM " + inputDateExpression + ")";
            }
            case WEEK_OF_YEAR: {
                return "EXTRACT(ISOWEEK FROM " + inputDateExpression + ")";
            }
            case QUARTER_OF_YEAR: {
                return "EXTRACT(QUARTER FROM " + inputDateExpression + ")";
            }
            case YEAR: {
                return "EXTRACT(YEAR FROM " + inputDateExpression + ")";
            }
            case DAY_OF_WEEK: {
                return "(1 + MOD(EXTRACT(DAYOFWEEK FROM " + inputDateExpression + ") + 5, 7))";
            }
            case SECOND_FROM_EPOCH: {
                return "(UNIX_DATE(" + inputDateExpression + ") * 86400)";
            }
            case MILLIS_FROM_EPOCH: {
                return "(UNIX_DATE(" + inputDateExpression + ") * 86400000)";
            }
            case HOUR_OF_DAY: 
            case MINUTE_OF_HOUR: 
            case SECOND_OF_MINUTE: 
            case MILLISECOND_OF_SECOND: {
                throw new UnsupportedOperationException("Can't extract time information from a date");
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on BigQuery", part));
    }

    @Override
    public String datetimenotzPartExpression(String inputDateExpression, DatePart part) {
        switch (part) {
            case DAY_OF_MONTH: {
                return "EXTRACT(DAY FROM " + inputDateExpression + ")";
            }
            case HOUR_OF_DAY: {
                return "EXTRACT(HOUR FROM " + inputDateExpression + ")";
            }
            case MINUTE_OF_HOUR: {
                return "EXTRACT(MINUTE FROM " + inputDateExpression + ")";
            }
            case SECOND_OF_MINUTE: {
                return "EXTRACT(SECOND FROM " + inputDateExpression + ")";
            }
            case MILLISECOND_OF_SECOND: {
                return "EXTRACT(MILLISECOND FROM " + inputDateExpression + ")";
            }
            case MONTH_OF_YEAR: {
                return "EXTRACT(MONTH FROM " + inputDateExpression + ")";
            }
            case WEEK_OF_YEAR: {
                return "EXTRACT(ISOWEEK FROM " + inputDateExpression + ")";
            }
            case QUARTER_OF_YEAR: {
                return "EXTRACT(QUARTER FROM " + inputDateExpression + ")";
            }
            case YEAR: {
                return "EXTRACT(YEAR FROM " + inputDateExpression + ")";
            }
            case DAY_OF_WEEK: {
                return "(1 + MOD(EXTRACT(DAYOFWEEK FROM " + inputDateExpression + ") + 5, 7))";
            }
            case SECOND_FROM_EPOCH: {
                return "UNIX_SECONDS(CAST(" + inputDateExpression + " AS TIMESTAMP))";
            }
            case MILLIS_FROM_EPOCH: {
                return "UNIX_MILLIS(CAST(" + inputDateExpression + " AS TIMESTAMP))";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on BigQuery", part));
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        switch (rounding) {
            case DAY: {
                return "TIMESTAMP_TRUNC(" + inputDateExpression + ", DAY)";
            }
            case HOUR: {
                return "TIMESTAMP_TRUNC(" + inputDateExpression + ", HOUR)";
            }
            case WEEK: {
                return "TIMESTAMP_TRUNC(" + inputDateExpression + ", ISOWEEK)";
            }
            case MONTH: {
                return "TIMESTAMP_TRUNC(" + inputDateExpression + ", MONTH)";
            }
            case YEAR: {
                return "TIMESTAMP_TRUNC(" + inputDateExpression + ", YEAR)";
            }
            case QUARTER: {
                return "TIMESTAMP_TRUNC(" + inputDateExpression + ", QUARTER)";
            }
            case MINUTE: {
                return "TIMESTAMP_TRUNC(" + inputDateExpression + ", MINUTE)";
            }
            case SECOND: {
                return "TIMESTAMP_TRUNC(" + inputDateExpression + ", SECOND)";
            }
        }
        throw new NotImplementedException("Rounding mode not implemented for BigQuery:" + String.valueOf(rounding));
    }

    @Override
    public String dateonlyTrunc(String inputDateExpression, DateRounding rounding) {
        switch (rounding) {
            case DAY: {
                return "DATE_TRUNC(" + inputDateExpression + ", DAY)";
            }
            case WEEK: {
                return "DATE_TRUNC(" + inputDateExpression + ", ISOWEEK)";
            }
            case MONTH: {
                return "DATE_TRUNC(" + inputDateExpression + ", MONTH)";
            }
            case YEAR: {
                return "DATE_TRUNC(" + inputDateExpression + ", YEAR)";
            }
            case QUARTER: {
                return "DATE_TRUNC(" + inputDateExpression + ", QUARTER)";
            }
        }
        throw new NotImplementedException("Rounding mode not implemented for BigQuery:" + String.valueOf(rounding));
    }

    @Override
    public String datetimenotzTrunc(String inputDateExpression, DateRounding rounding) {
        switch (rounding) {
            case DAY: {
                return "DATETIME_TRUNC(" + inputDateExpression + ", DAY)";
            }
            case HOUR: {
                return "DATETIME_TRUNC(" + inputDateExpression + ", HOUR)";
            }
            case WEEK: {
                return "DATETIME_TRUNC(" + inputDateExpression + ", ISOWEEK)";
            }
            case MONTH: {
                return "DATETIME_TRUNC(" + inputDateExpression + ", MONTH)";
            }
            case YEAR: {
                return "DATETIME_TRUNC(" + inputDateExpression + ", YEAR)";
            }
            case QUARTER: {
                return "DATETIME_TRUNC(" + inputDateExpression + ", QUARTER)";
            }
            case MINUTE: {
                return "DATETIME_TRUNC(" + inputDateExpression + ", MINUTE)";
            }
            case SECOND: {
                return "DATETIME_TRUNC(" + inputDateExpression + ", SECOND)";
            }
        }
        throw new NotImplementedException("Rounding mode not implemented for BigQuery:" + String.valueOf(rounding));
    }

    @Override
    public boolean supportsWindowTimeRangeFrame() {
        return false;
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return true;
    }

    @Override
    public String getLimitedQuery(String query, long size) {
        return this.getLimitedQueryUsingLimit(query, size);
    }

    @Override
    public String getLimitedQuery(String query, long size, long offset) {
        return this.getLimitedQueryUsingLimitFromLimitString(query, size + " OFFSET " + offset);
    }

    @Override
    public boolean tableExists(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, String catalog, String schema, String table, String projectKey) throws Exception {
        String datasetId = this.getSafeDatasetId(schema);
        String tableId = this.getSafeTableId(table);
        return this.restClient(authCtx, connData).hasTable(new BigQueryClient.TableRef(catalog, datasetId, tableId));
    }

    @Override
    public void dropTable(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, SQLUtils.SQLTable table) throws Exception {
        String projectId = table.getCatalog();
        String datasetId = this.getSafeDatasetId(table.getSchemaNullIfBlank());
        String tableId = this.getSafeTableId(table.getTable());
        this.restClient(authCtx, connData).deleteTableIfExist(new BigQueryClient.TableRef(projectId, datasetId, tableId));
    }

    @Override
    public String generateTableStatementSQL(AbstractSQLConnection connection, Dataset dataset, InfoMessage.InfoMessages messages, boolean ifNotExist) {
        BigQueryDatasetConfig config = dataset.getParamsAs(BigQueryDatasetConfig.class);
        config = (BigQueryDatasetConfig)config.getResolved(dataset.getProjectKey());
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        if (ifNotExist) {
            sb.append("IF NOT EXISTS ");
        }
        sb.append(this.getQuotedTableFullName(config.catalog, config.schema, config.table));
        sb.append(" (\n");
        sb.append(this.getCreateTableFieldsSQL(dataset, messages));
        sb.append(")");
        if (config.useBigQueryPartitioning) {
            if (StringUtils.isEmpty((String)config.bigQueryPartitioningField)) {
                throw new IllegalArgumentException("Cannot create partitioned BigQuery table because the partition column name is empty.");
            }
            sb.append(String.format("\n  PARTITION BY %s", switch (config.bigQueryPartitioningType) {
                case BigQueryDatasetConfig.PartitioningType.DATE -> this.createDatePartitioningExpression(dataset, config);
                case BigQueryDatasetConfig.PartitioningType.RANGE -> {
                    if (config.bigQueryPartitioningRangeEnd <= config.bigQueryPartitioningRangeStart) {
                        throw new IllegalArgumentException("Cannot create partitioned BigQuery table because the range end is equal or smaller than the start.");
                    }
                    if (config.bigQueryPartitioningRangeInterval <= 0L) {
                        throw new IllegalArgumentException("Cannot create partitioned BigQuery table because the range interval is not a positive integer: " + config.bigQueryPartitioningRangeInterval);
                    }
                    yield String.format("RANGE_BUCKET(%s, GENERATE_ARRAY(%d, %d, %d))", this.quoteIdentifier(config.bigQueryPartitioningField), config.bigQueryPartitioningRangeStart, config.bigQueryPartitioningRangeEnd, config.bigQueryPartitioningRangeInterval);
                }
                default -> throw new IllegalStateException("Unhandled partitionType: " + String.valueOf((Object)config.bigQueryPartitioningType));
            }));
        }
        if (config.bigQueryClusteringColumns != null && !config.bigQueryClusteringColumns.isEmpty()) {
            String clusteringColumnsList = config.bigQueryClusteringColumns.stream().map(c2 -> this.quoteIdentifier(c2.name)).collect(Collectors.joining(", "));
            sb.append(String.format("\n  CLUSTER BY %s", clusteringColumnsList));
        }
        this.addTableOptions(sb, (BigQueryConnection)connection, dataset, messages);
        return sb.toString();
    }

    private String createDatePartitioningExpression(Dataset dataset, BigQueryDatasetConfig config) {
        SchemaColumn dateCol = dataset.getSchema().getColumn(config.bigQueryPartitioningField);
        if (dateCol == null) {
            throw new IllegalStateException("BigQuery dataset is partitioned by " + config.bigQueryPartitioningField + " but the column doesn't exist in the schema");
        }
        Field field = BigQuerySchemaHandler.createBigQueryField(dateCol, false, false);
        String type = field.type != null ? field.type.toUpperCase(Locale.ROOT) : "null";
        String partitioningFieldQuoted = this.quoteIdentifier(config.bigQueryPartitioningField);
        return switch (type) {
            case "DATE" -> {
                switch (config.bigQueryPartitioningPeriod) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case YEAR: 
                    case MONTH: {
                        yield String.format("DATE_TRUNC(%s, %s)", new Object[]{partitioningFieldQuoted, config.bigQueryPartitioningPeriod});
                    }
                    case DAY: {
                        yield partitioningFieldQuoted;
                    }
                    case HOUR: 
                }
                throw new IllegalStateException("BigQuery dataset is partitioned by HOUR with column " + config.bigQueryPartitioningField + " but the type of this column is \"date only\" (which corresponds to the BigQuery type DATE). Either partition this dataset by YEAR, MONTH or DAY or use a partitioning column of type \"datetime with tz\" or \"datetime no tz\"");
            }
            case "DATETIME" -> String.format("DATETIME_TRUNC(%s, %s)", new Object[]{partitioningFieldQuoted, config.bigQueryPartitioningPeriod});
            case "TIMESTAMP" -> String.format("TIMESTAMP_TRUNC(%s, %s)", new Object[]{partitioningFieldQuoted, config.bigQueryPartitioningPeriod});
            default -> throw new IllegalStateException("BigQuery dataset is partitioned by " + String.valueOf((Object)config.bigQueryPartitioningPeriod) + " with column " + config.bigQueryPartitioningField + " but the type of this column is \"" + dateCol.getType().getName() + "\" (which corresponds to the BigQuery type " + type + ").");
        };
    }

    private void addTableOptions(StringBuilder sb, BigQueryConnection connection, Dataset dataset, InfoMessage.InfoMessages messages) {
        boolean hasOptions;
        AbstractSQLDatasetHandler.AbstractSQLConfig config = (AbstractSQLDatasetHandler.AbstractSQLConfig)dataset.getParams();
        BigQueryDatasetConfig bqConfig = (BigQueryDatasetConfig)config;
        EncryptionConfiguration encryptionConfiguration = connection.getEncryptionConfiguration();
        BigQueryConnection.Params connectionParams = connection.params;
        boolean bl = hasOptions = encryptionConfiguration != null || config.writeDescriptionsAsSQLComment && dataset.getModel().description != null || bqConfig.requireBQPartitionFilter(connectionParams);
        if (hasOptions) {
            sb.append("\n  OPTIONS(");
            StringJoiner joiner = new StringJoiner(", ");
            if (encryptionConfiguration != null) {
                joiner.add(String.format("kms_key_name=%s", this.quoteString(encryptionConfiguration.kmsKeyName)));
            }
            if (config.writeDescriptionsAsSQLComment && dataset.getModel().description != null) {
                joiner.add(String.format("description=%s", this.quoteString(this.truncateDescription(dataset.getModel().description, dataset.getName(), true, messages))));
            }
            if (bqConfig.requireBQPartitionFilter(connectionParams)) {
                joiner.add("require_partition_filter=TRUE");
            }
            sb.append(joiner);
            sb.append(")");
        }
    }

    @Override
    protected String getCreateTableFieldsSQL(Dataset dataset, InfoMessage.InfoMessages messages) {
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (SchemaColumn col : dataset.getSchema().getColumns()) {
            Field field = BigQuerySchemaHandler.createBigQueryField(col, false, false);
            sb.append("\t");
            sb.append(this.quoteIdentifier(col.getName()));
            sb.append(SINGLE_SPACE);
            sb.append(field.toSQLTypeString(false));
            if (config.writeDescriptionsAsSQLComment && StringUtils.isNotBlank((String)field.description)) {
                sb.append(String.format(" OPTIONS(description=%s)", this.quoteString(this.truncateDescription(field.description, col.getName(), false, messages))));
            }
            if (i < dataset.getSchema().getColumns().size() - 1) {
                sb.append(",");
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    @Override
    protected boolean shouldUseTruncate(SQLConnectionProvider.SQLConnectionData connData) {
        return false;
    }

    @Override
    protected boolean reallyNeedsDeleteBeforePartitionedWrite(SQLConnectionProvider.SQLConnectionWrapper conn, String tableFullName, Dataset dataset, Partition partition) throws SQLException {
        ExpressionBuilder clause = ExpressionUtils.getPartitionFilterClause(dataset.getPartitioningSchema(), dataset, partition, (SQLDialect)this);
        String checkSQL = String.format("SELECT count(1) as `cnt` FROM %s WHERE %s", tableFullName, clause.toSQL(this));
        try (Statement statement = conn.createStatement();){
            boolean bl;
            block16: {
                ResultSet resultSet;
                block14: {
                    boolean bl2;
                    block15: {
                        resultSet = statement.executeQuery(checkSQL);
                        try {
                            if (resultSet.next()) break block14;
                            bl2 = false;
                            if (resultSet == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return bl2;
                }
                long n = resultSet.getLong("cnt");
                boolean bl3 = bl = n > 0L;
                if (resultSet == null) break block16;
                resultSet.close();
            }
            return bl;
        }
    }

    @Override
    public SQLDialect.InsertIntoCaster getInsertIntoCaster(final @Nullable Dataset dataset) {
        Map<Object, Object> columnSqlDatatypes;
        if (dataset == null) {
            return new SQLDialect.InsertIntoCaster(){

                @Override
                public ExpressionBuilder castIfNeeded(ExpressionBuilder value, SchemaColumn output) {
                    return value;
                }
            };
        }
        if (!(dataset.getParams() instanceof BigQueryDatasetConfig)) {
            return new SQLDialect.InsertIntoCaster(){

                @Override
                public ExpressionBuilder castIfNeeded(ExpressionBuilder value, SchemaColumn output) {
                    return value;
                }
            };
        }
        if (dataset.isManaged()) {
            BigQueryDatasetConfig config = dataset.getParamsAs(BigQueryDatasetConfig.class);
            columnSqlDatatypes = "custom".equals(config.tableCreationMode) ? new BigQueryCreateTableParser(config.customCreateStatement).getFieldTypes() : new HashMap();
        } else {
            columnSqlDatatypes = new HashMap();
        }
        return new SQLDialect.InsertIntoCaster(){

            @Override
            public ExpressionBuilder castIfNeeded(ExpressionBuilder value, SchemaColumn output) {
                if (output == null) {
                    return value;
                }
                String sqlDatatype = (String)columnSqlDatatypes.get(output.getName());
                if (StringUtils.isEmpty((String)sqlDatatype)) {
                    return value;
                }
                if ("bool".equalsIgnoreCase(sqlDatatype)) {
                    sqlDatatype = "boolean";
                }
                DSSTypeSQLMapping typeMapping = BigQuerySQLDialect.this.getSQLType(output, dataset);
                if (typeMapping.sqlDecl.equalsIgnoreCase(sqlDatatype)) {
                    return value;
                }
                if (sqlDatatype.indexOf(40) > 0) {
                    sqlDatatype = sqlDatatype.substring(0, sqlDatatype.indexOf(40));
                }
                return value.cast(null, null, sqlDatatype);
            }
        };
    }

    @Override
    public String extractStatistics(ResultSet resultSet) {
        if (resultSet instanceof BigQueryResultSet) {
            JobStatistics.QueryStatistics queryStatistics = ((BigQueryResultSet)resultSet).getExecutionInfo().queryStatistics;
            ArrayList<CallSite> statistics = new ArrayList<CallSite>();
            if (queryStatistics != null) {
                long partitions;
                if (queryStatistics.getTotalBytesProcessed() != null) {
                    long processed = queryStatistics.getTotalBytesProcessed();
                    if (queryStatistics.getTotalBytesBilled() != null) {
                        long billed = queryStatistics.getTotalBytesBilled();
                        if (billed == processed) {
                            statistics.add((CallSite)((Object)(DKUNumberUtils.printSmartBytesSize(processed) + " processed and billed")));
                        } else {
                            statistics.add((CallSite)((Object)(DKUNumberUtils.printSmartBytesSize(processed) + " processed")));
                            statistics.add((CallSite)((Object)(DKUNumberUtils.printSmartBytesSize(billed) + " billed")));
                        }
                    } else {
                        statistics.add((CallSite)((Object)(DKUNumberUtils.printSmartBytesSize(processed) + " processed")));
                    }
                }
                if (queryStatistics.getTotalSlotMs() != null) {
                    statistics.add((CallSite)((Object)(new DecimalFormat("#.###").format((double)queryStatistics.getTotalSlotMs().longValue() / 1000.0) + " sec slot time consumed")));
                }
                if (queryStatistics.getTotalPartitionsProcessed() != null && (partitions = queryStatistics.getTotalPartitionsProcessed().longValue()) > 0L) {
                    statistics.add((CallSite)((Object)(partitions + " partition" + (partitions == 1L ? "" : "s") + " processed")));
                }
            }
            return statistics.isEmpty() ? null : Joiner.on((String)", ").join(statistics);
        }
        return null;
    }

    @Override
    public Map<SQLAggregateType, SQLAggregateAbility> getAggregationAbilities() {
        Map<SQLAggregateType, SQLAggregateAbility> abilities = super.getAggregationAbilities();
        abilities.put(SQLAggregateType.CONCAT, new SQLAggregateAbility(true, true, true, true));
        abilities.put(SQLAggregateType.CONCAT_DISTINCT, new SQLAggregateAbility(true, true, true, true));
        abilities.put(SQLAggregateType.LAG_DIFF, new SQLAggregateAbility(false, false, true, false));
        abilities.put(SQLAggregateType.LEAD_DIFF, new SQLAggregateAbility(false, false, true, false));
        return abilities;
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.NULL, QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs < 3;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                if (args.length == 0) {
                    return "NULL";
                }
                Type type = this.getParamAs(args[0], Type.class);
                Integer maxLength = this.getParamAs(args[1], Integer.class);
                return BigQuerySQLDialect.this.cast("NULL", null, type, maxLength);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.SHA256, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                return "TO_HEX(SHA256(" + column + "))";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.SHA512, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                return "TO_HEX(SHA512(" + column + "))";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.MD5, "MD5", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                return "TO_HEX(MD5(" + this.toSQLNoBrackets(args[0]) + "))";
            }
        });
        this.addQueryOperator(QueryUtils.OperatorType.UNION, "UNION DISTINCT", QueryUtils.Arity.NARY, GenericSQLDialect.SQLPriority.UNION.priority);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.AGG_CONCAT, "STRING_AGG", QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 1);
                String column = this.toSQLNoBrackets(args[0]);
                String separator = null;
                boolean distinct = false;
                if (args.length > 1) {
                    QueryAst.ConstExpr separatorExpr = (QueryAst.ConstExpr)args[1];
                    String string = separator = separatorExpr == null ? null : this.toSQLNoBrackets(separatorExpr);
                }
                if (args.length > 2) {
                    QueryAst.ConstExpr distinctExpr = (QueryAst.ConstExpr)args[2];
                    distinct = distinctExpr != null && (Boolean)distinctExpr.value != false;
                }
                StringBuilder result = new StringBuilder("STRING_AGG(");
                if (distinct) {
                    result.append("DISTINCT ");
                }
                result.append("CAST(").append(column).append(" AS STRING)");
                if (separator != null) {
                    result.append(", ").append(separator);
                }
                result.append(")");
                return result.toString();
            }
        });
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(this, QueryUtils.OperatorType.STRING_TO_TIMESTAMPTZ, "CAST(", " AS TIMESTAMP)"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(this, QueryUtils.OperatorType.STRING_TO_DATE, "CAST(", " AS DATE)"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(this, QueryUtils.OperatorType.STRING_TO_TIMESTAMP, "CAST(", " AS DATETIME)"));
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FROM_TIMEZONE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 1);
                if (args.length > 2 && args[2] != null) {
                    return "TIMESTAMP(DATETIME(" + this.toSQLNoBrackets(args[0]) + ", " + this.toSQLNoBrackets(args[1]) + "), " + this.toSQLNoBrackets(args[2]) + ")";
                }
                if (args.length > 1 && args[1] != null) {
                    return "TIMESTAMP(DATETIME(" + this.toSQLNoBrackets(args[0]) + "), " + this.toSQLNoBrackets(args[1]) + ")";
                }
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATE_ADD, QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                Type dssType;
                this.validateNumberOfParameters(args);
                String datetimeNoTz = this.toSQLNoBrackets(args[0]);
                String addIntLong = "CAST((" + this.toSQLNoBrackets(args[1]) + ") AS INT64)";
                String unit = this.getParamAs(args[2], String.class);
                Type type = dssType = args[0].outputType != null ? args[0].outputType.dssType : null;
                if (dssType == null) {
                    dssType = Type.DATE;
                }
                if ("YEAR".equalsIgnoreCase(unit) || "MONTH".equalsIgnoreCase(unit) || "WEEK".equalsIgnoreCase(unit) || "DAY".equalsIgnoreCase(unit)) {
                    if (dssType == Type.DATEONLY) {
                        return "DATE_ADD(" + datetimeNoTz + ", INTERVAL " + addIntLong + BigQuerySQLDialect.SINGLE_SPACE + unit + ")";
                    }
                    if (dssType == Type.DATETIMENOTZ) {
                        return "DATETIME_ADD(" + datetimeNoTz + ", INTERVAL " + addIntLong + BigQuerySQLDialect.SINGLE_SPACE + unit + ")";
                    }
                    return "TIMESTAMP(DATETIME_ADD(DATETIME(" + datetimeNoTz + "), INTERVAL " + addIntLong + BigQuerySQLDialect.SINGLE_SPACE + unit + "))";
                }
                if (dssType == Type.DATEONLY) {
                    return "TIMESTAMP_ADD(TIMESTAMP(" + datetimeNoTz + "), INTERVAL " + addIntLong + BigQuerySQLDialect.SINGLE_SPACE + unit + ")";
                }
                if (dssType == Type.DATETIMENOTZ) {
                    return "DATETIME_ADD(" + datetimeNoTz + ", INTERVAL " + addIntLong + BigQuerySQLDialect.SINGLE_SPACE + unit + ")";
                }
                return "TIMESTAMP_ADD(" + datetimeNoTz + ", INTERVAL " + addIntLong + BigQuerySQLDialect.SINGLE_SPACE + unit + ")";
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.DATEDIFF, null, QueryUtils.Arity.NARY, GenericSQLDialect.SQLPriority.PLUS.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 3);
                String end = this.toSQLNoBrackets(args[0]);
                String start = this.toSQLNoBrackets(args[1]);
                String unit = this.getParamAs(args[2], String.class);
                Type type = Type.DATE;
                if (args[0].outputType != null && args[0].outputType.dssType != null) {
                    type = args[0].outputType.dssType;
                }
                switch (unit) {
                    case "YEAR": {
                        return "DATETIME_DIFF(DATETIME(" + end + "), DATETIME(" + start + "),YEAR)";
                    }
                    case "MONTH": {
                        return "DATETIME_DIFF(DATETIME(" + end + "), DATETIME(" + start + "),MONTH)";
                    }
                    case "WEEK": {
                        return "DATETIME_DIFF(DATETIME(" + end + "), DATETIME(" + start + "),WEEK)";
                    }
                    case "DAY": {
                        if (type == Type.DATETIMENOTZ) {
                            return "TIMESTAMP_DIFF(TIMESTAMP(" + end + ", 'UTC'), TIMESTAMP(" + start + ", 'UTC'),DAY)";
                        }
                        return "TIMESTAMP_DIFF(" + end + ", " + start + ",DAY)";
                    }
                    case "HOUR": {
                        return "TIMESTAMP_DIFF(" + end + ", " + start + ",HOUR)";
                    }
                    case "MINUTE": {
                        return "TIMESTAMP_DIFF(" + end + ", " + start + ",MINUTE)";
                    }
                    case "SECOND": {
                        return "TIMESTAMP_DIFF(" + end + ", " + start + ",SECOND)";
                    }
                }
                throw new IllegalArgumentException("Unknown datepart: '" + unit + BigQuerySQLDialect.SIMPLE_QUOTE);
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.NOW, "CURRENT_TIMESTAMP", QueryUtils.Arity.NO_ARG);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_APPROX_AGG, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "APPROX_QUANTILES(" + column + ", 100)[OFFSET(" + (int)Math.floor(percentile * 100.0) + ")]";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEX_LIKE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String input = this.toSQLNoBrackets(args[0]);
                String regex = this.toSQLNoBrackets(args[1]);
                return "REGEXP_CONTAINS(" + input + ", " + regex + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PARSE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                Type requestedType;
                this.validateMinNumberOfParameters(args, 2);
                Object input = this.toSQLNoBrackets(args[0]);
                if (args[0].outputType != null && args[0].outputType.dssType != Type.STRING) {
                    input = "CAST(" + (String)input + " AS STRING)";
                }
                if ((requestedType = this.getParamAs(args[1], Type.class)).isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = BigQuerySQLDialect.this.toDateFormat(jodaFormat, true);
                    if (requestedType == Type.DATEONLY) {
                        return "PARSE_DATE('" + sqlFormat + "', " + (String)input + ")";
                    }
                    if (requestedType == Type.DATETIMENOTZ) {
                        return "PARSE_DATETIME('" + sqlFormat + "', " + (String)input + ")";
                    }
                    return "PARSE_TIMESTAMP('" + sqlFormat + "', " + (String)input + ", '" + timezoneId + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FORMAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = BigQuerySQLDialect.this.toDateFormat(jodaFormat, false);
                    if (requestedType == Type.DATEONLY) {
                        return "FORMAT_DATE('" + sqlFormat + "', " + input + ")";
                    }
                    if (requestedType == Type.DATETIMENOTZ) {
                        return "FORMAT_DATETIME('" + sqlFormat + "', " + input + ")";
                    }
                    return "FORMAT_TIMESTAMP('" + sqlFormat + "', " + input + ", '" + StringUtils.defaultIfBlank((String)timezoneId, (String)"UTC") + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.MOD, "%", QueryUtils.Arity.BINARY, 2){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String op1Expr = this.toSQLNoBrackets(args[0]);
                String op2Expr = this.toSQLNoBrackets(args[1]);
                return "MOD(" + op1Expr + "," + op2Expr + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.RAND, QueryUtils.Arity.ANY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs == 0 || nArgs == 2;
            }

            @Override
            public String apply(QueryAst.Expr[] args) throws QueryUtils.SQLGenerationException {
                this.validateNumberOfParameters(args);
                if (args == null || args.length == 0) {
                    return "RAND()";
                }
                if (args.length == 2) {
                    String min = "CAST(" + this.toSQLNoBrackets(args[0]) + " AS INT64)";
                    String max = "CAST(" + this.toSQLNoBrackets(args[1]) + " AS INT64)";
                    return String.format("%1$s + CAST(FLOOR(CAST(RAND() AS BIGNUMERIC) * CAST(%2$s - %1$s AS BIGNUMERIC)) AS INT64)", min, max);
                }
                return super.apply(args);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.JSON_ARRAY_SUM, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String input = this.toSQLNoBrackets(args[0]);
                Object query = "";
                if (!this.hasMultipleArgument(args)) {
                    query = (String)query + "CASE\n    WHEN SAFE_CAST({0} AS STRING) LIKE ''[%]'' THEN (\n      SELECT COALESCE(SUM(COALESCE(SAFE_CAST(TRIM(x,''\"'') AS FLOAT64),0)),0)\n      FROM UNNEST(\n        JSON_EXTRACT_ARRAY(SAFE_CAST({0} AS STRING))\n      ) AS x\n    )\n    ELSE\n";
                }
                query = (String)query + "    COALESCE(SAFE_CAST({0} AS FLOAT64),0)\n";
                if (!this.hasMultipleArgument(args)) {
                    query = (String)query + "  END";
                }
                return MessageFormat.format((String)query, input);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.JSON_ARRAY_COUNT, "COUNT", QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String input = this.toSQLNoBrackets(args[0]);
                Object query = "";
                if (!this.hasMultipleArgument(args)) {
                    query = (String)query + "CASE\n    WHEN SAFE_CAST({0} AS STRING) LIKE ''[%]'' THEN (\n      SELECT SUM(IF(SAFE_CAST(TRIM(x,''\"'') AS FLOAT64) IS NULL,0, 1))\n      FROM UNNEST(\n        JSON_EXTRACT_ARRAY(SAFE_CAST({0} AS STRING))\n      ) AS x\n    )\n    ELSE\n";
                }
                query = (String)query + "    IF(SAFE_CAST({0} AS FLOAT64) IS NULL,0, 1)\n";
                if (!this.hasMultipleArgument(args)) {
                    query = (String)query + "  END";
                }
                return MessageFormat.format((String)query, input);
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.ATAN2, "ATAN2", QueryUtils.Arity.BINARY);
        this.addGenericFunction(QueryUtils.OperatorType.COSH, "COSH", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.SINH, "SINH", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.TANH, "TANH", QueryUtils.Arity.UNARY);
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(this, QueryUtils.OperatorType.DEC2HEX, "FORMAT('%x', ", ")"));
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(this, QueryUtils.OperatorType.STARTS_WITH, "STARTS_WITH", false));
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(this, QueryUtils.OperatorType.ENDS_WITH, "ENDS_WITH", false));
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(this, QueryUtils.OperatorType.INDEX_OF, "(STRPOS(", ", COALESCE(", ", '')) - 1)", false));
        this.addGenericFunction(QueryUtils.OperatorType.REVERSE_STR, "REVERSE", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.ST_ASTEXT, "ST_ASTEXT", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.TO_BASE64, "TO_BASE64", QueryUtils.Arity.UNARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.TO_JSON_STRING, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String json_column = this.toSQLNoBrackets(args[0]);
                return "(IF(" + json_column + " IS NULL, \"\", TO_JSON_STRING(" + json_column + ")))";
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.CHAR, "CHR", QueryUtils.Arity.UNARY);
    }

    @Override
    public String createTemporaryTable(SQLUtils.SQLTable table, String columnListExpr) {
        return "CREATE TABLE " + this.getQuotedTableFullName(table) + " (" + columnListExpr + ") OPTIONS(" + BigQuerySQLDialect.temporaryTableOptions() + ")";
    }

    @Override
    public String[] createTemporaryTableAs(SQLUtils.SQLTable table, String selectExpr) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)table.getTable()), (Object)"tableName cannot be null or empty.");
        return new String[]{"CREATE TABLE " + this.getQuotedTableFullName(table) + " OPTIONS(" + BigQuerySQLDialect.temporaryTableOptions() + ") AS " + selectExpr};
    }

    @Override
    public String getId() {
        return "BigQuery";
    }

    private BigQueryClient restClient(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData) throws DKUSecurityException, IOException, SQLException {
        return ((SQLConnectionProvider.BigQuerySQLConnectionData)connData).getRestClient(authCtx);
    }

    private String getSafeTableId(String tableId) {
        if (StringUtils.isBlank((String)tableId)) {
            throw new IllegalStateException("No table name has been specified in the dataset settings.");
        }
        return tableId;
    }

    private String getSafeDatasetId(String datasetId) {
        if (StringUtils.isBlank((String)datasetId)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_MISSING_SCHEMA, "No Schema has been specified in the dataset settings. Schema is mandatory for BigQuery and corresponds to the BigQuery's dataset ID.");
        }
        return datasetId;
    }

    @Override
    public String toDateFormatPart(DKUDateUtils.FormatPatternPart part, boolean forParsing, boolean hasIsoDatePart) {
        switch (part.type) {
            case CENTURY: {
                return "%C";
            }
            case YEAR: 
            case YEAROFERA: {
                if (part.text.length() == 2) {
                    return "%y";
                }
                return "%Y";
            }
            case WEEKYEAR: {
                if (part.text.length() == 2) {
                    return "%g";
                }
                return "%G";
            }
            case MONTH: {
                if (part.numeric) {
                    return "%m";
                }
                if (part.shortened) {
                    return "%b";
                }
                return "%B";
            }
            case DAY: {
                if (part.text.length() == 1) {
                    return "%e";
                }
                return "%d";
            }
            case DAYOFYEAR: {
                return "%j";
            }
            case DAYOFWEEK: {
                if (part.numeric) {
                    return "%u";
                }
                if (part.shortened) {
                    return "%a";
                }
                return "%A";
            }
            case WEEK: {
                return "%V";
            }
            case HOUR: {
                if (part.text.length() == 1) {
                    return "%k";
                }
                return "%H";
            }
            case HALFDAY: {
                return "%p";
            }
            case HOUROFHALFDAY: {
                return "%l";
            }
            case MINUTE: {
                return "%M";
            }
            case SECOND: {
                return "%S";
            }
            case MILLISECOND: {
                throw new IllegalArgumentException("Cannot translate fractional seconds not in ss.SSS format");
            }
            case TIMEZONE: {
                if (part.numeric) {
                    return "%Ez";
                }
                return "%Z";
            }
            case TEXT: {
                return part.text.replace("%", "%%");
            }
        }
        return part.text;
    }

    @Override
    public SQLCapability canFormatDatePart(DKUDateUtils.FormatPatternPart part, boolean forParsing) {
        if (part.type == DKUDateUtils.FormatPatternPartType.MILLISECOND) {
            return SQLCapability.nok("Cannot handle fractional seconds");
        }
        return SQLCapability.ok();
    }

    @Override
    public String toDateFormat(String jodaFormat, boolean forParsing) {
        DKUDateUtils.FormatPattern jodaPattern = DKUDateUtils.parsePattern((String)jodaFormat, (boolean)forParsing);
        StringBuilder sb = new StringBuilder();
        boolean hasIsoDatePart = false;
        for (DKUDateUtils.FormatPatternPart part : jodaPattern) {
            hasIsoDatePart |= part.type == DKUDateUtils.FormatPatternPartType.WEEK;
            hasIsoDatePart |= part.type == DKUDateUtils.FormatPatternPartType.WEEKYEAR;
        }
        for (int i = 0; i < jodaPattern.size(); ++i) {
            DKUDateUtils.FormatPatternPart part;
            part = (DKUDateUtils.FormatPatternPart)jodaPattern.get(i);
            if (part.type == DKUDateUtils.FormatPatternPartType.SECOND && i + 2 < jodaPattern.size() && ((DKUDateUtils.FormatPatternPart)jodaPattern.get((int)(i + 1))).text.equals(".") && ((DKUDateUtils.FormatPatternPart)jodaPattern.get((int)(i + 2))).type == DKUDateUtils.FormatPatternPartType.MILLISECOND) {
                sb.append("%E").append(((DKUDateUtils.FormatPatternPart)jodaPattern.get((int)(i + 2))).text.length()).append("S");
                i += 2;
                continue;
            }
            sb.append(this.toDateFormatPart(part, forParsing, hasIsoDatePart));
        }
        return sb.toString();
    }

    @Override
    public SQLCapability canFormatDate(String jodaFormat, boolean forParsing) {
        DKUDateUtils.FormatPattern jodaPattern = DKUDateUtils.parsePattern((String)jodaFormat, (boolean)forParsing);
        for (int i = 0; i < jodaPattern.size(); ++i) {
            DKUDateUtils.FormatPatternPart part = (DKUDateUtils.FormatPatternPart)jodaPattern.get(i);
            if (part.type == DKUDateUtils.FormatPatternPartType.SECOND && i + 2 < jodaPattern.size() && ((DKUDateUtils.FormatPatternPart)jodaPattern.get((int)(i + 1))).text.equals(".") && ((DKUDateUtils.FormatPatternPart)jodaPattern.get((int)(i + 2))).type == DKUDateUtils.FormatPatternPartType.MILLISECOND) {
                i += 2;
                continue;
            }
            SQLCapability capability = this.canFormatDatePart(part, forParsing);
            if (capability.capable) continue;
            return capability;
        }
        return SQLCapability.ok();
    }

    @Override
    public String getLeftoverPipelineViewsQuery(String schema) {
        if (StringUtils.isBlank((String)schema)) {
            throw new IllegalArgumentException("The schema must not be blank for BigQuery");
        }
        return "SELECT table_schema, table_name, table_catalog FROM " + this.quoteIdentifier(schema) + ".INFORMATION_SCHEMA.VIEWS WHERE table_name LIKE 'DSSVIEW\\\\_%'";
    }

    @Override
    public String getLogClause(double base, String argument) {
        return "LOG(" + argument + ", " + base + ")";
    }

    @Override
    public boolean supportRetrieveTableRowCount() {
        return true;
    }

    @Override
    public DatasetRecordCount retrieveTableRowCount(SQLConnectionProvider.SQLConnectionData connectionData, SQLConnectionProvider.SQLConnectionWrapper conn, SQLUtils.SQLTable sqlTable) throws SQLException {
        String datasetId;
        String projectId = sqlTable.getCatalog();
        if (StringUtils.isBlank((String)projectId)) {
            projectId = ((BigQueryConnection)connectionData.getConnection()).params.projectId;
        }
        if (StringUtils.isBlank((String)(datasetId = sqlTable.getSchemaNullIfBlank()))) {
            return null;
        }
        if (projectId.contains("`") || datasetId.contains("`")) {
            throw new IllegalArgumentException("Invalid SQLTable name");
        }
        String query = String.format("SELECT row_count FROM `%s`.`%s`.__TABLES__ WHERE table_id=?", projectId, datasetId);
        try (PreparedStatement statement = conn.prepareStatement(query);){
            statement.setString(1, sqlTable.getTable());
            if (statement.execute()) {
                try (ResultSet rs2 = statement.getResultSet();){
                    if (rs2.next()) {
                        DatasetRecordCount datasetRecordCount = DatasetRecordCount.exact(rs2.getLong(1));
                        return datasetRecordCount;
                    }
                }
            }
            DatasetRecordCount datasetRecordCount = null;
            return datasetRecordCount;
        }
    }

    private static String temporaryTableOptions() {
        long tableExpirationInMinutes = DKUApp.getParams().getIntParamOrElse("dku.sql.bigquery.temporaryTable.minutesToLive", 1440);
        String expirationDate = DKUDateUtils.isoFormatUTC((long)(System.currentTimeMillis() + tableExpirationInMinutes * 60L * 1000L));
        return "expiration_timestamp=TIMESTAMP \"" + expirationDate + "\",description=\"Temporary table created by DSS. Can be safely deleted after one day.\"";
    }

    @Override
    public boolean canCastDSSFormatToTemporal() {
        return true;
    }

    @Override
    public SQLDialect.UpsertWriter getUpsertWriter() {
        return new SQLUtils.MergeIntoUpsertWriter(this, false, false, false, false);
    }

    @Override
    public SQLDialect.UpdateSelectWriter getUpdateSelectWriter() {
        return new SQLUtils.UpdateFromUpdateSelectWriter(this, false, false);
    }

    @Override
    public SQLDialect.MaterializedTemporaryTableWriter getMaterializedTemporaryTableWriter() {
        return new SQLUtils.RegularTableLikeMaterializedTemporaryTableWriter(this, true, false);
    }

    @Override
    public SQLDialect.RandomSampleClauseLocation getRandomSampleClauseLocation(SamplingParam.SamplingMethod samplingMethod, Long seed) {
        if (seed != null) {
            return SQLDialect.RandomSampleClauseLocation.NOT_SUPPORTED;
        }
        if (samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_RATIO) {
            return SQLDialect.RandomSampleClauseLocation.WHERE;
        }
        if (samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB_EXACT || samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB) {
            return SQLDialect.RandomSampleClauseLocation.ORDER_BY_AND_LIMIT;
        }
        return SQLDialect.RandomSampleClauseLocation.NOT_SUPPORTED;
    }

    @Override
    public String getRandomSampleClause(QueryAst.SampleClause sample) {
        StringBuilder sb = new StringBuilder();
        if (sample.samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_RATIO) {
            sb.append("rand() < ").append(sample.ratio);
        } else if (sample.samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB_EXACT || sample.samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB) {
            sb.append("rand()");
        } else {
            throw new UnsupportedOperationException(String.valueOf(sample.samplingMethod) + " sampling is not available for BigQuery");
        }
        return sb.toString();
    }

    @Override
    public SQLUtils.SQLTable getSafeRandomTemporaryTableName(String catalog, String schema, String prefix, String suffix) {
        return new SQLUtils.SQLTable(catalog, schema, this.getSafeRandomTemporaryTableName(prefix) + suffix);
    }

    @Override
    public String generateTableCommentStatementQuery(DatabaseObjectKey tableKey, String description, InfoMessage.InfoMessages messages) {
        SQLUtils.SQLTable sqlTable = new SQLUtils.SQLTable(tableKey.catalog, tableKey.schema, tableKey.name);
        return "ALTER TABLE IF EXISTS " + this.getQuotedTableFullName(sqlTable) + " SET OPTIONS (description = " + this.quoteDescriptionOrEmpty(this.truncateDescription(description, tableKey.name, true, messages)) + ")";
    }

    @Override
    public void tryWriteColumnComments(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionWrapper conn, DatabaseObjectKey tableKey, List<SchemaColumn> columns, String projectKey, InfoMessage.InfoMessages messages) {
        if (columns.isEmpty()) {
            return;
        }
        try (BigQueryNativeClient restClient = ((BigQueryConnection)conn.getConnectionData().getConnection()).getClient(authCtx, projectKey);){
            restClient.addDescriptionsToColumns(this, TableId.of((String)tableKey.catalog, (String)tableKey.schema, (String)tableKey.name), columns, messages);
            logger.infoV("tryWriteColumnComments: Updated %d columns", new Object[]{columns.size()});
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to update columns comments", (Throwable)e);
            messages.addMessage(InfoMessage.warning((InfoMessage.MessageCode)SQLCodes.ERR_SQL_CANNOT_SYNC_COLUMN_DESC, (String)ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    @Override
    public boolean supportsWriteSQLComment() {
        return true;
    }

    @Override
    public boolean supportsCommentsInCreateTableStatement() {
        return true;
    }

    @Override
    public boolean hasAccessToAliasInOrderByCaseStatement() {
        return true;
    }

    @Override
    public int getMaxTableCommentLengthInChars() {
        return 16384;
    }

    @Override
    public int getMaxColumnCommentLengthInChars() {
        return 1024;
    }
}

