/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.crecipes.sync;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.streamwrite.StreamWriter;
import com.dataiku.dip.datasets.streamwrite.StreamWriterFactory;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.streaming.crecipes.sync.CSyncExecutor;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimpleConsumer;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePusher;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePusherFactory;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.DKULogger;

public class SimpleSEToDatasetCSyncRecipeExecutor
implements CSyncExecutor {
    private String lastReceivedState;
    private long lastCheckpoint;
    private long checkpointSize;
    private final Dataset target;
    private final StreamingEndpoint source;
    private final String recipeFullId;
    private final long checkpointInterval;
    private final long checkpointMaxRows;
    private StreamingEndpointSimplePusher driver;
    StreamWriter writer;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.streaming.setodatasetsync.simple");

    public SimpleSEToDatasetCSyncRecipeExecutor(String recipeFullId, StreamingEndpoint source, Dataset target, long checkpointInterval, long checkpointMaxRows) {
        this.checkpointInterval = checkpointInterval;
        this.checkpointMaxRows = checkpointMaxRows;
        SpringUtils.getInstance().autowire((Object)this);
        this.source = source;
        this.target = target;
        this.recipeFullId = recipeFullId;
    }

    @Override
    public void run(AuthCtx authCtx) throws Exception {
        try (DatasetHandler dh = DatasetHandlerFactory.build(authCtx, this.target);){
            String sourceId = "dss_csync_" + this.recipeFullId;
            this.writer = StreamWriterFactory.build(authCtx, dh, sourceId, 0);
            String currentState = this.writer.getRecordedState();
            this.driver = new StreamingEndpointSimplePusherFactory().build(authCtx, this.source, false);
            StreamColumnFactory scf = new StreamColumnFactory();
            StreamRowFactory srf = new StreamRowFactory();
            this.writer.setColumnFactory((ColumnFactory)scf);
            SimpleSyncConsumer consumer = new SimpleSyncConsumer();
            this.lastCheckpoint = System.currentTimeMillis();
            this.checkpointSize = 0L;
            this.driver.run(consumer, currentState, (ColumnFactory)scf, (RowFactory)srf, this.source.schema);
            if (this.checkpointSize > 0L) {
                logger.info((Object)"Checkpoint on exit");
                this.writer.checkpoint(this.lastReceivedState);
            }
        }
    }

    @Override
    public void abort() {
        if (this.driver != null) {
            this.driver.interrupt();
        }
    }

    class SimpleSyncConsumer
    implements StreamingEndpointSimpleConsumer {
        SimpleSyncConsumer() {
        }

        @Override
        public void onRow(Row row) throws Exception {
            logger.info((Object)"Append row");
            SimpleSEToDatasetCSyncRecipeExecutor.this.writer.append(row);
            ++SimpleSEToDatasetCSyncRecipeExecutor.this.checkpointSize;
        }

        @Override
        public void onNewState(String state) throws Exception {
            SimpleSEToDatasetCSyncRecipeExecutor.this.lastReceivedState = state;
            long elapsed = System.currentTimeMillis() - SimpleSEToDatasetCSyncRecipeExecutor.this.lastCheckpoint;
            if (elapsed > SimpleSEToDatasetCSyncRecipeExecutor.this.checkpointInterval || SimpleSEToDatasetCSyncRecipeExecutor.this.checkpointSize > SimpleSEToDatasetCSyncRecipeExecutor.this.checkpointMaxRows) {
                logger.info((Object)("Checkpoint on timeout or size : checkpointSize=" + SimpleSEToDatasetCSyncRecipeExecutor.this.checkpointSize + " elapsed=" + elapsed));
                SimpleSEToDatasetCSyncRecipeExecutor.this.writer.checkpoint(SimpleSEToDatasetCSyncRecipeExecutor.this.lastReceivedState);
                SimpleSEToDatasetCSyncRecipeExecutor.this.lastCheckpoint = System.currentTimeMillis();
                SimpleSEToDatasetCSyncRecipeExecutor.this.checkpointSize = 0L;
            }
        }
    }
}

