/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.timelines.workspace;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.sql.queries.AddColumnQueryBuilder;
import com.dataiku.dip.timelines.workspace.MultiWorkspaceTimelinesInternalDB;
import com.dataiku.dip.timelines.workspace.WorkspaceTimelineBehavior;
import com.dataiku.dip.utils.DKULogger;
import java.sql.Statement;

public class WorkspaceTimelineInternalDB
extends AbstractDSSDBService {
    private static final int SCHEMA_VERSION = 5;
    public final WorkspaceTimelineBehavior behavior;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.timelines.workspace");

    public WorkspaceTimelineInternalDB(String workspaceKey) {
        super(MultiWorkspaceTimelinesInternalDB.getWorkspaceDAOFile(workspaceKey), "timeline_" + workspaceKey, "timeline", 5, false);
        this.behavior = new WorkspaceTimelineBehavior(workspaceKey, this.resolveTable("WORKSPACE_TIMELINE_ITEM"), this.getDialect());
    }

    @Override
    protected void initDB(int currentSchemaVersion, DSSDBConnection conn) {
        block24: {
            try {
                Statement st2;
                String timelineTable = "WORKSPACE_TIMELINE_ITEM";
                SchemaColumn[] timelineColumns = WorkspaceTimelineBehavior.TIMELINE_COLUMNS;
                if (currentSchemaVersion == 0) {
                    st2 = conn.createStatement();
                    try {
                        this.createTable(timelineTable, timelineColumns, new String[0], st2);
                        this.createAnonymousIndex(timelineTable, new String[]{"WORKSPACE_KEY"}, st2);
                    }
                    finally {
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                }
                if (currentSchemaVersion < 3) {
                    st2 = conn.createStatement();
                    try {
                        logger.info((Object)("Create indexes for " + this.getName()));
                        this.createAnonymousIndex(timelineTable, new String[]{"OBJECT_TYPE", "OBJECT_ID"}, st2);
                    }
                    finally {
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                }
                if (currentSchemaVersion <= 0 || currentSchemaVersion > 4) break block24;
                st2 = conn.createStatement();
                try {
                    String timelineTableName = "WORKSPACE_TIMELINE_ITEM";
                    logger.debugV("Adding a workspace key column to the timeline table of workspace %s", new Object[]{this.behavior.workspaceKey});
                    AddColumnQueryBuilder.addColumnTo(this.resolveTable(timelineTableName)).addColumns(WorkspaceTimelineBehavior.WORKSPACE_KEY_SCHEMA_COLUMN).execute(st2, this.getDialect());
                    this.createAnonymousIndex(timelineTableName, new String[]{"WORKSPACE_KEY"}, st2);
                    String fillColumnQuery = String.format("UPDATE %s SET %s = '%s'", this.getDialect().quoteIdentifier(timelineTableName), this.getDialect().quoteIdentifier("WORKSPACE_KEY"), this.behavior.workspaceKey);
                    logger.debugV("Filling column with workspace key value: %s", new Object[]{this.behavior.workspaceKey});
                    st2.execute(fillColumnQuery);
                    logger.debug((Object)"New column added and filled with workspace key");
                }
                finally {
                    if (st2 != null) {
                        st2.close();
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failed to init timeline. WorkspaceKey: " + this.behavior.workspaceKey), (Throwable)e);
            }
        }
    }

    @Override
    public void deleteConnectionPool() {
        super.deleteConnectionPool();
    }
}

