/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.geo;

import com.dataiku.dip.shaker.types.GeometryMeaning;
import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.locationtech.jts.geom.Geometry;

public class GeoContains
implements Function {
    private static final String ERROR_TEMPLATE = "%s parameter doesn't contain geospatial data";

    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 2) {
            Object outer = args[0];
            Object inner = args[1];
            if (outer instanceof String && inner instanceof String && !StringUtils.isBlank((String)((String)outer)) && !StringUtils.isBlank((String)((String)inner))) {
                GeometryMeaning geoMeaning = new GeometryMeaning();
                Geometry outerGeo = geoMeaning.toGeometry((String)outer);
                Geometry innerGeo = geoMeaning.toGeometry((String)inner);
                if (outerGeo == null) {
                    return new EvalError(String.format(ERROR_TEMPLATE, "outerGeo"));
                }
                if (innerGeo == null) {
                    return new EvalError(String.format(ERROR_TEMPLATE, "innerGeo"));
                }
                return outerGeo.contains(innerGeo);
            }
        }
        return null;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.GeoContains.DOCUMENTATION", "Returns whether <code>outer</code> geometry contains <code>inner</code> one. The <code>outer</code> and <code>inner</code> arguments can be columns in the datasets or WKT geometries. The function evaluates a boolean on <b>each</b> row.").withParams("string outer, string inner").withReturns("boolean").withCategory("GREL.FUNCTIONS.CATEGORY.GEO", "Geo functions").withExample(Example.with("\"POLYGON((0 1,1 1,1 0,0 0))\"", "geom").returns("true if \"POLYGON((0 1,1 1,1 0,0 0))\" contains the geometry from \"geom\" column")).withExample(Example.with("a_sample_geometry_column", "\"POINT(2.35 48.86)\"").returns("true if the row contains a geometry containing POINT(2.35 48.86)"));
    }
}

