/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.Days;
import com.dataiku.dss.shadelib.org.joda.time.Hours;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.dataiku.dss.shadelib.org.joda.time.Minutes;
import com.dataiku.dss.shadelib.org.joda.time.Months;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.Weeks;
import com.dataiku.dss.shadelib.org.joda.time.Years;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class Diff
implements Function {
    DKUFormulaUtils formulaUtils = new DKUFormulaUtils();

    @Override
    public String checkArguments(Evaluable[] args) {
        if (args.length < 2) {
            return GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects at least 2 arguments";
        }
        return null;
    }

    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 2 || args.length == 3) {
            Object o1 = args[0];
            Object o2 = args[1];
            Object o3 = null;
            if (args.length == 3) {
                o3 = args[2];
            }
            if (o3 == null) {
                o3 = "days";
            }
            if (o1 != null && o2 != null) {
                o1 = this.formulaUtils.asTemporal(o1, bindings);
                o2 = this.formulaUtils.asTemporal(o2, bindings);
                if (!(o3 instanceof String)) {
                    return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects \"unit\" string as third parameter (years, months, weeks, days, hours, minutes, seconds).");
                }
                if (o1 != null && o2 != null) {
                    String unit = ((String)o3).toLowerCase();
                    DateTime d1 = this.toDateTime(o1);
                    DateTime d2 = this.toDateTime(o2);
                    switch (unit) {
                        case "hours": 
                        case "hour": 
                        case "h": {
                            return Hours.hoursBetween((ReadableInstant)d2, (ReadableInstant)d1).getHours();
                        }
                        case "days": 
                        case "day": 
                        case "d": {
                            return Days.daysBetween((ReadableInstant)d2, (ReadableInstant)d1).getDays();
                        }
                        case "years": 
                        case "year": {
                            return Years.yearsBetween((ReadableInstant)d2, (ReadableInstant)d1).getYears();
                        }
                        case "months": 
                        case "month": {
                            return Months.monthsBetween((ReadableInstant)d2, (ReadableInstant)d1).getMonths();
                        }
                        case "minutes": 
                        case "minute": 
                        case "min": {
                            return Minutes.minutesBetween((ReadableInstant)d2, (ReadableInstant)d1).getMinutes();
                        }
                        case "weeks": 
                        case "week": 
                        case "w": {
                            return Weeks.weeksBetween((ReadableInstant)d2, (ReadableInstant)d1).getWeeks();
                        }
                        case "seconds": 
                        case "sec": 
                        case "s": {
                            return (d1.toDate().getTime() - d2.toDate().getTime()) / 1000L;
                        }
                    }
                    return new EvalError("Unknown time unit \"" + unit + "\".");
                }
            }
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects 2 dates and a unit string (years, months, weeks, days, hours, minutes, seconds)");
    }

    private DateTime toDateTime(Object o) {
        if (o instanceof LocalDate) {
            return ((LocalDate)o).toDateTimeAtStartOfDay(DateTimeZone.UTC);
        }
        if (o instanceof LocalDateTime) {
            return ((LocalDateTime)o).toDateTime(DateTimeZone.UTC);
        }
        return (DateTime)o;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Diff.DOCUMENTATION", "Returns the difference between two dates expressed in given time units. The default unit of time is 'days'. The available units are: years, months, weeks, days, hours, minutes, seconds.").withParams("date d1, date d2, [string unit]").withReturns("number").withCategory("GREL.FUNCTIONS.CATEGORY.DATE", "Date functions").withExample(Example.with("'2019-03-15T00:00:00.000Z'", "'2020-04-15T00:00:00.000Z'", "'month'").returns("-13"));
    }
}

