/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;

public class Unescape
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 2) {
            Object o1 = args[0];
            Object o2 = args[1];
            if (o1 != null && o2 != null && o1 instanceof String && o2 instanceof String) {
                String s = (String)o1;
                String mode = ((String)o2).toLowerCase(Locale.ENGLISH);
                if ("html".equals(mode)) {
                    return StringEscapeUtils.unescapeHtml((String)s);
                }
                if ("xml".equals(mode)) {
                    return StringEscapeUtils.unescapeXml((String)s);
                }
                if ("csv".equals(mode)) {
                    return StringEscapeUtils.unescapeCsv((String)s);
                }
                if ("javascript".equals(mode)) {
                    return StringEscapeUtils.unescapeJavaScript((String)s);
                }
                if ("url".equals(mode)) {
                    try {
                        return URLDecoder.decode(s, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                    }
                } else {
                    return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " does not recognize mode '" + mode + "'.");
                }
            }
        }
        return null;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Unescape.DOCUMENTATION", "Unescapes all escaped parts of the string depending on the given escaping mode. Available modes are: html, xml, csv, url, javascript.").withParams("string s, string mode").withReturns("string").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions");
    }
}

