/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.compute;

import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.ApiClient;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.compute.ClusterLibraryStatuses;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.compute.ClusterStatus;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.compute.InstallLibraries;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.compute.LibrariesImpl;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.compute.LibrariesService;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.compute.Library;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.compute.LibraryFullStatus;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.compute.ListAllClusterLibraryStatusesResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.compute.UninstallLibraries;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Generated;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Paginator;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class LibrariesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(LibrariesAPI.class);
    private final LibrariesService impl;

    public LibrariesAPI(ApiClient apiClient) {
        this.impl = new LibrariesImpl(apiClient);
    }

    public LibrariesAPI(LibrariesService mock) {
        this.impl = mock;
    }

    public Iterable<ClusterLibraryStatuses> allClusterStatuses() {
        return new Paginator(null, v -> this.impl.allClusterStatuses(), ListAllClusterLibraryStatusesResponse::getStatuses, response -> null);
    }

    public Iterable<LibraryFullStatus> clusterStatus(String clusterId) {
        return this.clusterStatus(new ClusterStatus().setClusterId(clusterId));
    }

    public Iterable<LibraryFullStatus> clusterStatus(ClusterStatus request) {
        return new Paginator(request, this.impl::clusterStatus, ClusterLibraryStatuses::getLibraryStatuses, response -> null);
    }

    public void install(String clusterId, Collection<Library> libraries) {
        this.install(new InstallLibraries().setClusterId(clusterId).setLibraries(libraries));
    }

    public void install(InstallLibraries request) {
        this.impl.install(request);
    }

    public void uninstall(String clusterId, Collection<Library> libraries) {
        this.uninstall(new UninstallLibraries().setClusterId(clusterId).setLibraries(libraries));
    }

    public void uninstall(UninstallLibraries request) {
        this.impl.uninstall(request);
    }

    public LibrariesService impl() {
        return this.impl;
    }
}

