/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.endpoints.predict;

import com.dataiku.lambda.ServiceGenContext;
import com.dataiku.lambda.endpoints.PreparationStep;
import com.dataiku.lambda.endpoints.predict.JavaPredictionStep;
import com.dataiku.lambda.endpoints.predict.MLFlowPyfuncPredictionStep;
import com.dataiku.lambda.endpoints.predict.PythonPredictionStep;
import com.dataiku.lambda.endpoints.predictcommon.PoolablePipelineWithEnrich;
import com.dataiku.lambda.endpoints.predictcommon.PredictionStep;
import com.dataiku.lambda.model.serverconfig.PredictionEndpointConfig;
import java.io.File;

public class PredictionPipeline
extends PoolablePipelineWithEnrich {
    public final PreparationStep prepare;
    public final PredictionStep predict;

    private PredictionPipeline(PreparationStep prepare, PredictionStep predict) {
        this.prepare = prepare;
        this.predict = predict;
    }

    @Override
    public void destroy() {
        this.predict.destroy();
        super.destroy();
    }

    public static class MLFlowPyfuncFactory
    implements Factory {
        private final PredictionEndpointConfig config;
        private final ServiceGenContext context;

        MLFlowPyfuncFactory(PredictionEndpointConfig config, ServiceGenContext context) {
            this.config = config;
            this.context = context;
        }

        @Override
        public PredictionPipeline build() throws Exception {
            File modelFolder = this.context.getModelFolder(this.config.modelId);
            MLFlowPyfuncPredictionStep predict = new MLFlowPyfuncPredictionStep(this.config, this.context, modelFolder);
            predict.init();
            PredictionPipeline pipe = new PredictionPipeline(null, predict);
            pipe.initEnrichMappings(this.config.enrichMapping, this.context);
            return pipe;
        }
    }

    public static class JavaFactory
    implements Factory {
        private final PredictionEndpointConfig config;
        private final ServiceGenContext context;
        private final JavaPredictionStep predict;

        JavaFactory(PredictionEndpointConfig config, ServiceGenContext context, JavaPredictionStep predict) {
            this.config = config;
            this.context = context;
            this.predict = predict;
        }

        @Override
        public PredictionPipeline build() throws Exception {
            PreparationStep prepare = new PreparationStep(this.context.getModelFolder(this.config.modelId), this.context.getConfig().userDefinedMeanings, this.context.getVariablesContextOrNull());
            prepare.init();
            PredictionPipeline pipe = new PredictionPipeline(prepare, this.predict);
            pipe.initEnrichMappings(this.config.enrichMapping, this.context);
            return pipe;
        }
    }

    public static class PythonFactory
    implements Factory {
        private final PredictionEndpointConfig config;
        private final ServiceGenContext context;

        PythonFactory(PredictionEndpointConfig config, ServiceGenContext context) {
            this.config = config;
            this.context = context;
        }

        @Override
        public PredictionPipeline build() throws Exception {
            PreparationStep prepare = new PreparationStep(this.context.getModelFolder(this.config.modelId), this.context.getConfig().userDefinedMeanings, this.context.getVariablesContextOrNull());
            prepare.init();
            File modelFolder = this.context.getModelFolder(this.config.modelId);
            PythonPredictionStep predict = new PythonPredictionStep(this.config, this.context, modelFolder);
            predict.init();
            PredictionPipeline pipe = new PredictionPipeline(prepare, predict);
            pipe.initEnrichMappings(this.config.enrichMapping, this.context);
            return pipe;
        }
    }

    public static interface Factory {
        public PredictionPipeline build() throws Exception;
    }
}

