/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.impl;

import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.exceptions.ReadException;
import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.impl.NumberUtil;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.SpreadsheetVersion;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.EvaluationName;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.EvaluationWorkbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.FormulaParsingWorkbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.SheetIdentifier;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.functions.FreeRefFunction;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.ptg.Area3DPxg;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.ptg.NamePtg;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.ptg.NameXPtg;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.ptg.NameXPxg;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.ptg.Ptg;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.ptg.Ref3DPxg;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.udf.AggregatingUDFFinder;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.udf.IndexedUDFFinder;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.udf.UDFFinder;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Workbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.util.AreaReference;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.util.CellReference;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.Internal;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.NotImplemented;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFName;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFTable;

@Internal
abstract class BaseEvaluationWorkbook
implements FormulaRenderingWorkbook,
EvaluationWorkbook,
FormulaParsingWorkbook {
    private final IndexedUDFFinder _udfFinder = new IndexedUDFFinder(AggregatingUDFFinder.DEFAULT);
    protected final Workbook _uBook;

    protected BaseEvaluationWorkbook(Workbook book) {
        this._uBook = book;
    }

    @Override
    public void clearAllCachedResultValues() {
    }

    private int convertFromExternalSheetIndex(int externSheetIndex) {
        return externSheetIndex;
    }

    @Override
    public int convertFromExternSheetIndex(int externSheetIndex) {
        return externSheetIndex;
    }

    private int convertToExternalSheetIndex(int sheetIndex) {
        return sheetIndex;
    }

    @Override
    public int getExternalSheetIndex(String sheetName) {
        int sheetIndex = this._uBook.getSheetIndex(sheetName);
        return this.convertToExternalSheetIndex(sheetIndex);
    }

    private int resolveBookIndex(String bookName) throws ReadException {
        if (bookName.startsWith("[") && bookName.endsWith("]")) {
            bookName = bookName.substring(1, bookName.length() - 2);
        }
        try {
            return NumberUtil.parseInt(bookName);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ReadException("Book not linked for filename " + bookName);
        }
    }

    @Override
    public EvaluationName getName(String name, int sheetIndex) {
        return null;
    }

    @Override
    public String getSheetName(int sheetIndex) {
        return this._uBook.getSheetName(sheetIndex);
    }

    @Override
    @NotImplemented
    public EvaluationWorkbook.ExternalName getExternalName(int externSheetIndex, int externNameIndex) {
        throw new IllegalStateException("ExternalNames are not supported in excel-streaming-reader");
    }

    @Override
    @NotImplemented
    public EvaluationWorkbook.ExternalName getExternalName(String nameName, String sheetName, int externalWorkbookNumber) {
        throw new IllegalStateException("ExternalNames are not supported in excel-streaming-reader");
    }

    @Override
    public NameXPxg getNameXPtg(String name, SheetIdentifier sheet) throws ReadException {
        IndexedUDFFinder udfFinder = (IndexedUDFFinder)this.getUDFFinder();
        FreeRefFunction func = udfFinder.findFunction(name);
        if (func != null) {
            return new NameXPxg(null, name);
        }
        if (sheet == null) {
            if (!this._uBook.getNames(name).isEmpty()) {
                return new NameXPxg(null, name);
            }
            return null;
        }
        if (sheet.getSheetIdentifier() == null) {
            int bookIndex = this.resolveBookIndex(sheet.getBookName());
            return new NameXPxg(bookIndex, null, name);
        }
        String sheetName = sheet.getSheetIdentifier().getName();
        if (sheet.getBookName() != null) {
            int bookIndex = this.resolveBookIndex(sheet.getBookName());
            return new NameXPxg(bookIndex, sheetName, name);
        }
        return new NameXPxg(sheetName, name);
    }

    @Override
    public Ptg get3DReferencePtg(CellReference cell, SheetIdentifier sheet) throws ReadException {
        if (sheet.getBookName() != null) {
            int bookIndex = this.resolveBookIndex(sheet.getBookName());
            return new Ref3DPxg(bookIndex, sheet, cell);
        }
        return new Ref3DPxg(sheet, cell);
    }

    @Override
    public Ptg get3DReferencePtg(AreaReference area, SheetIdentifier sheet) throws ReadException {
        if (sheet.getBookName() != null) {
            int bookIndex = this.resolveBookIndex(sheet.getBookName());
            return new Area3DPxg(bookIndex, sheet, area);
        }
        return new Area3DPxg(sheet, area);
    }

    @Override
    @NotImplemented
    public String resolveNameXText(NameXPtg n) {
        throw new IllegalStateException("resolveNameXText is not supported in excel-streaming-reader");
    }

    @Override
    @NotImplemented
    public EvaluationWorkbook.ExternalSheet getExternalSheet(int externSheetIndex) {
        throw new IllegalStateException("HSSF-style external references are not supported for XSSF");
    }

    @Override
    @NotImplemented
    public EvaluationWorkbook.ExternalSheet getExternalSheet(String firstSheetName, String lastSheetName, int externalWorkbookNumber) {
        throw new IllegalStateException("ExternalSheets are not supported in excel-streaming-reader");
    }

    @Override
    @NotImplemented
    public int getExternalSheetIndex(String workbookName, String sheetName) {
        throw new IllegalStateException("ExternalSheets are not supported in excel-streaming-reader");
    }

    @Override
    public int getSheetIndex(String sheetName) {
        return this._uBook.getSheetIndex(sheetName);
    }

    @Override
    public String getSheetFirstNameByExternSheet(int externSheetIndex) {
        int sheetIndex = this.convertFromExternalSheetIndex(externSheetIndex);
        return this._uBook.getSheetName(sheetIndex);
    }

    @Override
    public String getSheetLastNameByExternSheet(int externSheetIndex) {
        return this.getSheetFirstNameByExternSheet(externSheetIndex);
    }

    @Override
    @NotImplemented
    public String getNameText(NamePtg namePtg) {
        throw new IllegalStateException("getNameText is not supported in excel-streaming-reader");
    }

    @Override
    @NotImplemented
    public EvaluationName getName(NamePtg namePtg) {
        throw new IllegalStateException("EvaluationNames are not supported in excel-streaming-reader");
    }

    @Override
    @NotImplemented
    public XSSFName createName() {
        throw new IllegalStateException("XSSFNames are not supported in excel-streaming-reader");
    }

    @Override
    @NotImplemented
    public XSSFTable getTable(String name) {
        if (name == null) {
            return null;
        }
        throw new IllegalStateException("XSSFTables are not supported in excel-streaming-reader");
    }

    @Override
    public UDFFinder getUDFFinder() {
        return this._udfFinder;
    }

    @Override
    public SpreadsheetVersion getSpreadsheetVersion() {
        return SpreadsheetVersion.EXCEL2007;
    }
}

