/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.xdgf.usermodel.section.geometry;

import com.dataiku.dss.shadelibpoi.org.apache.poi.ooxml.POIXMLException;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xdgf.usermodel.XDGFCell;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xdgf.usermodel.XDGFShape;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xdgf.usermodel.section.geometry.GeometryRow;
import com.microsoft.schemas.office.visio.x2012.main.CellType;
import com.microsoft.schemas.office.visio.x2012.main.RowType;
import java.awt.geom.Path2D;

public class SplineKnot
implements GeometryRow {
    SplineKnot _master;
    Double x;
    Double y;
    Double a;
    Boolean deleted;

    public SplineKnot(RowType row) {
        if (row.isSetDel()) {
            this.deleted = row.getDel();
        }
        block10: for (CellType cell : row.getCellArray()) {
            String cellName;
            switch (cellName = cell.getN()) {
                case "X": {
                    this.x = XDGFCell.parseDoubleValue(cell);
                    continue block10;
                }
                case "Y": {
                    this.y = XDGFCell.parseDoubleValue(cell);
                    continue block10;
                }
                case "A": {
                    this.a = XDGFCell.parseDoubleValue(cell);
                    continue block10;
                }
                default: {
                    throw new POIXMLException("Invalid cell '" + cellName + "' in SplineKnot row");
                }
            }
        }
    }

    public boolean getDel() {
        if (this.deleted != null) {
            return this.deleted;
        }
        return this._master != null && this._master.getDel();
    }

    public Double getX() {
        return this.x == null ? this._master.x : this.x;
    }

    public Double getY() {
        return this.y == null ? this._master.y : this.y;
    }

    public Double getA() {
        return this.a == null ? this._master.a : this.a;
    }

    @Override
    public void setupMaster(GeometryRow row) {
        this._master = (SplineKnot)row;
    }

    @Override
    public void addToPath(Path2D.Double path, XDGFShape parent) {
        throw new POIXMLException("Error: Use SplineRenderer!");
    }

    public String toString() {
        return "{SplineKnot x=" + this.getX() + " y=" + this.getY() + " a=" + this.getA() + "}";
    }
}

