/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.xwpf.usermodel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum TextAlignment {
    TOP(1),
    CENTER(2),
    BASELINE(3),
    BOTTOM(4),
    AUTO(5);

    private static final Map<Integer, TextAlignment> imap;
    private final int value;

    private TextAlignment(int val) {
        this.value = val;
    }

    public static TextAlignment valueOf(int type) {
        TextAlignment align = imap.get(type);
        if (align == null) {
            throw new IllegalArgumentException("Unknown text alignment: " + type);
        }
        return align;
    }

    public int getValue() {
        return this.value;
    }

    static {
        HashMap<Integer, TextAlignment> tempMap = new HashMap<Integer, TextAlignment>();
        for (TextAlignment p : TextAlignment.values()) {
            tempMap.put(p.getValue(), p);
        }
        imap = Collections.unmodifiableMap(tempMap);
    }
}

