/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.xmlbeans.impl.tool;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class FileUtil {
    private FileUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Collection<File> find(File base, Pattern pattern, boolean searchSubdirectories) {
        try (Stream<Path> pathStream = Files.find(base.toPath(), searchSubdirectories ? Integer.MAX_VALUE : 1, (path, atts) -> {
            String name = path.getFileName().toString();
            return !name.endsWith(".xsdconfig") && pattern.matcher(name).matches();
        }, new FileVisitOption[0]);){
            Collection collection = pathStream.map(Path::toFile).collect(Collectors.toList());
            return collection;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

