/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.publicapi;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.gh.core.models.custom_pages.CustomPage;
import com.dataiku.gh.core.services.custom_pages.ICustomPagesService;
import com.dataiku.gh.security.auth.MetaAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PublicAPICustomPagesController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private ICustomPagesService customPagesService;

    @AuditedCall(value={"msgType", "custom-pages-list"})
    @RequestMapping(value={"/publicapi/custom-pages"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        PublicAPICustomPagesController.writeJSON((HttpServletResponse)resp, this.customPagesService.listCustomPages(authCtx));
    }

    @AuditedCall(value={"msgType", "custom-page-get", "customPageId", "${customPageId}"})
    @RequestMapping(value={"/publicapi/custom-page/{customPageId}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String customPageId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        CustomPage customPage = this.customPagesService.getCustomPage(authCtx, customPageId);
        PublicAPICustomPagesController.writeJSON((HttpServletResponse)resp, (Object)customPage);
    }
}

