/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.publicapi;

import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.futures.NoRemoteFutureService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss_gh.api.models.GovernInstanceStatus;
import com.dataiku.dss_gh.api.models.governance_status.DSSItemGovernanceStatusList;
import com.dataiku.dss_gh.api.models.identifiers.DSSAPIDeployerDeploymentIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSAPIDeployerInfraIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSBundleIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSDatasetIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSItemIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSItemIdentifierList;
import com.dataiku.dss_gh.api.models.identifiers.DSSProjectDeployerDeploymentIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSProjectDeployerInfraIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSProjectIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSRetrievableKnowledgeIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSSavedModelIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSSavedModelVersionIdentifier;
import com.dataiku.dss_gh.api.models.metrics.DSSSavedModelVersionEvaluationMetrics;
import com.dataiku.dss_gh.api.models.sync.DSSDeployerItems;
import com.dataiku.dss_gh.api.models.sync.DSSProject;
import com.dataiku.dss_gh.api.models.sync.DSSProjectList;
import com.dataiku.dss_gh.api.visitors.IDSSItemIdentifierVisitor;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.futures.GovernActionSimpleFutureThread;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.services.dss.status.IDSSIntegrationStatusService;
import com.dataiku.gh.core.services.dss.sync.IDSSIntegrationSyncService;
import com.dataiku.gh.core.services.validation.validators.DSSDeployerItemIdentifierValidator;
import com.dataiku.gh.core.services.validation.validators.DSSProjectItemIdentifierValidator;
import com.dataiku.gh.security.auth.MetaAuthService;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPIDSSController
extends PublicAPIControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IDSSIntegrationSyncService dssIntegrationService;
    @Autowired
    private IDSSIntegrationStatusService dssIntegrationStatusService;
    @Autowired
    private NoRemoteFutureService futureService;
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.public-controllers.dss");

    @AuditInline
    @RequestMapping(value={"/publicapi/dss/project-list/delete-diff"}, method={RequestMethod.POST})
    @ResponseBody
    @GovernAction(value=ActionType.DSS_PROJECT_LIST_DELETE_DIFF)
    public FutureResponse<Void> projectListDeleteDiff(HttpServletRequest req) throws Exception {
        try {
            final AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            final DSSProjectList dssProjectList = (DSSProjectList)this.getRequestBodyAs(req, DSSProjectList.class);
            logger.debugV("Incoming DSS sync (diff-delete-project-list): %s", new Object[]{dssProjectList});
            GovernActionSimpleFutureThread<Void> futureThread = new GovernActionSimpleFutureThread<Void>(authCtx, ActionType.DSS_PROJECT_LIST_DELETE_DIFF){

                @Override
                protected Void compute() throws Exception {
                    try {
                        PublicAPIDSSController.this.dssIntegrationService.projectListDeleteDiff(authCtx, dssProjectList);
                        PublicAPIDSSController.this.auditTrailService.generic("dss-project-list-delete-diff").emit();
                    }
                    catch (Exception e) {
                        PublicAPIDSSController.this.auditTrailService.failure("dss-project-list-delete-diff", (Throwable)e).emit();
                        throw e;
                    }
                    return null;
                }

                public FuturePayload getPayload() {
                    return FuturePayload.newSimple((String)"dssProjectListDeleteDiff", (String)"DSS project list delete diff");
                }
            };
            logger.debugV("Future ID: %s, starting DSS sync (diff-delete-project-list)", new Object[]{futureThread.jobId});
            return this.futureService.runFuture((FutureThreadBase)futureThread, 0L, (TypeToken)new TypeToken<FutureResponse<Void>>(){});
        }
        catch (Exception e) {
            this.auditTrailService.failure("dss-project-list-delete-diff", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/dss/project/partial-sync"}, method={RequestMethod.POST})
    @ResponseBody
    @GovernAction(value=ActionType.DSS_PROJECT_PARTIAL_SYNC)
    public FutureResponse<Void> partialSync(HttpServletRequest req) throws Exception {
        try {
            final AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            final DSSProject partialProject = (DSSProject)this.getRequestBodyAs(req, DSSProject.class);
            logger.debugV("Incoming DSS sync (partial-sync-project): %s", new Object[]{partialProject});
            GovernActionSimpleFutureThread<Void> futureThread = new GovernActionSimpleFutureThread<Void>(authCtx, ActionType.DSS_PROJECT_PARTIAL_SYNC){

                public FuturePayload getPayload() {
                    return FuturePayload.newSimple((String)"dssProjectPartialSync", (String)"Partial Sync DSS project");
                }

                @Override
                protected Void compute() throws Exception {
                    try {
                        PublicAPIDSSController.this.dssIntegrationService.partialSync(authCtx, partialProject);
                        PublicAPIDSSController.this.auditTrailService.generic("dss-project-partial-sync").with("nodeId", partialProject.dssProjectIdentifier.nodeId).with("projectKey", partialProject.dssProjectIdentifier.projectKey).emit();
                    }
                    catch (Exception e) {
                        PublicAPIDSSController.this.auditTrailService.failure("dss-project-partial-sync", (Throwable)e).emit();
                        throw e;
                    }
                    return null;
                }
            };
            logger.debugV("Future ID: %s, starting DSS sync (partial-sync-project)", new Object[]{futureThread.jobId});
            return this.futureService.runFuture((FutureThreadBase)futureThread, 0L, (TypeToken)new TypeToken<FutureResponse<Void>>(){});
        }
        catch (Exception e) {
            this.auditTrailService.failure("dss-project-partial-sync", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/dss/project/full-sync"}, method={RequestMethod.POST})
    @ResponseBody
    @GovernAction(value=ActionType.DSS_PROJECT_FULL_SYNC)
    public FutureResponse<Void> fullSync(HttpServletRequest req) throws Exception {
        try {
            final AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            final DSSProject fullProject = (DSSProject)this.getRequestBodyAs(req, DSSProject.class);
            logger.debugV("Incoming DSS sync (full-sync-project): %s", new Object[]{fullProject});
            GovernActionSimpleFutureThread<Void> futureThread = new GovernActionSimpleFutureThread<Void>(authCtx, ActionType.DSS_PROJECT_FULL_SYNC){

                public FuturePayload getPayload() {
                    return FuturePayload.newSimple((String)"dssProjectFullSync", (String)"Full Sync DSS project");
                }

                @Override
                protected Void compute() throws Exception {
                    try {
                        PublicAPIDSSController.this.dssIntegrationService.fullSync(authCtx, fullProject);
                        PublicAPIDSSController.this.auditTrailService.generic("dss-project-full-sync").with("nodeId", fullProject.dssProjectIdentifier.nodeId).with("projectKey", fullProject.dssProjectIdentifier.projectKey).emit();
                    }
                    catch (Exception e) {
                        PublicAPIDSSController.this.auditTrailService.failure("dss-project-full-sync", (Throwable)e).emit();
                        throw e;
                    }
                    return null;
                }
            };
            logger.debugV("Future ID: %s, starting DSS sync (full-sync-project)", new Object[]{futureThread.jobId});
            return this.futureService.runFuture((FutureThreadBase)futureThread, 0L, (TypeToken)new TypeToken<FutureResponse<Void>>(){});
        }
        catch (Exception e) {
            this.auditTrailService.failure("dss-project-full-sync", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/dss/delete"}, method={RequestMethod.POST})
    @ResponseBody
    @GovernAction(value=ActionType.DSS_ITEM_DELETE)
    public FutureResponse<Void> deleteDSSItem(HttpServletRequest req) throws Exception {
        try {
            final AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            final DSSItemIdentifier dssItemIdentifier = (DSSItemIdentifier)this.getRequestBodyAs(req, DSSItemIdentifier.class);
            logger.debugV("Incoming DSS sync (delete-item): %s", new Object[]{dssItemIdentifier});
            GovernActionSimpleFutureThread<Void> futureThread = new GovernActionSimpleFutureThread<Void>(authCtx, ActionType.DSS_ITEM_DELETE){

                @Override
                protected Void compute() throws Exception {
                    try {
                        dssItemIdentifier.accept((IDSSItemIdentifierVisitor)new DSSProjectItemIdentifierValidator());
                        PublicAPIDSSController.this.dssIntegrationService.deleteDSSItem(authCtx, dssItemIdentifier);
                        AuditTrailService.EmittableAuditObj auditObj = PublicAPIDSSController.this.auditTrailService.generic("dss-item-delete");
                        if (dssItemIdentifier instanceof DSSSavedModelVersionIdentifier) {
                            DSSSavedModelVersionIdentifier dssSavedModelVersionIdentifier = (DSSSavedModelVersionIdentifier)dssItemIdentifier;
                            auditObj.with("type", "saved-model-version").with("nodeId", dssSavedModelVersionIdentifier.nodeId).with("projectKey", dssSavedModelVersionIdentifier.projectKey).with("savedModelId", dssSavedModelVersionIdentifier.savedModelId).with("fullModelVersionId", dssSavedModelVersionIdentifier.fullModelVersionId);
                        } else if (dssItemIdentifier instanceof DSSSavedModelIdentifier) {
                            DSSSavedModelIdentifier dssSavedModelIdentifier = (DSSSavedModelIdentifier)dssItemIdentifier;
                            auditObj.with("type", "saved-model").with("nodeId", dssSavedModelIdentifier.nodeId).with("projectKey", dssSavedModelIdentifier.projectKey).with("savedModelId", dssSavedModelIdentifier.savedModelId);
                        } else if (dssItemIdentifier instanceof DSSRetrievableKnowledgeIdentifier) {
                            DSSRetrievableKnowledgeIdentifier dssRetrievableKnowledgeIdentifier = (DSSRetrievableKnowledgeIdentifier)dssItemIdentifier;
                            auditObj.with("type", "retrievable-knowledge").with("nodeId", dssRetrievableKnowledgeIdentifier.nodeId).with("projectKey", dssRetrievableKnowledgeIdentifier.projectKey).with("retrievableKnowledgeId", dssRetrievableKnowledgeIdentifier.retrievableKnowledgeId);
                        } else if (dssItemIdentifier instanceof DSSDatasetIdentifier) {
                            DSSDatasetIdentifier dssDatasetIdentifier = (DSSDatasetIdentifier)dssItemIdentifier;
                            auditObj.with("type", "dataset").with("nodeId", dssDatasetIdentifier.nodeId).with("projectKey", dssDatasetIdentifier.projectKey).with("datasetName", dssDatasetIdentifier.datasetName);
                        } else if (dssItemIdentifier instanceof DSSBundleIdentifier) {
                            DSSBundleIdentifier dssBundleIdentifier = (DSSBundleIdentifier)dssItemIdentifier;
                            auditObj.with("type", "bundle").with("nodeId", dssBundleIdentifier.nodeId).with("projectKey", dssBundleIdentifier.projectKey).with("bundleId", dssBundleIdentifier.bundleId);
                        } else if (dssItemIdentifier instanceof DSSProjectIdentifier) {
                            DSSProjectIdentifier dssProjectIdentifier = (DSSProjectIdentifier)dssItemIdentifier;
                            auditObj.with("type", "project").with("nodeId", dssProjectIdentifier.nodeId).with("projectKey", dssProjectIdentifier.projectKey);
                        }
                        auditObj.emit();
                    }
                    catch (Exception e) {
                        PublicAPIDSSController.this.auditTrailService.failure("dss-item-delete", (Throwable)e).emit();
                        throw e;
                    }
                    return null;
                }

                public FuturePayload getPayload() {
                    return FuturePayload.newSimple((String)"dssItemDelete", (String)"Delete DSS item");
                }
            };
            logger.debugV("Future ID: %s, starting DSS sync (delete-item)", new Object[]{futureThread.jobId});
            return this.futureService.runFuture((FutureThreadBase)futureThread, 0L, (TypeToken)new TypeToken<FutureResponse<Void>>(){});
        }
        catch (Exception e) {
            this.auditTrailService.failure("dss-item-delete", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "dss-govern-instance-status-get"})
    @RequestMapping(value={"/publicapi/dss/status"}, method={RequestMethod.GET})
    public void getGovernInstanceStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        GovernInstanceStatus status = new GovernInstanceStatus();
        status.isAdmin = authCtx.isAdmin();
        PublicAPIDSSController.writeJSON((HttpServletResponse)resp, (Object)status);
    }

    @AuditedCall(value={"msgType", "dss-governance-status-get"})
    @RequestMapping(value={"/publicapi/dss/governance-status"}, method={RequestMethod.POST})
    public void getGovernanceStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        DSSItemIdentifierList dssItemIdentifierList = (DSSItemIdentifierList)this.getRequestBodyAs(req, DSSItemIdentifierList.class);
        DSSItemGovernanceStatusList dssItemGovernanceStatusList = this.dssIntegrationStatusService.getGovernanceStatusList(authCtx, dssItemIdentifierList);
        PublicAPIDSSController.writeJSON((HttpServletResponse)resp, (Object)dssItemGovernanceStatusList);
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/dss/saved-model-version/evaluation-metrics/partial-sync"}, method={RequestMethod.POST})
    @ResponseBody
    @GovernAction(value=ActionType.DSS_EVALUATION_METRICS_PARTIAL_SYNC)
    public FutureResponse<Void> partialSyncEvaluationMetrics(HttpServletRequest req) throws Exception {
        try {
            final AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            final DSSSavedModelVersionEvaluationMetrics dssSavedModelVersionEvaluationMetrics = (DSSSavedModelVersionEvaluationMetrics)this.getRequestBodyAs(req, DSSSavedModelVersionEvaluationMetrics.class);
            logger.debugV("Incoming DSS sync (partial-sync-evaluations): %s", new Object[]{dssSavedModelVersionEvaluationMetrics});
            GovernActionSimpleFutureThread<Void> futureThread = new GovernActionSimpleFutureThread<Void>(authCtx, ActionType.DSS_EVALUATION_METRICS_PARTIAL_SYNC){

                @Override
                protected Void compute() throws Exception {
                    try {
                        PublicAPIDSSController.this.dssIntegrationService.partialSync(authCtx, dssSavedModelVersionEvaluationMetrics);
                        PublicAPIDSSController.this.auditTrailService.generic("dss-saved-model-version-evaluation-metrics-partial-sync").with("nodeId", dssSavedModelVersionEvaluationMetrics.dssSavedModelVersionIdentifier.nodeId).with("projectKey", dssSavedModelVersionEvaluationMetrics.dssSavedModelVersionIdentifier.projectKey).with("savedModelId", dssSavedModelVersionEvaluationMetrics.dssSavedModelVersionIdentifier.savedModelId).with("fullModelVersionId", dssSavedModelVersionEvaluationMetrics.dssSavedModelVersionIdentifier.fullModelVersionId).emit();
                    }
                    catch (Exception e) {
                        PublicAPIDSSController.this.auditTrailService.failure("dss-saved-model-version-evaluation-metrics-partial-sync", (Throwable)e).emit();
                        throw e;
                    }
                    return null;
                }

                public FuturePayload getPayload() {
                    return FuturePayload.newSimple((String)"dssEvaluationMetricsPartialSync", (String)"Partial Sync DSS Evaluation Metrics");
                }
            };
            logger.debugV("Future ID: %s, starting DSS sync (partial-sync-evaluations)", new Object[]{futureThread.jobId});
            return this.futureService.runFuture((FutureThreadBase)futureThread, 0L, (TypeToken)new TypeToken<FutureResponse<Void>>(){});
        }
        catch (Exception e) {
            this.auditTrailService.failure("dss-saved-model-version-evaluation-metrics-partial-sync", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/dss/deployer/full-sync"}, method={RequestMethod.POST})
    @ResponseBody
    @GovernAction(value=ActionType.DSS_DEPLOYER_FULL_SYNC)
    public FutureResponse<Void> fullSyncDeployer(HttpServletRequest req) throws Exception {
        try {
            final AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            final DSSDeployerItems dssDeployerItems = (DSSDeployerItems)this.getRequestBodyAs(req, DSSDeployerItems.class);
            logger.debugV("Incoming Deployer sync (full-sync-deployer): %s", new Object[]{dssDeployerItems});
            GovernActionSimpleFutureThread<Void> futureThread = new GovernActionSimpleFutureThread<Void>(authCtx, ActionType.DSS_DEPLOYER_FULL_SYNC){

                public FuturePayload getPayload() {
                    return FuturePayload.newSimple((String)"dssDeployerFullSync", (String)"Full Sync Deployer");
                }

                @Override
                protected Void compute() throws Exception {
                    try {
                        PublicAPIDSSController.this.dssIntegrationService.deployerFullSync(authCtx, dssDeployerItems);
                        PublicAPIDSSController.this.auditTrailService.generic("dss-deployer-full-sync").with("nodeId", dssDeployerItems.nodeId).emit();
                        return null;
                    }
                    catch (Exception e) {
                        PublicAPIDSSController.this.auditTrailService.failure("dss-deployer-full-sync", (Throwable)e).emit();
                        throw e;
                    }
                }
            };
            logger.debugV("Future ID: %s, starting Deployer sync (full-sync-deployer)", new Object[]{futureThread.jobId});
            return this.futureService.runFuture((FutureThreadBase)futureThread, 0L, (TypeToken)new TypeToken<FutureResponse<Void>>(){});
        }
        catch (Exception e) {
            this.auditTrailService.failure("dss-deployer-full-sync", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/dss/deployer/partial-sync"}, method={RequestMethod.POST})
    @ResponseBody
    @GovernAction(value=ActionType.DSS_DEPLOYER_PARTIAL_SYNC)
    public FutureResponse<Void> partialSyncDeployer(HttpServletRequest req) throws Exception {
        try {
            final AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            final DSSDeployerItems dssDeployerItems = (DSSDeployerItems)this.getRequestBodyAs(req, DSSDeployerItems.class);
            logger.debugV("Incoming Deployer sync (partial-sync-deployer): %s", new Object[]{dssDeployerItems});
            GovernActionSimpleFutureThread<Void> futureThread = new GovernActionSimpleFutureThread<Void>(authCtx, ActionType.DSS_DEPLOYER_PARTIAL_SYNC){

                @Override
                protected Void compute() throws Exception {
                    try {
                        PublicAPIDSSController.this.dssIntegrationService.deployerPartialSync(authCtx, dssDeployerItems);
                        PublicAPIDSSController.this.auditTrailService.generic("dss-deployer-partial-sync").with("nodeId", dssDeployerItems.nodeId).emit();
                    }
                    catch (Exception e) {
                        PublicAPIDSSController.this.auditTrailService.failure("dss-deployer-partial-sync", (Throwable)e).emit();
                        throw e;
                    }
                    return null;
                }

                public FuturePayload getPayload() {
                    return FuturePayload.newSimple((String)"dssDeployerPartialSync", (String)"Partial Sync Deployer");
                }
            };
            logger.debugV("Future ID: %s, starting Deployer sync (partial-sync-deployer)", new Object[]{futureThread.jobId});
            return this.futureService.runFuture((FutureThreadBase)futureThread, 0L, (TypeToken)new TypeToken<FutureResponse<Void>>(){});
        }
        catch (Exception e) {
            this.auditTrailService.failure("dss-deployer-partial-sync", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/dss/delete-deployer"}, method={RequestMethod.POST})
    @ResponseBody
    @GovernAction(value=ActionType.DSS_DEPLOYER_ITEM_DELETE)
    public FutureResponse<Void> deleteDeployerItem(HttpServletRequest req) throws Exception {
        try {
            final AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            final DSSItemIdentifier dssDeployerItemIdentifier = (DSSItemIdentifier)this.getRequestBodyAs(req, DSSItemIdentifier.class);
            logger.debugV("Incoming Deployer sync (delete-item): %s", new Object[]{dssDeployerItemIdentifier});
            GovernActionSimpleFutureThread<Void> futureThread = new GovernActionSimpleFutureThread<Void>(authCtx, ActionType.DSS_DEPLOYER_ITEM_DELETE){

                public FuturePayload getPayload() {
                    return FuturePayload.newSimple((String)"dssDeployerItemDelete", (String)"Delete deployer item");
                }

                @Override
                protected Void compute() throws Exception {
                    try {
                        dssDeployerItemIdentifier.accept((IDSSItemIdentifierVisitor)new DSSDeployerItemIdentifierValidator());
                        PublicAPIDSSController.this.dssIntegrationService.deleteDeployerItem(authCtx, dssDeployerItemIdentifier);
                        AuditTrailService.EmittableAuditObj auditObj = PublicAPIDSSController.this.auditTrailService.generic("dss-deployer-item-delete");
                        if (dssDeployerItemIdentifier instanceof DSSAPIDeployerInfraIdentifier) {
                            DSSAPIDeployerInfraIdentifier dssAPIDeployerInfraIdentifier = (DSSAPIDeployerInfraIdentifier)dssDeployerItemIdentifier;
                            auditObj.with("type", "api-deployer-infra").with("nodeId", dssAPIDeployerInfraIdentifier.nodeId).with("infraId", dssAPIDeployerInfraIdentifier.infraId);
                        } else if (dssDeployerItemIdentifier instanceof DSSAPIDeployerDeploymentIdentifier) {
                            DSSAPIDeployerDeploymentIdentifier dssAPIDeployerDeploymentIdentifier = (DSSAPIDeployerDeploymentIdentifier)dssDeployerItemIdentifier;
                            auditObj.with("type", "api-deployer-deployment").with("nodeId", dssAPIDeployerDeploymentIdentifier.nodeId).with("deploymentId", dssAPIDeployerDeploymentIdentifier.deploymentId);
                        } else if (dssDeployerItemIdentifier instanceof DSSProjectDeployerInfraIdentifier) {
                            DSSProjectDeployerInfraIdentifier dssProjectDeployerInfraIdentifier = (DSSProjectDeployerInfraIdentifier)dssDeployerItemIdentifier;
                            auditObj.with("type", "project-deployer-infra").with("nodeId", dssProjectDeployerInfraIdentifier.nodeId).with("infraId", dssProjectDeployerInfraIdentifier.infraId);
                        } else if (dssDeployerItemIdentifier instanceof DSSProjectDeployerDeploymentIdentifier) {
                            DSSProjectDeployerDeploymentIdentifier dssProjectDeployerDeploymentIdentifier = (DSSProjectDeployerDeploymentIdentifier)dssDeployerItemIdentifier;
                            auditObj.with("type", "project-deployer-deployment").with("nodeId", dssProjectDeployerDeploymentIdentifier.nodeId).with("deploymentId", dssProjectDeployerDeploymentIdentifier.deploymentId);
                        }
                        auditObj.emit();
                    }
                    catch (Exception e) {
                        PublicAPIDSSController.this.auditTrailService.failure("dss-deployer-item-delete", (Throwable)e).emit();
                        throw e;
                    }
                    return null;
                }
            };
            logger.debugV("Future ID: %s, incoming Deployer sync (delete-item)", new Object[]{futureThread.jobId});
            return this.futureService.runFuture((FutureThreadBase)futureThread, 0L, (TypeToken)new TypeToken<FutureResponse<Void>>(){});
        }
        catch (Exception e) {
            this.auditTrailService.failure("dss-deployer-item-delete", (Throwable)e).emit();
            throw e;
        }
    }
}

