/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.admin.migrations;

import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.gh.core.models.admin.MigrationFile;
import com.dataiku.gh.core.services.admin.migrations.Migration;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationEntitiesUtilsBetweenV13100AndV13299;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationJsonUtils;
import com.dataiku.gh.core.storage.admin.IDBMigrationDAO;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.jdbc.core.JdbcTemplate;

public class MigrationV13100
extends Migration {
    private static final String[] BPV_BLUEPRINT_IDS = new String[]{"api_deployer_deployment", "api_deployer_infrastructure", "business_initiative", "dataiku_bundle", "dataiku_dataset", "dataiku_project", "dataiku_saved_model", "dataiku_saved_model_version", "govern_bundle", "govern_dataset", "govern_model", "govern_model_version", "govern_project", "group", "project_deployer_deployment", "project_deployer_infrastructure", "user"};
    private static final String[] DELETED_FIELD_IDS = new String[]{"feasibility", "risk", "value"};
    private Long actionId;

    @Override
    protected void preRunSQLFiles(IDBMigrationDAO dbMigrationDAO, List<MigrationFile> migrationFiles) throws IOException {
        this.migrateAllArtifacts(dbMigrationDAO);
    }

    @Override
    protected void postRunSQLFiles(IDBMigrationDAO dbMigrationDAO, List<MigrationFile> migrationFiles) throws IOException {
        this.migrateAllBlueprintPermissions(dbMigrationDAO);
    }

    private Long getMigrationActionId(IDBMigrationDAO dbMigrationDAO, long migrationTS) throws IOException {
        if (this.actionId == null) {
            this.actionId = MigrationEntitiesUtilsBetweenV13100AndV13299.createMigrationAction(dbMigrationDAO.getJdbcTemplate(), migrationTS);
        }
        return this.actionId;
    }

    private void migrateAllArtifacts(IDBMigrationDAO dbMigrationDAO) throws IOException {
        long migrationTS = this.getMigrationTimestamp();
        String fieldClause = Arrays.stream(DELETED_FIELD_IDS).map(fieldId -> "artifact_json #> '{fields," + fieldId + "}' IS NOT NULL").collect(Collectors.joining(" OR "));
        MigrationEntitiesUtilsBetweenV13100AndV13299.fixArtifacts(dbMigrationDAO, "artifact_blueprint_id = 'bp.system.govern_project' AND artifact_version_id = 'bv.system.default' AND (" + fieldClause + ")", this::migrateArtifact, this.getMigrationActionId(dbMigrationDAO, migrationTS), migrationTS);
        MigrationEntitiesUtilsBetweenV13100AndV13299.fixArtifactsDeleteReferences(dbMigrationDAO, "bp.system.govern_project", "bv.system.default", "signoff_approvers", this.getMigrationActionId(dbMigrationDAO, migrationTS), migrationTS);
    }

    protected JsonObject migrateArtifact(JsonObject artifact) {
        JsonObject fields = artifact.getAsJsonObject("fields");
        for (String fieldId : DELETED_FIELD_IDS) {
            if (!fields.has(fieldId)) continue;
            fields.remove(fieldId);
        }
        return artifact;
    }

    @Override
    protected void updateProvidedSystemObjects(IDBMigrationDAO dbMigrationDAO, @Nullable File providedObjectsFolder) throws IOException {
        JdbcTemplate jdbcTemplate = dbMigrationDAO.getJdbcTemplate();
        long migrationTS = this.getMigrationTimestamp();
        for (String bpvBlueprintId : BPV_BLUEPRINT_IDS) {
            MigrationEntitiesUtilsBetweenV13100AndV13299.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{bpvBlueprintId, "blueprint_version_default.json"}), "bp.system." + bpvBlueprintId, "bv.system.default", this.getMigrationActionId(dbMigrationDAO, migrationTS), migrationTS);
        }
    }

    private void migrateAllBlueprintPermissions(IDBMigrationDAO dbMigrationDAO) throws IOException {
        MigrationEntitiesUtilsBetweenV13100AndV13299.migrateObjectsStructure(dbMigrationDAO.getJdbcTemplate(), "blueprint_permissions", "blueprint_permissions_blueprint_id=?", "blueprint_permissions_json", null, bpp -> Arrays.asList(MigrationJsonUtils.getStringSubpath((JsonElement)bpp, "blueprintId").orElse(null)), MigrationV13100::migrateBlueprintPermissions);
        MigrationEntitiesUtilsBetweenV13100AndV13299.migrateObjectsStructureHistory(dbMigrationDAO.getJdbcTemplate(), "blueprint_permissions_history", "blueprint_permissions_json", null, MigrationV13100::migrateBlueprintPermissions);
        MigrationEntitiesUtilsBetweenV13100AndV13299.migrateObjectsStructure(dbMigrationDAO.getJdbcTemplate(), "govern_configuration", "configuration_item_id=?", "configuration_item_json", "configuration_item_id='default-blueprint-permissions'", bpp -> List.of("default-blueprint-permissions"), MigrationV13100::migrateDefaultBlueprintPermissions);
        MigrationEntitiesUtilsBetweenV13100AndV13299.migrateObjectsStructureHistory(dbMigrationDAO.getJdbcTemplate(), "govern_configuration_history", "configuration_item_json", "configuration_item_id='default-blueprint-permissions'", MigrationV13100::migrateDefaultBlueprintPermissions);
    }

    protected static JsonObject migrateDefaultBlueprintPermissions(JsonObject dbpp) {
        MigrationJsonUtils.getObjectSubpath((JsonElement)dbpp, "defaultBlueprintPermissions").ifPresent(MigrationV13100::migrateBlueprintPermissions);
        return dbpp;
    }

    protected static JsonObject migrateBlueprintPermissions(JsonObject bpp) {
        MigrationJsonUtils.getObjectSubpath((JsonElement)bpp, "everyonePermissions").ifPresent(MigrationV13100::migratePermissionItem);
        MigrationJsonUtils.getObjectSubpath((JsonElement)bpp, "rolePermissions").ifPresent(rps -> {
            for (String key : rps.keySet()) {
                MigrationJsonUtils.getObjectSubpath((JsonElement)rps, key).ifPresent(MigrationV13100::migratePermissionItem);
            }
        });
        return bpp;
    }

    private static void migratePermissionItem(JsonObject permissionItem) {
        boolean create;
        JsonObject artifactPermissionsItem = MigrationJsonUtils.getObjectSubpath((JsonElement)permissionItem, "artifactPermissionsItem").orElse(null);
        if (artifactPermissionsItem != null && (create = MigrationJsonUtils.getUnboxedBooleanSubpath((JsonElement)artifactPermissionsItem, false, "create"))) {
            artifactPermissionsItem.addProperty("read", Boolean.valueOf(true));
        }
    }
}

