/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.governance.config;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.configuration.DefaultAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.governance.ArtifactAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.ArtifactAutoGovernanceConfigurationWithResolvedParent;
import com.dataiku.gh.core.models.governance.AutoGovernanceAction;
import com.dataiku.gh.core.models.governance.AutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.AutoGovernanceConfigurationSource;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.configuration.IGovernConfigurationDataService;
import com.dataiku.gh.core.services.governance.config.IAutoGovernanceConfigurationDataService;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.auto_govern.IArtifactGovernanceSettingsDAO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutoGovernanceConfigurationDataService
implements IAutoGovernanceConfigurationDataService {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.data-services.auto-governance-configuration");
    @Autowired
    private IArtifactGovernanceSettingsDAO autoGovernConfigurationDAO;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private IGovernConfigurationDataService governConfigurationDataService;

    @Override
    @GHMandatoryTransaction
    @Nullable
    public ArtifactAutoGovernanceConfiguration getArtifactAutoGovernConfigurationOrNull(String artifactId) throws IOException {
        return (ArtifactAutoGovernanceConfiguration)this.autoGovernConfigurationDAO.getOrNull(artifactId);
    }

    @Override
    @GHMandatoryTransaction
    @Nullable
    public Pair<AutoGovernanceConfigurationSource, ArtifactAutoGovernanceConfiguration> getResolvedArtifactAutoGovernConfiguration(EnrichedArtifact current) throws IOException {
        return this.resolve(this.getUpwardConfigs(current), true);
    }

    @Override
    @GHMandatoryTransaction
    public ArtifactAutoGovernanceConfigurationWithResolvedParent getAutoGovernanceConfigurationWithResolvedParent(EnrichedArtifact enrichedArtifact) throws IOException {
        List<Pair<EnrichedArtifact, ArtifactAutoGovernanceConfiguration>> upwardConfigs = this.getUpwardConfigs(enrichedArtifact);
        Pair<EnrichedArtifact, ArtifactAutoGovernanceConfiguration> currentElement = upwardConfigs.remove(0);
        Pair<AutoGovernanceConfigurationSource, ArtifactAutoGovernanceConfiguration> parentConfig = Optional.ofNullable(this.resolve(upwardConfigs, false)).orElseThrow(() -> new ValidationException("No parent found for governance settings of " + enrichedArtifact.artifact.id));
        Pair<AutoGovernanceConfigurationSource, ArtifactAutoGovernanceConfiguration> resolvedParentConfig = Optional.ofNullable(this.resolve(upwardConfigs, true)).orElseThrow(() -> new ValidationException("No parent found for governance settings of " + enrichedArtifact.artifact.id));
        return ArtifactAutoGovernanceConfigurationWithResolvedParent.build(enrichedArtifact.artifact.id, (ArtifactAutoGovernanceConfiguration)resolvedParentConfig.getRight(), (ArtifactAutoGovernanceConfiguration)parentConfig.getRight(), (AutoGovernanceConfigurationSource)((Object)parentConfig.getLeft()), (ArtifactAutoGovernanceConfiguration)currentElement.getRight());
    }

    @Override
    @GHMandatoryTransaction
    public Pair<AutoGovernanceConfigurationSource, AutoGovernanceConfiguration> getSelfConfiguration(EnrichedArtifact enrichedArtifact) throws IOException {
        List<Pair<EnrichedArtifact, ArtifactAutoGovernanceConfiguration>> upwardConfigs = this.getUpwardConfigs(enrichedArtifact);
        upwardConfigs.remove(0);
        Pair<AutoGovernanceConfigurationSource, ArtifactAutoGovernanceConfiguration> resolvedConfFromParent = this.resolve(upwardConfigs, true);
        if (resolvedConfFromParent == null) {
            throw new ValidationException("No parent found for governance settings of " + enrichedArtifact.artifact.id);
        }
        Artifact currentArtifact = enrichedArtifact.artifact;
        if (SystemProvidedConstants.DATAIKU_BUNDLE.matchBlueprint(currentArtifact.blueprintVersionId)) {
            return Pair.of((Object)((Object)((AutoGovernanceConfigurationSource)((Object)resolvedConfFromParent.getLeft()))), (Object)AutoGovernanceConfigurationDataService.checkClassAndCast((ArtifactAutoGovernanceConfiguration)((ArtifactAutoGovernanceConfiguration)resolvedConfFromParent.getRight()), ArtifactAutoGovernanceConfiguration.AProjectAutoGovernanceConfiguration.class).bundlesConfig);
        }
        if (SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.matchBlueprint(currentArtifact.blueprintVersionId)) {
            return Pair.of((Object)((Object)((AutoGovernanceConfigurationSource)((Object)resolvedConfFromParent.getLeft()))), (Object)AutoGovernanceConfigurationDataService.checkClassAndCast((ArtifactAutoGovernanceConfiguration)((ArtifactAutoGovernanceConfiguration)resolvedConfFromParent.getRight()), ArtifactAutoGovernanceConfiguration.AModelAutoGovernanceConfiguration.class).modelVersionsConfig);
        }
        if (SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(currentArtifact.blueprintVersionId)) {
            return Pair.of((Object)((Object)((AutoGovernanceConfigurationSource)((Object)resolvedConfFromParent.getLeft()))), (Object)AutoGovernanceConfigurationDataService.checkClassAndCast((ArtifactAutoGovernanceConfiguration)((ArtifactAutoGovernanceConfiguration)resolvedConfFromParent.getRight()), ArtifactAutoGovernanceConfiguration.AProjectAutoGovernanceConfiguration.class).modelsConfig);
        }
        if (SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(currentArtifact.blueprintVersionId)) {
            return Pair.of((Object)((Object)((AutoGovernanceConfigurationSource)((Object)resolvedConfFromParent.getLeft()))), (Object)AutoGovernanceConfigurationDataService.checkClassAndCast((ArtifactAutoGovernanceConfiguration)((ArtifactAutoGovernanceConfiguration)resolvedConfFromParent.getRight()), ArtifactAutoGovernanceConfiguration.AInstanceAutoGovernanceConfiguration.class).projectsConfig);
        }
        throw new ValidationException("Invalid artifact type, can't fetch governance configuration for type " + String.valueOf(currentArtifact.blueprintVersionId) + ", for artifact id=" + currentArtifact.id);
    }

    private List<Pair<EnrichedArtifact, ArtifactAutoGovernanceConfiguration>> getUpwardConfigs(EnrichedArtifact current) throws IOException {
        ArrayList<Pair<EnrichedArtifact, ArtifactAutoGovernanceConfiguration>> upwardConfigs = new ArrayList<Pair<EnrichedArtifact, ArtifactAutoGovernanceConfiguration>>();
        ArtifactAutoGovernanceConfiguration currentConfig = this.getArtifactAutoGovernConfigurationOrNull(current.artifact.id);
        upwardConfigs.add(Pair.of((Object)current, (Object)currentConfig));
        EnrichedArtifact parent = this.getParent(current);
        if (parent != null) {
            upwardConfigs.addAll(this.getUpwardConfigs(parent));
        } else {
            upwardConfigs.add(Pair.of(null, (Object)this.getInstanceDefaultProjectAutoGovernConfiguration().instanceAutoGovernanceConfiguration));
        }
        return upwardConfigs;
    }

    @Nullable
    private <T> Pair<AutoGovernanceConfigurationSource, ArtifactAutoGovernanceConfiguration> resolve(List<Pair<EnrichedArtifact, ArtifactAutoGovernanceConfiguration>> upwardConfigs, boolean replaceInherits) {
        if (CollectionUtils.isEmpty(upwardConfigs)) {
            throw new IllegalStateException("No AutoGovernance configurations given, at least instance configuration should be present");
        }
        Pair<EnrichedArtifact, ArtifactAutoGovernanceConfiguration> firstLevel = upwardConfigs.get(0);
        if (firstLevel.getLeft() == null) {
            return Pair.of((Object)((Object)AutoGovernanceConfigurationSource.INSTANCE), (Object)AutoGovernanceConfigurationDataService.checkClassAndCast((ArtifactAutoGovernanceConfiguration)firstLevel.getRight(), ArtifactAutoGovernanceConfiguration.AInstanceAutoGovernanceConfiguration.class));
        }
        Artifact currentArtifact = ((EnrichedArtifact)firstLevel.getLeft()).artifact;
        AutoGovernanceConfigurationSource source = this.findFirstSourceInHierarchy(upwardConfigs);
        if (SystemProvidedConstants.DATAIKU_BUNDLE.matchBlueprint(currentArtifact.blueprintVersionId)) {
            return null;
        }
        if (SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.matchBlueprint(currentArtifact.blueprintVersionId)) {
            return null;
        }
        if (SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(currentArtifact.blueprintVersionId)) {
            return Pair.of((Object)((Object)source), (Object)ArtifactAutoGovernanceConfiguration.ModelAutoGovernanceConfiguration.build(currentArtifact.id, this.findFirstInHierarchy(replaceInherits, ArtifactAutoGovernanceConfiguration.AModelAutoGovernanceConfiguration.class, upwardConfigs, m -> m.modelVersionsConfig)));
        }
        if (SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(currentArtifact.blueprintVersionId)) {
            return Pair.of((Object)((Object)source), (Object)ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration.build(currentArtifact.id, this.findFirstInHierarchy(replaceInherits, ArtifactAutoGovernanceConfiguration.AProjectAutoGovernanceConfiguration.class, upwardConfigs, p -> p.bundlesConfig), this.findFirstInHierarchy(replaceInherits, ArtifactAutoGovernanceConfiguration.AProjectAutoGovernanceConfiguration.class, upwardConfigs, p -> p.modelsConfig), this.findFirstInHierarchy(replaceInherits, ArtifactAutoGovernanceConfiguration.AProjectAutoGovernanceConfiguration.class, upwardConfigs, p -> p.modelVersionsConfig)));
        }
        throw new ValidationException("Invalid artifact type, can't fetch governance configuration for type " + String.valueOf(currentArtifact.blueprintVersionId) + ", for artifact id=" + currentArtifact.id);
    }

    @Nullable
    private EnrichedArtifact getParent(EnrichedArtifact current) throws IOException {
        String parentId = (String)current.artifact.fields.get(current.blueprintVersion.hierarchicalParentFieldId);
        if (parentId != null) {
            return this.artifactsDataService.getArtifact(parentId);
        }
        return null;
    }

    private static <T> T checkClassAndCast(ArtifactAutoGovernanceConfiguration config, Class<T> clazz) {
        if (config == null || clazz.isInstance(config)) {
            return clazz.cast(config);
        }
        throw new ValidationException("Unexpected AutoGovernanceConfiguration of type " + String.valueOf(config.getClass()) + " found, expecting " + String.valueOf(clazz));
    }

    private <T> AutoGovernanceConfiguration findFirstInHierarchy(boolean replaceInherits, Class<T> minimumExpectedLevel, List<Pair<EnrichedArtifact, ArtifactAutoGovernanceConfiguration>> configs, Function<T, AutoGovernanceConfiguration> getter) {
        return configs.stream().filter(p -> p != null && p.getRight() != null).map(c -> AutoGovernanceConfigurationDataService.checkClassAndCast((ArtifactAutoGovernanceConfiguration)c.getRight(), minimumExpectedLevel)).map(getter).filter(config -> !replaceInherits || config.action != AutoGovernanceAction.INHERIT).findFirst().orElseThrow(() -> new ValidationException("No AutoGovernance configurations found, at least instance configuration should be present"));
    }

    private AutoGovernanceConfigurationSource findFirstSourceInHierarchy(List<Pair<EnrichedArtifact, ArtifactAutoGovernanceConfiguration>> configs) {
        return configs.stream().filter(p -> p != null && p.getRight() != null).map(p -> {
            ArtifactAutoGovernanceConfiguration config = (ArtifactAutoGovernanceConfiguration)p.getRight();
            if (config instanceof ArtifactAutoGovernanceConfiguration.ModelAutoGovernanceConfiguration) {
                return AutoGovernanceConfigurationSource.MODEL;
            }
            if (config instanceof ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration) {
                return AutoGovernanceConfigurationSource.PROJECT;
            }
            return AutoGovernanceConfigurationSource.INSTANCE;
        }).findFirst().orElseThrow(() -> new ValidationException("No AutoGovernance configurations found, at least instance configuration should be present"));
    }

    private void storeDSSArtifactAutoGovernConfiguration(ArtifactAutoGovernanceConfiguration artifactAutoGovernanceConfiguration, boolean creation) throws IOException {
        EnrichedArtifact artifact = this.artifactsDataService.getArtifact(artifactAutoGovernanceConfiguration.artifactId);
        String sentConfigurationBlueprintId = "";
        if (artifactAutoGovernanceConfiguration instanceof ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration) {
            sentConfigurationBlueprintId = SystemProvidedConstants.DATAIKU_PROJECT.blueprintId;
        }
        if (artifactAutoGovernanceConfiguration instanceof ArtifactAutoGovernanceConfiguration.ModelAutoGovernanceConfiguration) {
            sentConfigurationBlueprintId = SystemProvidedConstants.DATAIKU_SAVED_MODEL.blueprintId;
        }
        if (!Objects.equals(sentConfigurationBlueprintId, artifact.blueprint.id)) {
            throw new ValidationException("Sent configuration does not correspond to the artifact blueprint in base, which is " + artifact.blueprint.id);
        }
        if (creation) {
            this.autoGovernConfigurationDAO.create(artifactAutoGovernanceConfiguration);
        } else {
            this.autoGovernConfigurationDAO.save(artifactAutoGovernanceConfiguration);
        }
    }

    @Override
    @GHMandatoryTransaction
    public ArtifactAutoGovernanceConfigurationWithResolvedParent upsertDSSArtifactAutoGovernConfiguration(ArtifactAutoGovernanceConfiguration artifactAutoGovernanceConfiguration) throws IOException {
        this.storeDSSArtifactAutoGovernConfiguration(artifactAutoGovernanceConfiguration, !this.autoGovernConfigurationDAO.exists(artifactAutoGovernanceConfiguration.artifactId));
        return this.getAutoGovernanceConfigurationWithResolvedParent(this.artifactsDataService.getArtifact(artifactAutoGovernanceConfiguration.artifactId));
    }

    @Override
    @GHMandatoryTransaction
    public void deleteDSSArtifactAutoGovernConfiguration(String artifactId) throws IOException {
        if (!this.autoGovernConfigurationDAO.exists(artifactId)) {
            throw new ValidationException("Autogovern Configuration for artifact ID: " + artifactId + " doesn't exist");
        }
        this.autoGovernConfigurationDAO.delete(artifactId);
    }

    @Override
    @GHMandatoryTransaction
    public DefaultAutoGovernanceConfiguration upsertInstanceAutoGovernConfiguration(DefaultAutoGovernanceConfiguration defaultAutoGovernanceConfiguration) throws IOException {
        return (DefaultAutoGovernanceConfiguration)this.governConfigurationDataService.upsertConfigurationItem(defaultAutoGovernanceConfiguration);
    }

    @Override
    @GHMandatoryTransaction
    public DefaultAutoGovernanceConfiguration getInstanceDefaultProjectAutoGovernConfiguration() throws IOException {
        DefaultAutoGovernanceConfiguration cfg = (DefaultAutoGovernanceConfiguration)this.governConfigurationDataService.getConfigurationItemOrNull("default-autogovern");
        if (cfg != null) {
            return cfg;
        }
        return DefaultAutoGovernanceConfiguration.build(ArtifactAutoGovernanceConfiguration.InstanceAutoGovernanceConfiguration.build(AutoGovernanceConfiguration.buildDoNothing(), AutoGovernanceConfiguration.buildDoNothing(), AutoGovernanceConfiguration.buildDoNothing(), AutoGovernanceConfiguration.buildDoNothing()), "");
    }
}

