/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.plugins;

import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PluginsClazzLoader {
    private List<String> directories = Lists.newArrayList();
    private List<String> files = Lists.newArrayList();
    private List<String> recursiveDirectories = Lists.newArrayList();
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.plugins.clazzloader");

    public PluginsClazzLoader withJarsInRecursiveDir(String path) {
        this.recursiveDirectories.add(path);
        return this;
    }

    public PluginsClazzLoader withJarsInRecursiveDirs(String ... paths) {
        this.recursiveDirectories.addAll(Lists.newArrayList((Object[])paths));
        return this;
    }

    public PluginsClazzLoader withDir(String path) {
        this.directories.add(path);
        return this;
    }

    public PluginsClazzLoader withDirs(String ... paths) {
        this.directories.addAll(Lists.newArrayList((Object[])paths));
        return this;
    }

    public PluginsClazzLoader withFile(String path) {
        this.files.add(path);
        return this;
    }

    public PluginsClazzLoader withFiles(String ... paths) {
        this.files.addAll(Lists.newArrayList((Object[])paths));
        return this;
    }

    private List<File> getFiles() throws IOException {
        File file;
        final ArrayList deps = Lists.newArrayList();
        for (String directory : this.recursiveDirectories) {
            File directoryFile = new File(directory);
            if (directoryFile.exists()) {
                Files.walkFileTree(directoryFile.toPath(), new HashSet<FileVisitOption>(), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        if (file.toString().endsWith(".jar")) {
                            deps.add(file.toFile());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                continue;
            }
            logger.warn((Object)("Path " + directory + " doesn't exist"));
        }
        for (String filePath : this.directories) {
            file = new File(filePath);
            if (file.exists() && file.isDirectory()) {
                deps.add(file);
                continue;
            }
            logger.warn((Object)("Path " + filePath + " doesn't exist or is not a directory"));
        }
        for (String filePath : this.files) {
            file = new File(filePath);
            if (file.exists()) {
                deps.add(file);
                continue;
            }
            logger.warn((Object)("Path " + filePath + " doesn't exist"));
        }
        return deps;
    }

    private ClassLoader getClassLoader() throws IOException {
        ArrayList urls = Lists.newArrayList();
        for (File file : this.getFiles()) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                logger.warn((Object)("Path " + file.getAbsolutePath() + " could not be transformed into URL"), (Throwable)e);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[0]));
    }

    public <T> T newInstance(String className) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, InvocationTargetException, IllegalAccessException, IOException {
        logger.info((Object)("Loading class " + className));
        ClassLoader classLoader = this.getClassLoader();
        Class<?> clazz = classLoader.loadClass(className);
        Constructor<?> bestConstructor = clazz.getConstructor(new Class[0]);
        if (bestConstructor == null) {
            throw new InstantiationException("No empty constructor declared");
        }
        logger.info((Object)"Instantiating class instance with empty constructor");
        bestConstructor.setAccessible(true);
        return (T)bestConstructor.newInstance(new Object[0]);
    }
}

