/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.api;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.NoRemoteFutureService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.security.IPermissionsService;
import com.dataiku.gh.security.auth.MetaAuthService;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi/futures"})
public class PublicAPIFuturesController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private NoRemoteFutureService futureService;
    @Autowired
    private IPermissionsService permissionsService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.api.futures");

    private boolean canAccess(AuthCtx authCtx, FutureResponse<?> fr) throws UnauthorizedException, DKUSecurityException {
        return this.permissionsService.isAdmin(authCtx) || StringUtils.equals((String)fr.owner, (String)authCtx.getAssociatedDSSUserOrIdentifier());
    }

    @AuditedCall(value={"msgType", "futures-list"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false, defaultValue="false") boolean allUsers, @RequestParam(required=false, defaultValue="false") boolean withScenarios, @RequestParam(required=false, defaultValue="true") boolean withNotScenarios) throws Exception {
        ArrayList updates = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            if (!allUsers && StringUtils.isBlank((String)authCtx.getDSSUserForImpersonation())) {
                throw new IllegalArgumentException("No user associated to the call, cannot list futures (the call is using an API key without impersonated user)");
            }
            Map allFutures = allUsers ? this.futureService.getAllThreads() : this.futureService.getThreads(authCtx.getDSSUserForImpersonation());
            for (Map.Entry running : allFutures.entrySet()) {
                FutureResponse fr;
                if (!withNotScenarios || (fr = this.futureService.getProgress((String)running.getKey())) == null || !this.canAccess(authCtx, fr)) continue;
                updates.add(fr);
            }
            Collections.sort(updates, new Comparator<FutureResponse<?>>(){

                @Override
                public int compare(FutureResponse<?> r0, FutureResponse<?> r1) {
                    return -((int)(r0.startTime - r1.startTime));
                }
            });
        }
        PublicAPIFuturesController.writeJSON((HttpServletResponse)resp, (Object)updates);
    }

    @AuditedCall(value={"msgType", "future-get", "futureId", "${jobId}"})
    @RequestMapping(value={"/{jobId}"}, method={RequestMethod.GET})
    @ResponseBody
    public FutureResponse<?> get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String jobId, @RequestParam(required=false, defaultValue="false") boolean peek) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        FutureResponse fr = this.futureService.getProgress(jobId);
        if (fr == null) {
            throw new IllegalArgumentException("No future by that id");
        }
        t = this.transactionService.beginRead();
        try {
            if (!this.canAccess(authCtx, fr)) {
                throw new DKUSecurityException("Insufficient rights to inspect future");
            }
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        if (!peek) {
            fr = this.futureService.getUpdate(jobId);
        }
        return fr;
    }

    @AuditedCall(value={"msgType", "future-abort", "futureId", "${jobId}"})
    @RequestMapping(value={"/{jobId}"}, method={RequestMethod.DELETE})
    public void abort(HttpServletRequest req, HttpServletResponse resp, @PathVariable String jobId) throws IOException, DKUSecurityException {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        FutureResponse fr = this.futureService.getProgress(jobId);
        if (fr == null) {
            throw new IllegalArgumentException("No future by that id");
        }
        try (Transaction t = this.transactionService.beginRead();){
            if (!this.canAccess(authCtx, fr)) {
                throw new DKUSecurityException("Insufficient rights to abort future");
            }
        }
        this.futureService.abort(jobId, authCtx);
    }
}

