/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.services;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.TransactionProvider;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.CachedReadFS;
import com.dataiku.dip.transactions.git.CommitDef;
import com.dataiku.dip.transactions.git.DSSCommitDef;
import com.dataiku.dip.transactions.git.jgit.JGitManager;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.transactions.ifaces.UserEditable;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.security.GHAuthCtx;
import com.dataiku.gh.transactions.git.GHTransactionProviderSettings;
import com.dataiku.gh.transactions.git.jgit.GHSingleRepositoryGitManager;
import com.google.common.annotations.VisibleForTesting;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;

public class DKUTransactionService
implements AutoCloseable,
TransactionService {
    private File configDir;
    private TransactionProvider provider;

    public DKUTransactionService() throws IOException {
        this.configDir = new File(ApplicationConfigurator.getBaseFolderF(), "config");
        this.provider = new TransactionProvider(this.configDir, (TransactionProvider.TransactionProviderSettings)new GHTransactionProviderSettings(false, true, true));
    }

    public DKUTransactionService(boolean gitSupport) throws IOException {
        this.configDir = new File(ApplicationConfigurator.getBaseFolderF(), "config");
        this.provider = new TransactionProvider(this.configDir, (TransactionProvider.TransactionProviderSettings)new GHTransactionProviderSettings(false, true, gitSupport));
    }

    public DKUTransactionService(File anotherRoot, boolean exclusive) throws IOException {
        this.configDir = anotherRoot;
        this.provider = new TransactionProvider(this.configDir, (TransactionProvider.TransactionProviderSettings)new GHTransactionProviderSettings(exclusive, true, true));
    }

    @VisibleForTesting
    public DKUTransactionService(boolean gitSupport, boolean forceCacheV1) throws IOException {
        this.configDir = new File(ApplicationConfigurator.getBaseFolderF(), "config");
        this.provider = new TransactionProvider(this.configDir, (TransactionProvider.TransactionProviderSettings)new GHTransactionProviderSettings(false, forceCacheV1, gitSupport));
    }

    public void changeRoot(File anotherRoot, boolean exclusive, boolean gitSupport) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        this.provider.close();
        this.configDir = anotherRoot;
        this.provider = new TransactionProvider(anotherRoot, (TransactionProvider.TransactionProviderSettings)new GHTransactionProviderSettings(exclusive, true, gitSupport));
    }

    public RWTransaction beginWriteForUI(HttpServletRequest req, boolean checkXSRF) throws IOException {
        throw new NotImplementedException();
    }

    public RWTransaction beginWriteForUI(HttpServletRequest req) throws IOException {
        throw new NotImplementedException();
    }

    public RWTransaction beginWriteForAPI(HttpServletRequest req) throws IOException {
        throw new NotImplementedException();
    }

    public RWTransaction beginWriteForTicket(HttpServletRequest req) throws IOException {
        throw new NotImplementedException();
    }

    public RWTransaction beginWriteAsLoggedInUser(AuthCtx usr, boolean committable) {
        assert (usr != null) : "User cannot be null";
        TransactionContext.assertNoAttachedTransaction();
        if (this.provider == null) {
            throw new RuntimeException("The DKU transaction provider has been closed");
        }
        RWTransaction rw = this.provider.beginWrite(usr, committable);
        try {
            ((UserEditable)rw).setUser(usr);
            TransactionContext.attach((TransactionRef)rw);
            return rw;
        }
        catch (Throwable t) {
            rw.close();
            throw t;
        }
    }

    public RWTransaction beginWriteAsDSS(boolean committable) {
        GHAuthCtx dss = GHAuthCtx.newNone();
        return this.beginWriteAsLoggedInUser(dss, committable);
    }

    public Transaction beginRead(IsolationLevel isolationLevel, @Nullable String fakeStack) {
        TransactionContext.assertNoAttachedTransaction();
        if (this.provider == null) {
            throw new RuntimeException("The DKU transaction provider has been closed");
        }
        Transaction t = this.provider.beginRead(isolationLevel, fakeStack);
        TransactionContext.attach((TransactionRef)t);
        return t;
    }

    public File resolve(RelFile file) {
        return file.resolve(this.configDir);
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.provider != null) {
            this.provider.close();
            this.provider = null;
        }
    }

    public JGitManager getGitManager() {
        GHSingleRepositoryGitManager gitManager = null;
        try {
            gitManager = new GHSingleRepositoryGitManager(this.configDir);
        }
        catch (Exception ex) {
            throw new NotImplementedException("unable to setup jGitManager");
        }
        return gitManager;
    }

    public void performDirectCommit(DSSCommitDef def) throws IOException {
        this.provider.performDirectCommit((CommitDef)def);
    }

    public void flushPendingCommits(String projectKey) throws IOException {
        this.provider.flushPendingCommits(projectKey);
    }

    public void clearCache() {
        this.provider.clearCache();
    }

    public void invalidateCache(RelFile file) {
        this.provider.invalidateCache(file);
    }

    public CachedReadFS getCache() {
        return this.provider.getCache();
    }
}

