/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.feature.visitor.CalcResult;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class AbstractCalcResult
implements CalcResult {
    @Override
    public boolean isCompatible(CalcResult targetResults) {
        return targetResults == CalcResult.NULL_RESULT;
    }

    @Override
    public CalcResult merge(CalcResult resultsToAdd) {
        if (resultsToAdd == CalcResult.NULL_RESULT) {
            return this;
        }
        if (!this.isCompatible(resultsToAdd)) {
            throw new IllegalArgumentException("Parameter is not a compatible type");
        }
        throw new IllegalArgumentException("The CalcResults claim to be compatible, but the appropriate merge method has not been implemented.");
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public int toInt() {
        Object value = this.getValue();
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        return 0;
    }

    @Override
    public double toDouble() {
        Object value = this.getValue();
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        return 0.0;
    }

    @Override
    public long toLong() {
        Object value = this.getValue();
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.longValue();
        }
        return 0L;
    }

    @Override
    public float toFloat() {
        Object value = this.getValue();
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.floatValue();
        }
        return 0.0f;
    }

    @Override
    public Geometry toGeometry() {
        Object value = this.getValue();
        if (value instanceof Geometry) {
            return (Geometry)this.getValue();
        }
        return null;
    }

    @Override
    public Envelope toEnvelope() {
        Object value = this.getValue();
        if (value instanceof Envelope) {
            return (Envelope)value;
        }
        return null;
    }

    @Override
    public Point toPoint() {
        Geometry geometry = this.toGeometry();
        return geometry.getCentroid();
    }

    @Override
    public Set toSet() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof Set) {
            Set set = (Set)value;
            return set;
        }
        if (value.getClass().isArray()) {
            Object[] cast = (Object[])value;
            HashSet<Object> set = new HashSet<Object>(Arrays.asList(cast));
            return set;
        }
        if (value instanceof Collection) {
            Collection cast = (Collection)value;
            HashSet set = new HashSet(cast);
            return set;
        }
        return null;
    }

    @Override
    public List toList() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            List list = (List)value;
            return list;
        }
        if (value.getClass().isArray()) {
            return Arrays.asList((Object[])value);
        }
        if (value instanceof HashSet) {
            HashSet set = (HashSet)value;
            return Arrays.asList(set.toArray());
        }
        if (value instanceof Collection) {
            Collection cast = (Collection)value;
            return new ArrayList(cast);
        }
        return null;
    }

    @Override
    public Object[] toArray() {
        List list = this.toList();
        if (list == null) {
            return null;
        }
        return list.toArray();
    }

    public String[] toStringArray() {
        List list = this.toList();
        if (list == null) {
            return null;
        }
        String[] strings = list.toArray(new String[list.size()]);
        return strings;
    }

    @Override
    public Map toMap() {
        return (Map)this.getValue();
    }

    @Override
    public String toString() {
        return this.getValue().toString();
    }
}

